/* Author: Balakrishnan Rukmangathan 
   cs_funcs.c : These are functions used by the us to communicate
   with the synchronisation site */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <unistd.h>
#include <fcntl.h>


#include "defns.h"
#include "pdfs.h"
#include "cs2us_msgfmt.h"

extern int synch_fd;
extern char *print_fh(pdfs_fh *);
extern void update_fh(pdfs_fh *, pdfs_fh *, char *);
extern void revert_fh(pdfs_fh *);
extern void clean_up();

int recv_until(cs2us_msg *, int , int );
void read_attr(sattr *);
int check_fname(char *);

int mount(char *synch_addr,pdfs_fh *root_fh, char *srvr_addr)
{
	// mount the filesystem governed by the synch_addr.
	// the address is in the dotted-quad notation

        cs2us_msg pkt;
        struct sockaddr_in Srvraddr;

        // create a stream socket to the synchornisation site

        if ((synch_fd = socket(AF_INET,SOCK_STREAM,0))< 0) {
                perror("Synch socket cannot be created ");
		printf("Mounting unsuccessful \n");
		exit(1);
	}

	bzero(&Srvraddr,sizeof(Srvraddr));
	Srvraddr.sin_family = AF_INET;
	Srvraddr.sin_port = htons(CS_DEAMON_PORT);
	Srvraddr.sin_addr.s_addr = inet_addr(synch_addr);
        printf("The srvr address : %s-%d\n",inet_ntoa(Srvraddr.sin_addr),
		ntohs(Srvraddr.sin_port));

        // make the connection to the synchronisation server

       if (connect(synch_fd,(struct sockaddr *)&Srvraddr, 
				sizeof(Srvraddr)) < 0) {
               perror("Error in the connect system call");
		printf("Mounting unsuccessful \n");
		exit(1);
	}
	// connection established. now on reply will have
	// the root filehandle

	memset(&pkt,0,sizeof(pkt));

	if (recv(synch_fd,&pkt,sizeof(pkt),MSG_WAITALL) < sizeof(pkt)) {
		printf("Received an illegal message size \n");
		printf("Mounting unsuccessful \n");
		exit(1);
	}
	// now the pkt holds the root file handle
	if (ntohs(pkt.msg_code) != MSG_CS2US_MOUNT ) {
		printf("Mounting unsuccessful \n");
		exit(1);
	}
	memcpy(root_fh,&pkt.args.acc_args.fh,PDFS_FHSIZE);
	strcpy(srvr_addr,pkt.args.acc_args.ss_addr);
	printf("The root file handle is %s \n",print_fh(root_fh));
	return 1;
}


int f_register(pdfs_fh *fh, u_short mode, char *ss_addr, char *fname)
{
	cs2us_msg pkt;

	printf("Going to register the file %s\n",fname);
	memset(&pkt,0,sizeof(pkt));
	pkt.msg_code = htons(MSG_US2CS_REGISTER);
	memcpy(&(pkt.args.acc_args.fh),fh,PDFS_FHSIZE);
	strcpy(pkt.args.acc_args.ss_addr,ss_addr);
	pkt.args.acc_args.mode = htons(mode);
	strcpy(pkt.args.acc_args.fname,fname);
	printf("Registering for file %s",fname);
	printf("length is %d\n",strlen(fname));
	if (send(synch_fd,&pkt,sizeof(pkt),0) < sizeof(pkt)) {
		printf("Cannot be registered \n");
		exit(1);
	}
	memset(&pkt,0,sizeof(cs2us_msg));
while (1) {

	if (recv(synch_fd,&pkt,sizeof(pkt),MSG_WAITALL) < sizeof(pkt)) {
		printf("received an improper reply\n");
		clean_up();
		exit(1);
	}
	// its possible to get another callback here so do that also
	// this is an asynchronous callback 
	if (ntohs(pkt.msg_code) == MSG_CS2US_REGISTEROK) {
		printf("Everything ok \n");
		return 1;
	}
	if  (ntohs(pkt.msg_code) == MSG_CS2US_CALLBACK)  {
	    printf("Need to do the callback here \n");
	    update_fh(&pkt.args.cbk_args.fh,&pkt.args.cbk_args.new_fh, 
					pkt.args.cbk_args.ss_addr);
	    if (!memcmp(&pkt.args.cbk_args.fh,fh,PDFS_FHSIZE)) 
		       return 1;
	     continue;
	}
	if (ntohs(pkt.msg_code) == MSG_CS2US_REUSEFH ) {
		printf("Message to reuse an fh \n");
		revert_fh(&pkt.args.cbk_args.fh);
		continue;
	}
	else {
		printf("Received an unknonw message while registering \n");
		return -1;
	}
	// loop until u get the response from the storage server
	// fault tolerance not considered.
} // end of while
} // end of register


int unregister(pdfs_fh *fh, u_short mode, char *ss_addr, char *fname)
{
        cs2us_msg pkt;

        printf("Going to unregister the file %s\n",fname);
	memset(&pkt,0,sizeof(cs2us_msg));
        pkt.msg_code = htons(MSG_US2CS_UNREGISTER);
        strcpy(pkt.args.acc_args.ss_addr,ss_addr);
        pkt.args.acc_args.mode = htons(mode);
        memcpy(&(pkt.args.acc_args.fh),fh,PDFS_FHSIZE);
        strcpy(pkt.args.acc_args.fname,fname);
        if (send(synch_fd,&pkt,sizeof(pkt),0) < sizeof(pkt) ) {
                printf("Cannot be unregistered \n");
		exit(1);
        }
	// we dont expect anything while unregistering.
	return 1;
} // end of unregister


int  unmount()
{
	cs2us_msg pkt;
	memset(&pkt,0,sizeof(pkt));
        pkt.msg_code = htons(MSG_US2CS_UNMOUNT);
        if (send(synch_fd,&pkt,sizeof(pkt),0) < sizeof(pkt) ) {
                printf("Cannot be unmounted \n");
                exit(1);
        }
	// you dont expect to get anything from the synch site
	// do the clean up here
	clean_up();
	close(synch_fd);
        return 1;
} // end of unmount

void create_file()
{ 
	cs2us_msg pkt;
	memset(&pkt,0,sizeof(pkt));
	printf("Creating a file \n");
	pkt.msg_code = htons(MSG_US2CS_CREATE);
	// fill the user info here
	fflush(stdin);
	printf("Enter the name of directory where to create \t");
	scanf("%s", pkt.args.cr_args.dir_name);
	fflush(stdin);
	if ( !strcmp(pkt.args.cr_args.dir_name, "..") ) {
		printf("Creation in .. is not allowed \n");
		return ;
	}
	printf("Enter the name of the file \t");
	scanf("%s", pkt.args.cr_args.f_name);
	if ( !check_fname(pkt.args.cr_args.f_name) )  {
		printf("Creating ../. is not allowed \n");
		return ;
	}
	printf("Enter the mode for the file to be created \n");
	printf(" read(4) - write(2) - exec(1) - none(0) : add the permissions \n");
	fflush(stdin);
	// fill the attributes here
	read_attr(&pkt.args.cr_args.f_attribs);
	printf("The mode is %d",ntohl(pkt.args.cr_args.f_attribs.mode));
	if ( send(synch_fd, &pkt, sizeof(pkt), 0) < sizeof(pkt)) {
		printf("unable to contact synch site \n");
		exit(1);
	}
/*
	if ( recv(synch_fd, &pkt, sizeof(pkt), MSG_WAITALL) < sizeof(pkt) ) {
		printf("unable to get reply from synch site \n");
	}
*/
	if (recv_until(&pkt,MSG_CS2US_CREATE,synch_fd) == -1000) {
		printf("CREATE FILE: Error in getting the reply from the synch site \n");
		exit(1);
	}
	
	if (ntohs(pkt.args.status) == PDFS_OK) {
		printf("Successfully created the file \n");
		return ;
	}
	else errno = ntohs(pkt.args.status);
	perror("Error in create is \n");
} // end of file create


void create_dir()
{ 
	cs2us_msg pkt;
	memset(&pkt,0,sizeof(pkt));
	printf("Creating a directory \n");
	pkt.msg_code = htons(MSG_US2CS_CREATEDIR);
	// fill the user info here
	fflush(stdin);
	printf("Enter the name of directory where u want to create \t");
	scanf("%s", pkt.args.cr_args.dir_name);
	fflush(stdin);

	if ( !strcmp(pkt.args.cr_args.dir_name, "..") ) {
		printf("Creation in .. is not allowed \n");
		return ;
	}
	printf("Enter the name of the directory to be created \t");
	scanf("%s", pkt.args.cr_args.f_name);
	if ( !check_fname(pkt.args.cr_args.f_name) )  {
		printf("Creating ../. is not allowed \n");
		return ;
	}

	// fill the attributes here
	printf("Enter the mode for the dir to be created \n");
	printf(" read(4) - write(2) - exec(1) - none(0) : add the permissions \n");
	fflush(stdin);
	// fill the attributes here
	read_attr(&pkt.args.cr_args.f_attribs);
	printf("The mode is %d",ntohl(pkt.args.cr_args.f_attribs.mode));
	if ( send(synch_fd, &pkt, sizeof(pkt), 0) < sizeof(pkt)) {
		printf("unable to contact synch site \n");
		exit(1);
	}
/*
	if ( recv(synch_fd, &pkt, sizeof(pkt), MSG_WAITALL) < sizeof(pkt) ) {
		printf("unable to get reply from synch site \n");
	}
*/
	if (recv_until(&pkt,MSG_CS2US_CREATEDIR,synch_fd) == -1000) {
		printf("CREATE DIR: Error in getting the reply from the synch site \n");
		exit(1); 
	}
	
	if (ntohs(pkt.args.status) == PDFS_OK) {
		printf("Successfully created the directory \n");
		return ;
	}
	else errno = ntohs(pkt.args.status);
	perror("Error in create Directory is \n");
}


void delete_file()
{ 
	cs2us_msg pkt;
	memset(&pkt,0,sizeof(pkt));
	printf("Deleting a file \n");
	pkt.msg_code = htons(MSG_US2CS_DELETE);
	// fill the user info here
	fflush(stdin);
	printf("Enter the name of directory where u want to delete\t");
	scanf("%s", pkt.args.cr_args.dir_name);
	fflush(stdin);
	if ( !strcmp(pkt.args.cr_args.dir_name, "..") ) {
		printf("Deletion in .. is not allowed \n");
		return ;
	}
	printf("Enter the name of the file to be deleted \t");
	scanf("%s", pkt.args.cr_args.f_name);
	if ( !check_fname(pkt.args.cr_args.f_name) )  {
		printf("Deleting ../. is not allowed \n");
		return ;
	}
	if ( send(synch_fd, &pkt, sizeof(pkt), 0) < sizeof(pkt)) {
		printf("unable to contact synch site \n");
		exit(1);
	}
/*
	if ( recv(synch_fd, &pkt, sizeof(pkt), MSG_WAITALL) < sizeof(pkt) ) {
		printf("unable to get reply from synch site \n");
	}
*/
	if (recv_until(&pkt,MSG_CS2US_DELETE,synch_fd) == -1000) {
		printf("DELETE FILE: Error in getting the reply from the synch site \n");
		exit(1); 
	}

	if (ntohs(pkt.args.status) == PDFS_OK) {
		printf("Successfully Deleted the file \n");
		return ;
	}
	else errno = ntohs(pkt.args.status);
	perror("Error in Delete a file is \n");
}// end of file delete


void delete_dir()
{ 
	cs2us_msg pkt;
	memset(&pkt,0,sizeof(pkt));
	printf("Deleting a directory \n");
	pkt.msg_code = htons(MSG_US2CS_DELETEDIR);
	// fill the user info here
	fflush(stdin);
	printf("Enter the name of directory where u want to delete\t");
	scanf("%s", pkt.args.cr_args.dir_name);
	fflush(stdin);
	if ( !strcmp(pkt.args.cr_args.dir_name, "..") ) {
		printf("Deletion in .. is not allowed \n");
		return ;
	}
	printf("Enter the name of the directory to be deleted \t");
	scanf("%s", pkt.args.cr_args.f_name);
	if ( !check_fname(pkt.args.cr_args.f_name) )  {
		printf("Delete ../. is not allowed \n");
		return ;
	}
	// fill the attributes here
	if ( send(synch_fd, &pkt, sizeof(pkt), 0) < sizeof(pkt)) {
		printf("unable to contact synch site \n");
		exit(1);
	}
/*
	if ( recv(synch_fd, &pkt, sizeof(pkt), MSG_WAITALL) < sizeof(pkt) ) {
		printf("unable to get reply from synch site \n");
	}
*/
	if (recv_until(&pkt,MSG_CS2US_DELETEDIR,synch_fd) == -1000) {
		printf("DELETE DIR: Error in getting the reply from the synch site \n");
		exit(1); 
	}
	
	if (ntohs(pkt.args.status) == PDFS_OK) {
		printf("Successfully Deleted the directory \n");
		return ;
	}
	else errno = ntohs(pkt.args.status);
	perror("Error in Delete a directory is \n");
}


void csd_rename()
{ 
	cs2us_msg pkt;
	memset(&pkt,0,sizeof(pkt));
	printf("Renaming a file/directory \n");
	pkt.msg_code = htons(MSG_US2CS_RENAME);
	// fill the user info here
	fflush(stdin);
	printf("Enter the name of file/directory u want to rename\t");
	scanf("%s", pkt.args.ren_args.from);
	fflush(stdin);
	if ( !check_fname(pkt.args.ren_args.from) ) {
		printf("Renaming the root directory/.. is not allowed \n");
		return ;
	}
	printf("Enter the new name of the file/directory \t");
	scanf("%s", pkt.args.ren_args.to);
	if ( !check_fname(pkt.args.ren_args.to) ) {
		printf("Renaming to root directory/.. is not allowed \n");
		return ;
	}
	// fill the attributes here
	if ( send(synch_fd, &pkt, sizeof(pkt), 0) < sizeof(pkt)) {
		printf("unable to contact synch site \n");
		exit(1);
	}
/*
	if ( recv(synch_fd, &pkt, sizeof(pkt), MSG_WAITALL) < sizeof(pkt) ) {
		printf("unable to get reply from synch site \n");
	}
*/
	if (recv_until(&pkt,MSG_CS2US_RENAME,synch_fd) == -1000) {
		printf("RENAME : Error in getting the reply from the synch site \n");
		exit(1); 
	}
	if (ntohs(pkt.args.status) == PDFS_OK) {
		printf("Successfully Renamed the file/directory \n");
		return ;
	}
	else errno = ntohs(pkt.args.status);
	perror("Error in Rename is \n");
}


void read_attr(sattr *attribs)
{
	mode_t mode = 0;
	int user;
        printf("User:\t");
        scanf("%d",&user);
        mode |= (user == 7 ) ?  S_IRWXU : (user == 6) ? S_IRUSR | S_IWUSR : (user == 5) ? S_IRUSR | S_IXUSR : (user == 4) ? S_IRUSR : (user == 3) ? S_IWUSR | S_IXUSR : (user == 2) ? S_IWUSR : (user == 1 ) ? S_IXUSR : 0;
        fflush(stdin);
        printf("Group:\t");
        scanf("%d",&user);
        mode |= (user == 7 ) ?  S_IRWXG :  (user == 6) ? (S_IRGRP | S_IWGRP ): ( user == 5) ? (S_IRGRP | S_IXGRP ) : (user == 4) ? S_IRGRP : (user == 3) ? ( S_IWGRP | S_IXGRP ) : (user == 2) ? S_IWGRP : (user == 1 ) ? S_IXGRP : 0;
        fflush(stdin);
        printf("Others:\t");
        scanf("%d",&user);
 	mode |= (user == 7 ) ?  S_IRWXO : (user == 6) ? S_IROTH | S_IWOTH : (user == 5) ? S_IROTH | S_IXOTH : (user == 4) ? S_IROTH : (user == 3) ? S_IWOTH | S_IXOTH : (user == 2) ? S_IWOTH : (user == 1 ) ? S_IXOTH : 0; 
	fflush(stdin);
	attribs->mode = htonl(mode);
	return ; 
}


int recv_until(cs2us_msg *pkt, int msgcode, int sockfd)
{
	// receive until the msgcode is received from the synch site
	// u might be getting some callback and revert messages from the 
	// synchronisation site - This is an asynchronous message

while (1) {
	memset(pkt,0,sizeof(cs2us_msg));
	if (recv(sockfd, pkt, sizeof(cs2us_msg), MSG_WAITALL) < 
		sizeof(cs2us_msg)) {
	printf("Received an illegal size of packet \n");
	return -1000;
	}
	printf("A proper packet has arrived from synchronisation site \n");
	if (msgcode == ntohs(pkt->msg_code))
		return ntohs(pkt->args.status);
	if (ntohs(pkt->msg_code) == MSG_CS2US_CALLBACK) {
		printf("Received an callback \n");
		update_fh(&pkt->args.cbk_args.fh,&pkt->args.cbk_args.new_fh,
                                        pkt->args.cbk_args.ss_addr);
		continue ;	
	}
	if (ntohs(pkt->msg_code) == MSG_CS2US_REUSEFH ) {
		printf("Received an reuse message \n");
		revert_fh(&pkt->args.cbk_args.fh);
		continue ;
	}
	// you should not receive any other type of messages:
	printf("Received an illegal message while waiting \n");
	printf("The message received is %d",ntohs(pkt->msg_code));
	return -1000;
} // end of while
} // end of recv_until
	
int check_fname(char *fname)
{
if ( !strcmp(fname, ".") || !strcmp(fname, "..") ) 
		return 0;
return 1;
}

int check_synchfd(int sockfd)
{
	fd_set temp_fds;
	struct timeval timeout;
	cs2us_msg pkt;
	int no_ready = 0;


	FD_ZERO(&temp_fds);
	memset(&pkt,0,sizeof(pkt));
  	timeout.tv_sec = 0;
        timeout.tv_usec = 0;
 	FD_SET(sockfd,&temp_fds);
	no_ready = select(256, &temp_fds, NULL, NULL,&timeout);
	if (no_ready == 1 ) {
		printf("Synchronisation site is ready for reading \n");
	if (recv(sockfd, &pkt, sizeof(cs2us_msg), MSG_WAITALL) < 
		sizeof(cs2us_msg)) {
	printf("Received an illegal size of packet from synch\n");
		exit(1);
	}
	printf("A proper packet has arrived from synchronisation site \n");
	if (ntohs(pkt.msg_code) == MSG_CS2US_CALLBACK) {
		printf("Received an callback \n");
		update_fh(&pkt.args.cbk_args.fh,&pkt.args.cbk_args.new_fh,
                                        pkt.args.cbk_args.ss_addr);
	}
	if (ntohs(pkt.msg_code) == MSG_CS2US_REUSEFH ) {
		printf("Received an reuse message \n");
		revert_fh(&pkt.args.cbk_args.fh);
	}
	// you should not receive any other type of messages:
	printf("Finished processing the synchffd \n");
	return 1 ;
	}
	if (no_ready == 0) {
		printf("Nothing on the synch fd, going on .. \n");
		return 0;
	}
	printf("Some problem in the select of check_synchfd\n");
	exit(1); 
}
