/* Author: Rukmangathan Balakrishnan 
   update.c
   Functions used for updating a file
*/


#include<stdio.h>
#include<unistd.h>
#include<signal.h>
#include<fcntl.h>
#include<stdlib.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/socket.h>
#include<arpa/inet.h>
#include<netinet/in.h>
#include <string.h>

#include "pdfs.h"
#include "defns.h"
#include "cs2ss_msgfmt.h"


extern void log_write();
extern int my_recv(int , char *);
extern char export_root[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN+1];


/* The server holding the primary copy calls this function */

void process_update(int update_sock)
{
	struct sockaddr_in clntaddr;
	struct stat sbuff;
	char *buff,*fname;
	int newsockfd,addrlen,filefd,nbytes;	
	unsigned long u_size=0;

	buff = (char *) malloc(sizeof(char)*(PDFS_MAXPATHLEN+PDFS_MAXNAMELEN));
	memset(&clntaddr,0,sizeof(clntaddr));
	printf("Received a connect request from a Storage site \n");
        newsockfd = accept(update_sock,(struct sockaddr *)&clntaddr,
                                &addrlen);
        log_write("Site %s has sent a Update request \n",
                                inet_ntoa(clntaddr.sin_addr));
        printf("Site %s has sent a Update request \n",
                                inet_ntoa(clntaddr.sin_addr));
	nbytes = my_recv(newsockfd,buff);
        printf("No. of bytes received is %d\n",nbytes);
	buff[nbytes] = '\0';

	printf("File name is %s \n",buff);
	log_write("File name is %s \n",buff);
	printf("Actual file name is %s %s\n",export_root,buff);
	fname = (char *)malloc(sizeof(char)*(strlen(export_root)+nbytes));
	strcpy(fname,export_root);
	if (fname[strlen(export_root)-1] == '/') 
		fname[strlen(export_root)-1] = '\0';
	strcat(fname,buff);

	printf("The constructed file name is %s\n",fname); 

	if ( (filefd = open(fname,O_RDONLY)) < 0 ) {
		perror("Error in opening the file :");
		log_write("Error in opening the file :");
		// fault tolerant issue
		close(newsockfd);
		return;
	}
	free(fname);
	memset(&sbuff,0,sizeof(sbuff));
	if (fstat(filefd, &sbuff) < 0 ) {
		perror("Error in stating the fiel :");
		log_write("Error in stating the file :");
		// fault tolerant issue 
		close(newsockfd);
		return;
	}
	free(buff); // reheap the allocated memory
	buff = (char *) malloc(sizeof(char) * sbuff.st_size);
 	if (read(filefd, buff, sbuff.st_size) < sbuff.st_size) {
		perror("Error in completely reading the file :");
		log_write("Error in completely reading the file :");
		close(newsockfd);
		return;
	}
	close(filefd);
	// send the length 
	u_size = htonl(sbuff.st_size);
	if (send(newsockfd, &u_size,sizeof(u_size), 0) < sizeof(u_size) ) {
		perror("Error in sending the file size :");
		log_write("Error in sending the file update :");
		close(newsockfd);
		return;
	}
	// send the file 
	if (send(newsockfd, buff, sbuff.st_size, 0) < sbuff.st_size) {
		perror("Error in sending the file update :");
		log_write("Error in sending the file update :");
		close(newsockfd);
		return;
	}
	shutdown(newsockfd, 1);
	close(newsockfd);
	free(buff);
	printf("Successfully sent the file update \n");
	log_write("Successfully sent the file update \n");
	return ;
} // end of process_update

/* The server which needs the update calls this function */

int update_file(char *ss_addr, char *fname)
{
	int sockfd,filefd;
        struct sockaddr_in srvr_addr;
	char *buff,*a_fname;
	unsigned long u_size=0;

	printf("Updating the file named %s from site %s \n",fname, ss_addr);
	log_write("Updating the file named %s from site %s \n",fname, ss_addr);
	
	// make a socket to the peers updatefd and 
	// send the file and close my side of connection

 	memset(&srvr_addr,0,sizeof(srvr_addr));
        srvr_addr.sin_family = AF_INET;
        srvr_addr.sin_port = htons(SS_UPDATE_PORT);
        srvr_addr.sin_addr.s_addr = inet_addr(ss_addr);

        if ((sockfd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) < 0) {
                        perror("Error in creating the update socket \n");
                        return -1;
        }
        if (connect(sockfd,(struct sockaddr *)&srvr_addr,
                                sizeof(srvr_addr)) < 0) {
                  perror("Error in connecting to the update socket \n");
                  close(sockfd);
                  return -1;
        }
        if (send(sockfd,fname,strlen(fname),0) != strlen(fname) ) {
                  perror("Error in sending the update request  \n");
                  close(sockfd);
                  return -1;
        }
	shutdown(sockfd,1);

        // pkt has been successfully sent. Now receive the update
	// receive the size then receive the output

	if (recv(sockfd,&u_size,sizeof(u_size),MSG_WAITALL) < sizeof(u_size) ) {
		perror("Error in receiving the size of the file \n");
		log_write("Error in receiving the size of the file \n");
                close(sockfd);
                return -1;
	}
	printf("The size of the file is %d",ntohl(u_size));
	buff = (char *)malloc(sizeof(char)*ntohl(u_size));

        if (recv(sockfd,buff,ntohl(u_size),MSG_WAITALL) < ntohl(u_size)) {
		perror("Received incomplete file update \n");
		log_write("Received incomplete file update \n");
                close(sockfd);
                return -1;
        }
	close(sockfd);
	a_fname = (char *)malloc(sizeof(char)*(strlen(export_root)+strlen(fname)));
	strcpy(a_fname,export_root);
	if (a_fname[strlen(export_root)-1] == '/') 
		a_fname[strlen(export_root)-1] = '\0';
	strcat(a_fname,fname);
	printf("The constructed file name is %s\n",a_fname); 

	if ( (filefd = open(a_fname,O_WRONLY)) < 0 ) {
		perror("Error in opening the file :");
		log_write("Error in opening the file :");
		free(buff);
		free(a_fname);
		return -1;
	}
	free(a_fname);
	// apply the update now
 	if (write(filefd, buff,ntohl(u_size)) < ntohl(u_size) ) {
		perror("Error in completely Writing the file :");
		log_write("Error in completely Writing the file :");
		free(buff);
		return -1;
	}
	free(buff);
	return 1;
	// successfully updated the file 
} // end of update_file
