/* Author: Rukmangathan Balakrishnan 
   process_req.c
   Process the PDFS client's request 
*/
#include<stdio.h>
#include<unistd.h>
#include<signal.h>
#include<fcntl.h>
#include<stdlib.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/socket.h>
#include<arpa/inet.h>
#include<netinet/in.h>

#include "pdfs.h"
#include "pdfs_deamon.h"
#include "defns.h"
#include "msg_format.h"

extern struct op_result result;
static char *read_buff;

void send_reply(HEADER *hdr, int msgcode, int serv_sock);
static int local_nbytes;

int process_req(char *buff, int nbytes, struct sockaddr_in *clnt_addr,
		int addrlen,int serv_sock)
{
HEADER hdr;
read_buff = NULL;

memcpy(&hdr,buff,sizeof(HEADER));
memset(&result,0,sizeof(result));

switch (ntohs(hdr.op_code)) {
	case MSG_US2SS_NULL : {
		printf("received the us2cs null \n");
		memset(&result,0,sizeof(result));
		result.status = pdfs_null(NULL,NULL);
		send_reply(&hdr, MSG_SS2US_NULL, serv_sock);
		break;
	}
	case MSG_US2SS_GETATTR : {
		printf("received the us2cs getattr \n");
		memset(&result,0,sizeof(result));
		result.status = pdfs_getattr(&hdr.op_args.getattr_args.fh,
				&hdr.req_info);
		send_reply(&hdr, MSG_SS2US_GETATTR, serv_sock);
		break;
	}	
	case MSG_US2SS_SETATTR : {
		printf("received the us2cs setattr \n");
		result.status = pdfs_setattr(&hdr.op_args.sattrargs,
				&hdr.req_info);
		send_reply(&hdr, MSG_SS2US_SETATTR, serv_sock);
		break;
	}
	case MSG_US2SS_ROOT : {
		printf("received the us2cs root \n");
		result.status = pdfs_root(&result.rslt.dirop_res.fh, 
				&hdr.req_info);
		send_reply(&hdr, MSG_SS2US_ROOT, serv_sock);
		break;
	}
	
	case MSG_US2SS_LOOKUP : {
		printf("received the us2cs lookup \n");
		result.status = pdfs_lookup(&(hdr.op_args.dirop_args),
				&hdr.req_info);
		send_reply(&hdr, MSG_SS2US_LOOKUP, serv_sock);
		break;
	}
	case MSG_US2SS_READ : {
		printf("received the us2cs read  \n");
		read_buff = (char *) malloc(sizeof(char)*
					ntohl(hdr.op_args.read_args.howmuch));
		result.status = pdfs_read(&hdr.op_args.read_args, 
				&hdr.req_info, read_buff);
		send_reply(&hdr, MSG_SS2US_READ, serv_sock);
		free(read_buff);
		break;
	}
	case MSG_US2SS_WRITE : {
		printf("received the us2cs write \n");
		result.status = pdfs_write( &hdr.op_args.write_args, 
				&hdr.req_info, buff+sizeof(HEADER));

		send_reply(&hdr, MSG_SS2US_WRITE, serv_sock);
		break;
	}
	case MSG_US2SS_READDIR : {
		printf("received the us2cs readdir \n");
		local_nbytes = 0;
		result.status = pdfs_readdir(&hdr.op_args.readdir_args, &hdr.req_info,&read_buff,&local_nbytes);
		send_reply(&hdr, MSG_SS2US_READDIR, serv_sock);
		break;
	}
	case MSG_US2SS_STATFS : {
		printf("received the us2cs statfs \n");
		// send_reply(MSG_SS2US_NULL,result,clnt_addr,addrlen,serv_sock);
		break;
	}

	default : {
		printf("Unknown message type %d",hdr.msg_id);
		// send_reply(MSG_SS2US_NULL,result,clnt_addr,addrlen,serv_sock);
		break;
	}

  }
printf("finished processing the message");
return 1;
}

void send_reply(HEADER *hdr, int msgcode, int serv_sock)
{

	fattr *temp_fattr;
	printf("Going to send reply to a access request ");
	hdr->op_code = htons(msgcode);
	memset(&(hdr->op_args),0,sizeof(generic_op_args));

	temp_fattr = frame_fattr(result.attr.uid, result.attr.gid, 
		 result.attr.mode,result.attr.atime,result.attr.mtime, 
		 result.attr.ctime, result.attr.ftype, result.attr.size, 
		 result.attr.nlink,result.attr.blocksize, result.attr.blocks);

	hdr->op_args.svc_result.status = htons(result.status);
	memcpy(&hdr->op_args.svc_result.attr,temp_fattr,sizeof(fattr));

	memcpy(&(hdr->op_args.svc_result.rslt),&(result.rslt),sizeof(result.rslt));

	// based on the message id do the appropriate framing
	if (msgcode == MSG_SS2US_READ) {
		hdr->op_args.svc_result.rslt.read_res.count = htonl(result.rslt.read_res.count);
	}
	if (msgcode == MSG_SS2US_READDIR) {
		hdr->op_args.svc_result.rslt.readdir_res.count = htonl(result.rslt.readdir_res.count);
	}


	// send the request reply in the header

	if (send(serv_sock,hdr,sizeof(HEADER),0) < sizeof(HEADER)) 
	{
		printf("Cannot send a access reply \n");
		close(serv_sock);
		return ;
	}

	// DO THE EXTRA SENDS HERE. WE NEED EXTRA SENDS WHEN WE DO 
	// READ AND READDIR
 
	if ( (result.status == PDFS_OK) && (msgcode == MSG_SS2US_READ) ){
			// send the read buffer also here
			send(serv_sock,read_buff,result.rslt.read_res.count,0);
	}
	if ( (result.status == PDFS_OK) && (msgcode == MSG_SS2US_READDIR) ) {
			// send the read buffer also here
			send(serv_sock,read_buff,local_nbytes,0);
	}

	// do the cleanup
	close(serv_sock);
	return ;
}
