/*  Author : Rukmangathan Balakrishnan 
    pdfs_deamon.h 
    Header file for the PDFS storage site deamons

*/

#ifndef PDFS_DEAMON_H
#define PDFS_DEAMON_H

#include "args.h"
#include "pdfs.h"

/* Global variables. */
/* Include the other module definitions. */
#include "fh_cache.h"

/* Global Function prototypes. */
extern void	mallocfailed(void);
extern pdfsstat	fh_getattr(pdfs_fh *, fattr *);
extern pdfsstat	fhc_getattr(fhcache *, fattr *);
extern pdfsstat	fh_setattr(pdfs_fh *,sattr *,struct stat *,struct svc_req *,int);
extern pdfsstat	setattr(char *, sattr *,struct stat *,struct svc_req *,int);

#define SATTR_STAT		0x01
#define SATTR_CHOWN		0x02
#define SATTR_CHMOD		0x04
#define SATTR_SIZE		0x08
#define SATTR_UTIMES		0x10
#define SATTR_ALL		(~SATTR_STAT)

pdfsstat pdfs_null(void *, struct svc_req *);
pdfsstat pdfs_getattr(pdfs_fh *, struct svc_req *);
pdfsstat pdfs_setattr(struct setattrargs *, struct svc_req *);
pdfsstat pdfs_root(pdfs_fh *, struct svc_req *);
pdfsstat pdfs_lookup(struct diropargs *, struct svc_req *);
pdfsstat pdfs_read(struct readargs *, struct svc_req *,char *);
pdfsstat pdfs_write(struct writeargs *, struct svc_req *, char *);
pdfsstat pdfs_create(struct svc_req *, char *, char *, sattr *);
pdfsstat pdfs_remove(struct svc_req *, char *, char *);
pdfsstat pdfs_rename(struct svc_req *, char *, char *);
pdfsstat pdfs_mkdir(struct svc_req *, char *, char *, sattr *);
pdfsstat pdfs_rmdir(struct svc_req *, char *, char *);
pdfsstat pdfs_readdir(struct readdirargs *, struct svc_req *, char **, int *);
pdfsstat pdfs_statfs(pdfs_fh *, struct svc_req *);

void cleanup();
void terminate(int );
void sig_initialise();
int reinitailise(int );

//extern 
extern void log_open(char *, char *);
extern void log_write(char *, ...);
extern void log_close();

#endif

/* End of pdfs_deamon.h. */
