/*	Author: Balakrishnan Rukmangathan
	ss_funcs.c : functions used by the storage site to communicate
	with the synchronisation site

*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#include "defns.h"
#include "cs2ss_msgfmt.h"
#include "pdfs.h"


extern pdfs_fh root_fh;
extern int fd_cache_size; 
extern struct op_result result;

extern void log_write(char *, ...);
extern pdfsstat pdfs_root(pdfs_fh *, struct svc_req *);
extern pdfsstat pdfs_rename(struct svc_req *, char *, char *);
extern pdfsstat pdfs_mkdir(struct svc_req *, char *, char *, sattr *);
extern pdfsstat pdfs_rmdir(struct svc_req *, char *, char *);
extern pdfsstat pdfs_create(struct svc_req *, char *, char *, sattr *);  
extern pdfsstat pdfs_remove(struct svc_req *, char *, char *);  
extern char *fh_dump(pdfs_fh *);
extern int update_file(char *ss_addr, char *fname);
 

int process_synch(int sockid, cs2ss_msg *pkt)
{
	printf("Processing the request from the synchronisation site\n");
	switch (ntohs(pkt->msg_code)) {
	case MSG_CS2SS_POLL : {
		log_write("A poll request has arrived \n");
		pkt->args.mnt_reply.load = htons(fd_cache_size);
		memset(&(pkt->args.mnt_reply.root_fh),0,PDFS_FHSIZE);
		pdfs_root(&(pkt->args.mnt_reply.root_fh),NULL); 
		if (send(sockid,pkt,sizeof(cs2ss_msg),0) < sizeof(cs2ss_msg))
			perror("Error in sending the mount reply \n");
		printf("Finished sending the mount reply\n");
		log_write("The root handle is %s\n",fh_dump(&(pkt->args.mnt_reply.root_fh)));
		break ;
	}
	
	case MSG_CS2SS_CREATE : {
		// create a file
		pdfsstat status;
		log_write("A create request has arrived \n");
		status = pdfs_create(&pkt->user_info,pkt->args.cr_args.dir_name, pkt->args.cr_args.f_name, & pkt->args.cr_args.f_attribs);
		pkt->args.status = htons(status);
		printf("cookie is %d",ntohs(pkt->cookie));
		if (send(sockid,pkt,sizeof(cs2ss_msg),0) < sizeof(cs2ss_msg))
			perror("Error in sending the create reply \n");
		break;
	}

	case MSG_CS2SS_CREATEDIR : {
		// create a directory
		pdfsstat status;
		log_write("A create directory request has arrived \n");
		status = pdfs_mkdir( & pkt->user_info, pkt->args.cr_args.dir_name, pkt->args.cr_args.f_name, &pkt->args.cr_args.f_attribs);
		pkt->args.status = htons(status);
		if (send(sockid,pkt,sizeof(cs2ss_msg),0) < sizeof(cs2ss_msg))
			perror("Error in sending the create dir reply \n");
		break;
	}

	case MSG_CS2SS_DELETE : {
		// delete a file 
		pdfsstat status;
		log_write("A file delete request has arrived \n");
		status = pdfs_remove( & pkt->user_info, pkt->args.cr_args.dir_name, pkt->args.cr_args.f_name);
		pkt->args.status = htons(status);
		if (send(sockid,pkt,sizeof(cs2ss_msg),0) < sizeof(cs2ss_msg))
			perror("Error in sending the delete file reply \n");
		break;
	}

	case MSG_CS2SS_DELETEDIR : {
		// delete a directory
		pdfsstat status;
		log_write("A remove directory request has arrived \n");
		status = pdfs_rmdir( & pkt->user_info, pkt->args.cr_args.dir_name, pkt->args.cr_args.f_name);
		pkt->args.status = htons(status);
		if (send(sockid,pkt,sizeof(cs2ss_msg),0) < sizeof(cs2ss_msg))
			perror("Error in sending the rmdir reply \n");
		break;
	}

	case MSG_CS2SS_RENAMEDIR : {
		// rename a directory
		pdfsstat status;
		log_write("A rename request has arrived \n");
		status = pdfs_rename(&pkt->user_info, pkt->args.ren_args.from, pkt->args.ren_args.to);
		pkt->args.status = htons(status);
		if (send(sockid,pkt,sizeof(cs2ss_msg),0) < sizeof(cs2ss_msg))
			perror("Error in sending the rename reply \n");
		break;
	}

	case MSG_CS2SS_UPDATE : {
		// updating a file
		log_write("A update request has arrived \n");
		printf("A update request has arrived \n");
		update_file(pkt->args.up_args.pref_srvr, 
			pkt->args.up_args.fname);
		break;
	}

	default : {
		printf("Received other type of messages \n");
	}
 }
	return 1;
} // end of process_synch
