// header file for other defintions.

#ifndef DEFNS_H
#define DEFNS_H

#include <sys/types.h>

#define CS_DEAMON_PORT		12345 	// port no. for cs deamon
#define SS_DEAMON_PORT		23456	// port no. for ss deamon	
#define US_PORT			34567	// port no. for us deamon
#define CS_SYNCH_PORT		45678	// port no. for cs-ss communicaiton
#define SS_UPDATE_PORT		56789	// prot no. for listening for update requests
// set of messages from US to CS

#define MSG_US2CS_REGISTER    	81	// message id for client register
#define MSG_US2CS_UNREGISTER	82	// message id for client unregister
#define MSG_US2CS_MOUNT		83	// message id for mount filesystem 
#define MSG_US2CS_UNMOUNT	84	// message id for mount filesystem 
#define MSG_US2CS_CREATE	85
#define MSG_US2CS_CREATEDIR 	86
#define MSG_US2CS_DELETE	87
#define MSG_US2CS_DELETEDIR     88
#define MSG_US2CS_RENAME	89

// set of message from CS to US

#define MSG_CS2US_MOUNT		90	// mount reply
#define MSG_CS2US_CALLBACK	91	// callback to flush the cache
					// and change the storage server
#define MSG_CS2US_REUSEFH	92	// use the initial storage server 
#define MSG_CS2US_REGISTEROK	93	// reply if no callback is needed
#define MSG_CS2US_CREATE	94
#define MSG_CS2US_CREATEDIR 	95
#define MSG_CS2US_DELETE	96
#define MSG_CS2US_DELETEDIR	97
#define MSG_CS2US_RENAME	98



// set of messages from US to SS

#define MSG_US2SS_NULL		1	// null call	
#define MSG_US2SS_GETATTR	2	// get attr for a file
#define MSG_US2SS_SETATTR	3	// set attr for a file
#define MSG_US2SS_ROOT		4	// get the root handle
#define MSG_US2SS_LOOKUP	5	// lookup a file in a dir
#define MSG_US2SS_READ		6	// file read
#define MSG_US2SS_WRITE		7	// file write
#define MSG_US2SS_CREATE	8	// create a file
#define MSG_US2SS_RENAME	9	// rename a file
#define MSG_US2SS_REMOVE	10	// remove a file
#define MSG_US2SS_MKDIR		11	// make a directory
#define MSG_US2SS_RMDIR		12	// remove a directory
#define MSG_US2SS_READDIR	13	// read a directory
#define MSG_US2SS_STATFS	14	// stat of a file


// set of messages from SS to US

#define MSG_SS2US_NULL		51	// null call	
#define MSG_SS2US_GETATTR	52	// get attr for a file
#define MSG_SS2US_SETATTR	53	// set attr for a file
#define MSG_SS2US_ROOT		54	// get the root handle
#define MSG_SS2US_LOOKUP	55	// lookup a file in a dir
#define MSG_SS2US_READ		56	// file read
#define MSG_SS2US_WRITE		57	// file write
#define MSG_SS2US_CREATE	58	// create a file
#define MSG_SS2US_RENAME	59	// rename a file
#define MSG_SS2US_REMOVE	60	// remove a file
#define MSG_SS2US_MKDIR		61	// make a directory
#define MSG_SS2US_RMDIR		62	// remove a directory
#define MSG_SS2US_READDIR	63	// read a directory
#define MSG_US2US_STATFS	64	// stat of a file
#define MSG_US2US_UNKNOWN	65	// stat of a file

// set of messages from CS to SS

#define MSG_CS2SS_POLL		160	// message id to poll for being a SS
#define MSG_CS2SS_UPDATE	161	// update the copy to its new version
#define MSG_CS2SS_CREATE	162
#define MSG_CS2SS_CREATEDIR	163
#define MSG_CS2SS_DELETE	164
#define MSG_CS2SS_DELETEDIR	165
#define MSG_CS2SS_RENAMEDIR	166

// set of messages from SS to CS

#define MSG_SS2CS_POLL		180	// reply to the poll message  
#define MSG_SS2CS_COMMIT	1100	// committed the changes

// other messages

#define MSG_ABORT		2222	// aborting due to failures

#define MAX_FILE_NAMELEN	255  	// maximum file name length
#endif
