/*
	Author: Balakrishnan Rukmangathan
	cs_us_msg_fmt.h : message format for messages exchanged
	between the synchronisation site and the user site
*/

#ifndef CS2US_MSGFMT_H
#define CS2US_MSGFMT_H

#include "pdfs.h"
#include "args.h"
#include "common.h"

typedef struct acc_req {
	pdfs_fh 	fh; // file handle
	u_short 	mode; // mode for the file
	char 		ss_addr[16]; // synchronisation site address
	char 		fname[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN+1];
			// name of the file 
} acc_req;

typedef struct call_bk {
	pdfs_fh 	fh ; // old file handle
	pdfs_fh		new_fh; // new file handle
	char 		ss_addr[16]; // new site address
} call_bk;

typedef struct cs_us_msg{
	u_short 	msg_code; // message code of the packet
	struct 		svc_req user_info;
	union {
		crargs cr_args;
		renargs ren_args;
		call_bk cbk_args;
		acc_req	acc_args;
		pdfsstat status;
	} args;
}cs2us_msg;

#endif
