/* 	Author: Balakrishnan Rukmangathan
	PDFS args.h
	This file contains the different types of arguments
	that are exchanged between the client and the server 
*/


#ifndef ARGS_H
#define ARGS_H

#include <sys/types.h>
#include <sys/stat.h>
#include "pdfs.h"

/* structure for attributes of the file */
// currently allowing only normal files to be exported 
// currently support for links are not provided

struct svc_req { // the client who request a service
	uid_t	userid;	// The clients user id
	// need to include the other group_ids he belong to
};		

typedef struct f_attribs {
	u_short ftype;	   // file type
        uid_t uid;         // id of the user
        gid_t gid;         // group id of the user 
        mode_t mode;       // mode of the file
        time_t atime;      // last access time 
        time_t mtime;      // last modified time 
	time_t ctime;	   // time of last change
	u_int size; 	   // size of the file
	u_int nlink;	   // number of links
	u_int blocksize;   // size of each block
	u_int blocks;	   // number of blocks
} fattr;

typedef struct sattr {
        uid_t uid;         // id of the user
        gid_t gid;         // group id of the user 
        mode_t mode;       // mode of the file
        time_t atime;      // last access time 
        time_t mtime;      // last modified time 
	u_int size; 	   // size of the file
} sattr;

struct diropargs {
	pdfs_fh	dir_fh;		// directory handle
	char name[PDFS_MAXNAMELEN];	// name of the file
};

struct diropres {
	pdfs_fh	  fh;		// if status OK, file handle for the request
};

struct getattrargs {
	pdfs_fh fh; 	// file handle
};

struct readargs {
	pdfs_fh fh; 	// file handle of the file
	u_long	offset;		// from where
	u_long 	howmuch;	// how much to read
};

struct readres {
	u_long	count;		// howmuch read
};

struct writeargs {
	pdfs_fh	fh;	// file handle of the file
	u_int	offset;		// from where
	u_int 	howmuch;	// how much to write
};

struct writeres {
	pdfs_fh	fh;		// file handle
	u_long howmuch;		// how much written
};

struct renameargs {
	struct diropargs from; 	// from this handle
	struct diropargs to;	// to this handle
};

struct renameres {
	pdfs_fh fh;		// renamed file's file handle
};

struct createargs {
	struct diropargs where;  // directory handle and name
	sattr	attribs; 	// attributes of the file
};

struct createres {
	pdfs_fh	fh;		// file handle for the file created
};


struct readdirargs {
	pdfs_fh	dir;		// directory handle
};

struct readdirres {
	u_long count;		// howmuch entries this result has
};

struct setattrargs {
	pdfs_fh	fh;		// file whose attributes are to be set
	sattr  attributes;	// attributes to be set
};

struct op_result {	 	// every request returns the result code
	fattr attr;		// attributes of the file.
	pdfsstat status;	// status of the request
	union {
	    struct readdirres readdir_res;
	    struct createres  create_res;
	    //struct renameres  reaname_res;
	    // struct writeres   write_res;
	    struct readres    read_res;
	    struct diropres   dirop_res;
	} rslt;
};

typedef union gen_op_args{
	struct createargs  cr_args;
	struct readdirargs readdir_args;
	struct diropargs   dirop_args;
	struct getattrargs getattr_args;
	struct readargs	   read_args;
	struct writeargs   write_args;
	struct renameargs  rname_args;
	struct setattrargs sattrargs;
	struct op_result   svc_result;
} generic_op_args;

#endif
