/* Author: Rukmangathan Balakrishnan 
   registry.c : Registry maintainted by the synchronisation
		site for sending callback
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "defns.h"

#include "registry.h"

static reg_entry *registry[MAX_TREE_LEVEL];

reg_entry *add_entry(char *fname, pdfs_fh *fh, open_stat mode, 
		char *clnt_addr, char *ss_addr,int sockfd)
{
	// fname : is a fully qualified name with the start
	//	   of exported root. eg. /a/b/c
	// return NULL if the ss_addr and fh can be used
	// else send the primary fh & primary server address
	
	char *ptr = fname;
	int level=1;
	reg_entry *regentry;
	cl_details *client;

	while((ptr = strchr(ptr+1,'/')) != NULL)
		level++;
	ptr = strrchr(fname,'/');
	ptr++; // now ptr points to the filename

	// regentry = find(registry[level],ptr);
	regentry = find(registry[level],fname);
	
	if (regentry == NULL) {
		// the file doesnt exists 
		regentry = (reg_entry *)malloc(sizeof(reg_entry));
		memset(regentry,0,sizeof(reg_entry));
		regentry->fname = (char *)malloc(sizeof(char)*strlen(fname));
		strcpy(regentry->fname,fname);
		
		if ((mode == F_READ))  {
			client = fill_client(fh,mode,clnt_addr,ss_addr,sockfd);
			regentry->reader_count++;
			regentry->clients = client;
			// add this client to the list of clients
			log_write("Added the client %s to file %s's list\n",
				client->clnt_addr,regentry->fname);
			// add this client to the list of clients
			regentry->next = registry[level];
			registry[level] = regentry;
			log_write("file %s 's reader count is %d\n",
				regentry->fname,regentry->reader_count);
			log_write("file %s 's w count is %d\n",
				regentry->fname,regentry->writer_count);
			return NULL;
		}
		if ( (mode == F_WRITE) || (mode == F_RDWR)) {
			// he is a writer so make the served copy as
			// primary copy
			regentry->writer_count++;
			memcpy(regentry->primary_server,ss_addr,16);
			memcpy(&regentry->primary_fh,fh,PDFS_FHSIZE);
			log_write("set %s as the primary server for file %s\n",
				regentry->primary_server,regentry->fname);
			regentry->next = registry[level];
			registry[level] = regentry;
			log_write("file %s 's reader count is %d\n",
				regentry->fname,regentry->reader_count);
			log_write("file %s 's w count is %d\n",
				regentry->fname,regentry->writer_count);
			return NULL;
		}
	}

	// there exists an entry already

	if ((mode == F_READ) ) {
		client = fill_client(fh,mode,clnt_addr,ss_addr,sockfd);
		client->next = regentry->clients;
		regentry->clients = client;
		regentry->reader_count++;
		log_write("Added the client %s to file %s's list\n",
			client->clnt_addr,regentry->fname);
	} // we remember only the readers.
	if (regentry->writer_count > 0){ 
		if ((mode == F_RDWR) || (mode == F_WRITE))
			regentry->writer_count++;
		log_write("file %s 's reader count is %d\n",
			regentry->fname,regentry->reader_count);
		log_write("file %s 's w count is %d\n",
			regentry->fname,regentry->writer_count);
		return regentry; // send the primary ss and fh
	}
	// till now there are no writers
	if ((mode == F_WRITE) || (mode == F_RDWR)) {
		// this client is the first writer
		regentry->writer_count++;
		memcpy(regentry->primary_server,ss_addr,16);
		memcpy(&regentry->primary_fh,fh,PDFS_FHSIZE);
		log_write("made %s as the primary server for file %s\n",
			regentry->primary_server,regentry->fname);
		// send callback to all the clients who are reading
		send_callback(regentry);
	}
	log_write("file %s 's reader count is %d\n",regentry->fname,
		regentry->reader_count);
	log_write("file %s 's w count is %d\n",regentry->fname,
		regentry->writer_count);
	return NULL;
}

void registry_init()
{
	int index=0;
	for (index=0; index < MAX_TREE_LEVEL; index++)
		registry[index] = NULL;
	log_write("REGISTRY : Initialised The Registry");
}

// Send a callback to all the clients of this file handle

void send_callback(reg_entry *rentry)
{
	cl_details *clnt=rentry->clients;
	while (clnt) {
		cs2us_msg *pkt;
		pkt = frame_callback(MSG_CS2US_CALLBACK,rentry, clnt);
	        if (send(clnt->sockfd, pkt, sizeof(cs2us_msg), 0) < 
			sizeof(cs2us_msg) ) {
		log_write("Unable to send the complete callback packet to %s for file %s \n",clnt->srvr_addr,rentry->fname);
		// no fault tolearnce done 
		}
		else log_write("sent the complete callback packet to %s for file %s \n",clnt->srvr_addr,rentry->fname);
		clnt = clnt->next;
		free(pkt); // free the packet
	}// end of while
} // end of send_callback


// find an entry for the client lists for the file fname
reg_entry *find(reg_entry *f_list, char *fname)
{
	// find fname in the list of files in that level.
	while(f_list != NULL) {
		if(!strcmp(f_list->fname,fname))
			return f_list;
		else f_list = f_list->next;
	}
	return NULL;
}

// fill the details of the client
cl_details *fill_client(pdfs_fh *fh, open_stat mode, char *clnt_addr, 
		char *ss_addr,int sockfd)
{
	cl_details *client = (cl_details *)malloc(sizeof(cl_details));
	client->omode = mode;
	strcpy(client->clnt_addr,clnt_addr);
	strcpy(client->srvr_addr,ss_addr);
	memcpy(&client->fh,fh,PDFS_FHSIZE);
	client->sockfd = sockfd;
	client->next = NULL;
	return client;
}



// check whether the given inputs matches with a regiested client
int is_match(cl_details *src, pdfs_fh *fh, open_stat mode, 
		char *cl_addr, char *s_addr,int sockfd)
{
	if ( (src->omode == mode) && !strcmp(src->clnt_addr,cl_addr) &&
		!strcmp(src->srvr_addr,s_addr) &&
		!memcmp(&src->fh,fh,PDFS_FHSIZE) &&
		(src->sockfd == sockfd) )
		return 1;
	return 0;
}

// a client is closing, delete his entry from the list
void delete(char *fname, pdfs_fh *fh, open_stat mode, 
		char *clnt_addr, char *ss_addr,int sockfd)
{
	// fname : is a fully qualified name with the start
        //         of exported root. eg. /a/b/c
        // return NULL if the ss_addr and fh can be used
        // else send the primary fh & primary server address

        char *ptr = fname;
        int level=1;
        reg_entry *regentry;

        while((ptr = strchr(ptr+1,'/')) != NULL)
                level++;
        ptr = strrchr(fname,'/');
        ptr++; // now ptr points to the filename

        regentry = find(registry[level],fname);

        if (regentry == NULL) { // no entry for the file
		log_write("Internal inconsistency no entry for the file\n");
		printf("Internal inconsistency no entry for the file\n");
		return ; 
	}
	if ((mode == F_WRITE) || (mode == F_RDWR))
		regentry->writer_count--;
	if ( (mode == F_READ) ) {
		cl_details *client,*prev=NULL;
		client = regentry->clients;
		while (client && !is_match(client,fh,mode,clnt_addr,
				ss_addr,sockfd)) {
			prev = client;
			client = client->next;
		}
		if (client == NULL) {
			log_write("Internal inconsistency client not found\n");
			printf("Internal inconsistency client not found\n");
			return ;
		}
		if (prev == NULL) 
			regentry->clients = client->next;
		else prev->next = client->next; 
		regentry->reader_count--;
		free(client);
	}// deleted the entry from the list of clients
	if (regentry->writer_count == 0) {
		log_write("All the writers are gone\n");
		printf("All the writers are gone \n");
		// last writer has also gone. trigger the update protocol
		send_update_to_all(regentry);
		// flush the primary_fh and primary_ss
		memset(regentry->primary_server, 0, 16);
		memset(&regentry->primary_fh, 0, sizeof(regentry->primary_fh));
		// ask the users to start using their address
		send_reuseaddr(regentry);
	}
	log_write("file %s 's reader count is %d\n",regentry->fname,
		regentry->reader_count);
	log_write("file %s 's w count is %d\n",regentry->fname,
		regentry->writer_count);
	return ;
}


cs2us_msg *frame_callback(u_short msgcode, reg_entry *regentry, cl_details *clnt)
{
	// frame the callback needed to send to a client.
	cs2us_msg *pkt = (cs2us_msg *)malloc(sizeof(char)*sizeof(cs2us_msg));
	memset(pkt,0,sizeof(cs2us_msg));
	pkt->msg_code = htons(msgcode);
	memcpy(&pkt->args.cbk_args.fh,&clnt->fh,PDFS_FHSIZE);
	memcpy(&pkt->args.cbk_args.new_fh,&regentry->primary_fh,PDFS_FHSIZE);
	strcpy(pkt->args.cbk_args.ss_addr,regentry->primary_server);
	return pkt;
}

void send_reuseaddr(reg_entry *regentry)
{
	cl_details *clnt = regentry->clients;
	while (clnt) {
		cs2us_msg *pkt;
		pkt = frame_callback(MSG_CS2US_REUSEFH,regentry, clnt);
	        if (send(clnt->sockfd, pkt, sizeof(cs2us_msg), 0) < 
			sizeof(cs2us_msg) ) {
		log_write("Unable to send the complete reuse packet to %s for file %s \n",clnt->srvr_addr,regentry->fname);
		// no fault tolearnce done 
		}
		else log_write("sent the complete reuse packet to %s for file %s \n",clnt->srvr_addr,regentry->fname);
		clnt = clnt->next;
		free(pkt); // free the packet
	}// end of while
} // end of send_callback


