/*	Author: Balakrishnan Rukmangathan
	process_ready.c : process the socket ready for processing
*/

#include<stdio.h>
#include<stdlib.h>
#include<sys/types.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include "defns.h"
#include "cs2us_msgfmt.h"

#include "registry.h"
#include "sites_list.h"

extern fd_set ready_fds;
extern int mount_fd;
extern int synch_fd;

void register_reply(int , reg_entry *,pdfs_fh *);
extern int select_site(pdfs_fh *);

extern void csd_create(cs2us_msg , int );
extern void csd_createdir(cs2us_msg , int );
extern void csd_delete(cs2us_msg , int );
extern void csd_deletedir(cs2us_msg , int );
extern void csd_rename(cs2us_msg , int );


/* process the ready socket. First check whether its a mount_fd socket if so
   do the mount protocol. else read the message from the us and process
   appropriately.
*/
void process_ready(int sock_id)
{
   if (sock_id == mount_fd) 
	{
		// a client is mounting the file system
		int newsockfd;
		struct sockaddr_in clntaddr;
		int addrlen = sizeof(clntaddr);
		int retval;
		cs2us_msg pkt;
	
		newsockfd = accept(mount_fd,(struct sockaddr *)&clntaddr,
				&addrlen);
		log_write("Site %s has mounted the fs \n",
				inet_ntoa(clntaddr.sin_addr));
		printf("Site %s is mounting the fs \n",
				inet_ntoa(clntaddr.sin_addr));
		// do the mount protocol here
		// talk to the cs , do the load balancing
		// return back the root file handle
		memset(&pkt,0,sizeof(pkt));
		retval = select_site(&(pkt.args.acc_args.fh));

		if (retval > 0 ) {
			struct sockaddr_in peer;
			int addrlen = sizeof(peer);
			pkt.msg_code = htons(MSG_CS2US_MOUNT);
			getpeername(retval,(struct sockaddr *)&peer,&addrlen);
			strcpy(pkt.args.acc_args.ss_addr, inet_ntoa(peer.sin_addr));
			log_write("Selected %s to serve \n",pkt.args.acc_args.ss_addr);
			printf("Selected %s to serve \n",pkt.args.acc_args.ss_addr);
			FD_SET(newsockfd,&ready_fds);
		}
		else pkt.msg_code = htons(MSG_ABORT);
		if (send(newsockfd,&pkt,sizeof(pkt),0) < sizeof(pkt))
			log_write("Error in sending mount reply\n");
		return ;
	} // end of registering a mounting client
   
    if (sock_id == synch_fd)
	{
		// a storage site is registering
	
		int newsockfd;
                struct sockaddr_in clntaddr;
                int addrlen = sizeof(clntaddr);

                newsockfd = accept(synch_fd,(struct sockaddr *)&clntaddr,
                                &addrlen);

		add_to_list(inet_ntoa(clntaddr.sin_addr),newsockfd);
		
                // FD_SET(newsockfd,&ready_fds); // add to the list of ready fds
		//do we need this socket id to be set
                log_write("Site -%s- has registered as a storage site \n",
                                inet_ntoa(clntaddr.sin_addr));
                printf("Site -%s- has registered as a storage site \n",
                                inet_ntoa(clntaddr.sin_addr));
		return ;
        }// finished registering a storage site

   else {
	// some client has sent a message
	cs2us_msg pkt;
	struct sockaddr_in peer;
	int addrlen = sizeof(peer);
	getpeername(sock_id,(struct sockaddr *)&peer,&addrlen);
	printf("Message from a user site \n");
	if (recv(sock_id,&pkt,sizeof(pkt),MSG_WAITALL) < sizeof(pkt)) {
		log_write("Received an illegal packet on id %d\n",
			sock_id);
		log_write("Closing the connection with the client \n");
		printf("Closing the connection with the client \n");
		FD_CLR(sock_id,&ready_fds);
		return ;
        }
       switch(ntohs(pkt.msg_code)) {
		case MSG_US2CS_REGISTER: { // register this client

			reg_entry *regentry = NULL;
			printf("Received a Register message \n");
			regentry = add_entry(pkt.args.acc_args.fname,
				&pkt.args.acc_args.fh,
				ntohs(pkt.args.acc_args.mode), 
				inet_ntoa(peer.sin_addr), 
				pkt.args.acc_args.ss_addr, sock_id);
			register_reply(sock_id,regentry,&pkt.args.acc_args.fh);
			break;
		}
		case MSG_US2CS_UNREGISTER: { // client unregister
			printf("Received a Unregister message \n");
			delete(pkt.args.acc_args.fname, &pkt.args.acc_args.fh,
				ntohs(pkt.args.acc_args.mode),
				inet_ntoa( peer.sin_addr),
				pkt.args.acc_args.ss_addr, sock_id);
			break;
		}
		case MSG_US2CS_UNMOUNT: { // message id for unmount fs
			//do the unmount protocol.
			// delete_entries(sock_id);
			printf("Received an Unmount Message \n");
			log_write("Site %s has unmounted \n",inet_ntoa(peer.
				sin_addr));
			printf("Site %s has unmounted \n",inet_ntoa(peer.
				sin_addr));
			FD_CLR(sock_id,&ready_fds);
			break;
		}
		case MSG_US2CS_CREATE : { 
			csd_create(pkt,sock_id);
			// create a file
			break;
		}
		case MSG_US2CS_CREATEDIR : {
			// create a directory
			csd_createdir(pkt,sock_id);
			break;
		}
		case MSG_US2CS_DELETE : {
			// delete a file
			csd_delete(pkt,sock_id);
			break;
		}
		case MSG_US2CS_DELETEDIR : {
			// delete a directory
			csd_deletedir(pkt,sock_id);
			break;
		}
		case MSG_US2CS_RENAME : {
			// rename directory
			csd_rename(pkt,sock_id);
			break;
		}
		default : {
			log_write("Received an unknown message \n");
		}
	} // end of switch
   }	// end of else
  printf("finished processing the message");
  return ;
} // end of process_ready


// reply to the registering client. if no readers say ok else
// send the primary fh and primary ss.

void register_reply(int sockid, reg_entry *regentry,pdfs_fh *old_fh)
{
	cs2us_msg pkt;
	if (regentry == NULL) // no readers yet
		pkt.msg_code = htons(MSG_CS2US_REGISTEROK);
	else {
		pkt.msg_code = htons(MSG_CS2US_CALLBACK);
		memcpy(&pkt.args.cbk_args.new_fh,&regentry->primary_fh,PDFS_FHSIZE);
		memcpy(&pkt.args.cbk_args.fh,old_fh,PDFS_FHSIZE);
		strcpy(pkt.args.cbk_args.ss_addr,regentry->primary_server);
	}
	if (send(sockid,&pkt,sizeof(cs2us_msg),0) < 0) {
			log_write("cannot reply to the client\n");

	}
} // end of register_reply

