#include <stdio.h>
#include <stdarg.h>
#include <time.h>

static FILE *log_ptr = NULL;

int log_open(char *progname, char *filename)
{ // open the log file for writing whats going on the server side
	char logfile[20];
	time_t curr_time = time(NULL);
	char *cur_time = ctime(&curr_time);
	memset(cur_time+10,0,1);
	cur_time[7] =  '-';
	sprintf(logfile,"%s-%s",filename,(cur_time+4));
	if (!(log_ptr = fopen(logfile,"a")))
		return -1;
	fprintf(log_ptr,"Log for - %s - started at %s",progname,ctime(&curr_time));
	return 0;
}

void log_write(char *fmt, ...)
{ // log the message into the file in the fmt specified
   va_list args; 
   va_start(args, fmt);
   vfprintf(log_ptr,fmt,args);
   va_end(args);
   fflush(log_ptr);
}

void log_close() 
{ // close the log file
    if (log_ptr == NULL) return;
    fprintf(log_ptr,"**************************************\n");
    fclose(log_ptr);
}
