	/* Author: Balakrishnan Rukmangathan
	   cs_deamon.c : The sychornisation site deamon for PDFS
	*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <getopt.h>
#include <unistd.h>
#include <fcntl.h>


#include "defns.h"
#include "msg_format.h"
#include "pdfs.h"


#include "registry.h"


#define MAX_FDS 	256	// maximum fds in the system

//extern int proc_req(int, PACKET *, struct sockaddr_in *);

extern int log_open(char *, char *);
extern void log_write(char *, ...);
extern void log_close();
extern void test();
extern void process_ready(int );
void serve_all(void );


int no_of_sites = 0;
int mount_fd;
int synch_fd;
fd_set ready_fds;


struct in_addr sites[10];

int main(int argc, char *argv[])
{
	char fname[20];
	struct sockaddr_in myaddr;

	printf("Enter the Log file to be generated :");
	scanf("%s",fname);
	log_open(argv[0],fname);
	registry_init();

	// set up the mount fd here;
	if ((mount_fd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) < 0) {
		log_write("Cannot create the mount fd\n");
		perror("cannot create the mount socket\n");
		exit(1); }
	
	if ((synch_fd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) < 0) {
		log_write("Cannot create the synch fd\n");
		perror("cannot create the synch socket\n");
		exit(1); }
	
	memset(&myaddr,0,sizeof(myaddr));
	myaddr.sin_family = AF_INET;
	myaddr.sin_port = htons(CS_DEAMON_PORT);
	myaddr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (bind(mount_fd,(struct sockaddr *)&myaddr,sizeof(myaddr))<0) {
		log_write("cannot bind the mount fd \n");
		perror("Cannot bind the mount fd \n");
		exit(1); }
	
	// now bind the synchornising fd
	myaddr.sin_port = htons(CS_SYNCH_PORT);
		
	if (bind(synch_fd,(struct sockaddr *)&myaddr,sizeof(myaddr))<0) {
		log_write("cannot bind the synch fd \n");
		perror("Cannot bind the synch fd \n");
		exit(1); }
	
	listen(mount_fd,5);
	listen(synch_fd,5);

	memset(&ready_fds,0,sizeof(fd_set));
	FD_ZERO(&ready_fds);

	FD_SET(mount_fd,&ready_fds); // set the mount fd
	log_write("Successfully set the mount fd\n");

	FD_SET(synch_fd,&ready_fds); // set the synch fd
	log_write("Successfully set the synch fd\n");

	printf("The SYNCHORNISATION SERVER is up and Running... \n");

	serve_all();
	log_close();
	return 0;
}

void serve_all()
{
        // wait on some socket to become ready for input
        // get that socket and based on the socket
        // do the apropriate processing
        while (1) {
                int retval=0,i,served;
                fd_set temp_fds;
                memset(&temp_fds,0,sizeof(fd_set));
                FD_ZERO(&temp_fds);
                memcpy(&temp_fds,&ready_fds,sizeof(fd_set));
                retval = select(MAX_FDS,&temp_fds, NULL,NULL,NULL);
                fflush(stdout);
                if (retval == -1) {
                        log_write("Some problem with select\n");
                        perror("Select problem");
                        // exit(1); continue ;
                        }
                served = 0;
		printf("Going to serve a request \n");
                for (i=0; i < MAX_FDS; i++) {
                        if (FD_ISSET(i,&temp_fds)){
                                process_ready(i);
                                served++; }
                        if (served == retval) break;
                }
        }
} // end of serve_all
