/* 
 * NFS server end:
 * 1. Services the nfsproc3_null procedural call.
 * 2. Services the nfsproc3_getattr_3 procedural call.
 * 3. nfsproc3_lookup procedural call.
 * 4. nfsproc3_read  procedural call.
 * 5. nfsproc3_readdir procedural call.	
 * 6. nfsproc3_write procedural call. 
 * 7. nfsproc3_create procedural call. 
 * 8. nfsproc3_mknod procedural call. 
 * 9. nfsproc3_mkdir procedural call. 
 * 10. nfsproc3_symlink procedural call. 
 * 11. nfsproc3_rename procedural call. 
 * 12. nfsproc3_remove procedural call. 
 * 13. nfsproc3_rmdir procedural call. 
 * 14. nfsproc3_readlink procedural call. 
 * 15. nfsproc3_link procedural call. 
 * 16. nfsproc3_setattr procedural call.
 * 17. nfs_proc3_fsstat procedural call.
 * 18. nfs_proc3_mknod procedural call.
 * 19. nfs_proc3_commit procedural call.
 * 20. nfs_proc3_pathconf procedural call.
 * 21. nfs_proc3_readdirplus procedural call.
 * 22. nfs_proc3_access procedural call.
 * Copyright (c) -- 1998 - 1999 : Harish Kaushik Calathur Gopal.
 * Copyright (c) -- 1999 - 2000 : Harish Kaushik Calathur Gopal.
 */

#include "nfs.h"
#include "fh.h"
#include "nfsd.h"
#include <sys/vfs.h>
#include <sys/un.h>
#include <dirent.h>
#include <netdb.h>
#include <sys/stat.h>
#include <unistd.h>
#include <linux/errno.h>
#include <linux/unistd.h>
#include <fcntl.h>


/* flags for auth_fh */

#define CHK_READ 		0
#define CHK_NOACCESS 		2
#define CHK_WRITE 		1

#define NFS3_MAXNAMLEN 		255
#define NFS3_MAXPATHLEN 	1024
#define NFS3_MAXDATA 		(16*1024)
#define MAX_SIZE		64

static char 			iobuf[NFS3_MAXDATA];
static char 			pathbuf[NFS3_MAXPATHLEN + NFS3_MAXNAMLEN + 1];
static char 			pathbuf_1[NFS3_MAXPATHLEN + NFS3_MAXNAMLEN + 1];

// functional prototypes.
extern nfsstat3 fh_wcc_attr 
(char *fh, wcc_attr *wcattr,
     struct stat *stat_optimise, struct svc_req *rqstp);
extern nfsstat3 
setattr (char *path, sattr3 *attr,
	     struct stat *s, struct svc_req *rqstp,
						int flags);	 
extern nfsstat3 
	fh_getattr (char *, fattr3 *, struct stat *, struct svc_req *); 
extern nfsstat3 
 fhc_getattr (fhcache *fhc, fattr3 *attr,
	      	struct stat *stat_optimirzse, struct svc_req *rqstp);  
extern void fh_remove (char *path); 
static nfsstat3 
	build_path (struct svc_req *rqstp, char *buf, diropargs3 * da,
				int flags);
extern int 
path_open (char *path, int omode, int perm);
extern enum nfsstat3    
nfs_errno(void);
extern psi_t    
pseudo_inode(ino_t inode, dev_t dev);
extern int fh_fd (fhcache *h, nfsstat3 *status, int omode);
extern void fd_inactive (int fd); 
extern fhcache *fh_find (svc_fh *h, int mode);
extern nfsstat3 
fh_compose (diropargs3 *dopa, nfs_fh3 *new_fh, 
		struct stat **sbpp, int fd, int omode, int public); 

/*
 * auth_fh
 * This function authenticates the file handle provided by the client.
 * It also takes care of caching the client and mount point structures
 * in the fh cache entry, even though this may not be a huge benefit.
 */

static fhcache *
auth_fh(struct svc_req *rqstp, char *fh, nfsstat3 *statp, int flags)
{
        fhcache         *fhc;   
 
	/* Try to map FH. 
	If not cached, reconstruct path with root priv */
        if ((fhc = fh_find((svc_fh *)fh, FHFIND_FEXISTS)) == NULL) {
                // printf("auth_fh fails : inside fh_find\n");  
                *statp = NFS3ERR_STALE;
                return NULL;
        }
        // printf("fhc svc_fh is %ld\n", fhc->h);		
	// printf("fhc fd is %d\n", fhc->fd);
	*statp = NFS3_OK;
	return fhc;
} 


void * 
nfsproc3_null_3_svc(void *argp, struct svc_req *rqstp)
{
	static char* 	result;
	
	// null service call. 
	// printf("ENTERED NULL call \n");
	return((void*) &result);
}

GETATTR3res * 
nfsproc3_getattr_3_svc(GETATTR3args *argp, struct svc_req *rqstp)
{
      static GETATTR3res  	result;
      nfs_fh3 			*ar;
      fhcache 			fhc;
      int 			val;
        
     
      // printf("ENTERED GETATTR\n"); 
      ar = (nfs_fh3 *) malloc(sizeof(nfs_fh3));
      ar->data.data_val = (char *)malloc (sizeof(char)*MAX_SIZE);

      for(val=0; val < MAX_SIZE; val++){
      ar->data.data_val[val] = argp->object.data.data_val[val];  
      }    
      ar->data.data_len = argp->object.data.data_len;       
        
      if(&fhc == NULL)
      		 return(&result);
       /* service the getattr call : 
		return the attributes for a given call. */
      result.status = 
      fh_getattr(ar->data.data_val,
		&(result.GETATTR3res_u.resok.obj_attributes), 
      		NULL, rqstp);

      if (result.status != NFS3_OK) {
      return (&result);
      }     
      /* printf("at server end:s status is  %d\n", result.status);
      printf("type is %d\n", 
		result.GETATTR3res_u.resok.obj_attributes.type); 
      printf("file mode is %d\n", 
		result.GETATTR3res_u.resok.obj_attributes.mode);
      printf("nlink is %d\n", 
		result.GETATTR3res_u.resok.obj_attributes.nlink); 
      printf("uid  is %d\n", 
		result.GETATTR3res_u.resok.obj_attributes.uid); 
      printf("gid  is %d\n", 
		result.GETATTR3res_u.resok.obj_attributes.gid); 
      printf("size  is %ld\n", 
		result.GETATTR3res_u.resok.obj_attributes.size); 
      printf("fileid is %ld\n", 
		result.GETATTR3res_u.resok.obj_attributes.fileid);
      printf("atime  is %d\n", 
	result.GETATTR3res_u.resok.obj_attributes.atime.seconds); 
      printf("atime nano   is %d\n", 
	result.GETATTR3res_u.resok.obj_attributes.atime.nseconds); 
      printf("mtime  is %d\n", 
	result.GETATTR3res_u.resok.obj_attributes.mtime.seconds); 
      printf("atime nano   is %ld\n", 
	result.GETATTR3res_u.resok.obj_attributes.mtime.nseconds); */

      result.status = NFS3_OK; // return success.
      return(&result); 
}

/* LOOKUP: check fattr of dir */
LOOKUP3res * nfsproc3_lookup_3_svc 
	(LOOKUP3args *argp, struct svc_req *rqstp) {
      static	LOOKUP3res  	reslookup;
      LOOKUP3resok 		*dp = &reslookup.LOOKUP3res_u.ok;
      // LOOKUP3resfail	        *dpfail = &reslookup.LOOKUP3res_u.fail;
      nfs_fh3  			*fh3;
      fhcache  			*fhc;
      // fhcache		*fhc1;
      nfsstat3 			status;
      struct stat 		sbuf;
      struct stat 		*sbp = &sbuf;
      // struct stat 		*sbp1 = &sbuf1;
      int  			ispublic = 0, val = 0;
 

      // printf("ENTERED LOOKUP\n"); 
      // lookup for a given file handle. 
      fh3 = (nfs_fh3 *) malloc(sizeof(nfs_fh3));
      fh3->data.data_val = (char *)malloc (sizeof(char)*MAX_SIZE);

      for(val=0; val < MAX_SIZE; val++){
      fh3->data.data_val[val] = argp->what.dir.data.data_val[val];  
      }    
      fh3->data.data_len = argp->what.dir.data.data_len;       
       
      // compose the  file handle corresponding to the directory entry. 
      status = fh_compose(&(argp->what), &(dp->object), 
				&sbp, -1, -1, ispublic); 

      // printf("status is %d\n", status);
      if (status != NFS3_OK){
      // printf("lookup: ret on error\n");
      reslookup.status = status;
      /* dpfail->dir_attributes.attributes = TRUE;
      status = fhc_getattr(fhc, 
		&(dpfail->dir_attributes.attr), sbp, rqstp); 
      */
      return (&reslookup);	
      }
      dp->obj_attributes.attributes = TRUE;
      // printf("data val is %x\n", dp->object.data.data_val);
      fhc = auth_fh (rqstp, dp->object.data.data_val, 
			&status, CHK_READ);	
      // printf("fhc is %ld\n", fhc);

      // printf("lookup :before getting the attributes\n");
      // get the attributes.	
      status = fhc_getattr(fhc, 
		&(dp->obj_attributes.attr), sbp, rqstp);

      /* printf("LOOKUP attributes type : %d\n", 
			dp->obj_attributes.attr.type);
      printf("LOOKUP attributes mode : %d\n", 
			dp->obj_attributes.attr.mode);
      printf("LOOKUP attributes nlink : %d\n", 
			dp->obj_attributes.attr.nlink);
      printf("LOOKUP attributes uid : %d\n", 
			dp->obj_attributes.attr.uid);
      printf("LOOKUP attributes:gid %d\n", 
			dp->obj_attributes.attr.gid);

      printf("LOOKUP attributes:gid %ld\n", 
			dp->obj_attributes.attr.size); */

      dp->dir_attributes.attributes = FALSE; 
      /* fhc1 = auth_fh (rqstp, argp->what.dir.data.data_val, 
			&status1, CHK_READ);	
      // printf("fhc1 is %d\n", fhc1);
      status1 = fhc_getattr (fhc1, 
		&(dp->dir_attributes.attr), NULL, rqstp); 	
        
      printf("nlink is %d\n", 
		dp->dir_attributes.attr.nlink); */
		
      reslookup.LOOKUP3res_u.ok.object = dp->object;
      reslookup.LOOKUP3res_u.ok.object.data.data_len = 
					dp->object.data.data_len;
      reslookup.LOOKUP3res_u.ok.obj_attributes = dp->obj_attributes;
      /* printf("LOOKUP:file handle is %ld\n", 
      reslookup.LOOKUP3res_u.ok.object.data.data_val); */ 
       	
      reslookup.status = NFS3_OK; // return success. 
      // printf("Exit lookup\n");
      return(&reslookup);
}


READ3res *nfsproc3_read_3_svc(READ3args *argp, struct svc_req *rqstp) {
	static READ3res 	readres;
	nfsstat3 		status;
      	fhcache 		*fhc;
	int 			fd, len;
	READ3resok 		*res = &readres.res_u.ok;


	// printf("ENTERED READ\n");
	// printf("inside server side read\n");

	readres.res_u.ok.data.data_val = 
		(char *) malloc (sizeof(char)*NFS3_MAXDATA); 
	fhc = auth_fh (rqstp, argp->file.data.data_val, 
			&status, CHK_READ | CHK_NOACCESS);	

	if (fhc == NULL){
        status = NFS3ERR_STALE;
        readres.status = status;
	return (&readres);
	}
		
	/* res->file_attributes.attributes_follow = TRUE;
        fhc_getattr (fhc, &(res->file_attributes), NULL, rqstp);  
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.type);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.mode);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.nlink);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.uid);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.gid);
	printf("READ attrib is %ld\n", 
		res->file_attributes.attr.size);
	printf("READ attrib is %ld\n", 
		res->file_attributes.attr.used);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.rdev.specdata1);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.rdev.specdata2);
	printf("READ attrib is %ld\n", 
		res->file_attributes.attr.fileid);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.atime.seconds);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.atime.nseconds);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.mtime.seconds);
	printf("READ attrib is %d\n", 
		res->file_attributes.attr.mtime.nseconds); */

      //obtain the filedescriptor. 	
      if ((fd = fh_fd (fhc, &status, O_RDONLY)) < 0) {
		// printf("neg case\n");
		status = NFS3ERR_INVAL;
            	readres.status = status;
		return (&readres);
      }  
      // printf("fd us %d\n", fd);
      errno = 0;
      // printf("count is %d\n", argp->count);
      // printf("offset is %d\n", argp->offset);
      
      // lseek the position.
      (void) lseek(fd, (long) argp->offset,SEEK_SET);    
      if(!errno) {
		   res->data.data_val = iobuf;
		   if ((len = argp->count) > NFS3_MAXDATA){
			 // printf("READ: len value\n");
			 len = NFS3_MAXDATA;
                   }
                   // printf("len is %d\n", len);
		   // read from the file.
		   res->data.data_len = read(fd, iobuf, len);

		   // printf("res data len is %d\n", res->data.data_len);
		   /* printf("READ DATA is data %s\n" , 
					res->data.data_val); */	
      }      
	
      /* if (res->data.data_len !=  argp->count) {
      res->count = res->data.data_len;
      }
      else 
      res->count = argp->count;  */ 	       
      /* if (res->data.data_len == (res->count + argp->offset)){
		res->eof = TRUE;
      }
      else 
      res->eof = FALSE; */

      // res->count = res->data.data_len;
      fd_inactive(fd);

      // res->file_attributes.attributes_follow = TRUE;
      fhc_getattr (fhc, 
			&(res->file_attributes), 
				NULL, rqstp); 
	
       /* printf("READ attrib is %d\n", 
		res->file_attributes.type);
       printf("READ attrib is %d\n", 
		res->file_attributes.mode);
       printf("READ attrib is %d\n", 
		res->file_attributes.nlink);
       printf("READ attrib is %d\n", 
		res->file_attributes.uid);
       printf("READ attrib is %d\n", 
		res->file_attributes.gid);
       printf("READ attrib is %ld\n", 
		res->file_attributes.size);
       printf("READ attrib is %ld\n", 
		res->file_attributes.used);
       printf("READ attrib is %d\n", 
		res->file_attributes.rdev.specdata1);
       printf("READ attrib is %d\n", 
		res->file_attributes.rdev.specdata2);
       printf("READ attrib is %ld\n", 
		res->file_attributes.fileid);
       printf("READ attrib is %d\n", 
		res->file_attributes.atime.seconds);
       printf("READ attrib is %d\n", 
		res->file_attributes.atime.nseconds);
       printf("READ attrib is %d\n", 
		res->file_attributes.mtime.seconds);
       printf("READ attrib is %d\n", 
		res->file_attributes.mtime.nseconds); */
	
	/* readres.READ3res_u.resok.file_attributes.attributes_follow = 1;
        fhc_getattr (fhc, &(readres.READ3res_u.ok.file_attributes), NULL, rqstp); */
        

      // readres.res_u.ok.file_attributes.attributes = TRUE; 
      readres.res_u.ok.file_attributes = res->file_attributes;
      // readres.res_u.ok.count = res->count; 
      /* printf("READ COUNT is %d\n",
			readres.res_u.ok.count); */
      // readres.res_u.ok.eof = res->eof;
      readres.res_u.ok.data.data_len = res->data.data_len;
      readres.res_u.ok.data.data_val = res->data.data_val; 
      

      // printf("READ data is %s\n", readres.res_u.ok.data.data_val);
      readres.status = NFS3_OK;  // returns success.
      return(&readres);
}

/* READDIR */
READDIR3res 
* nfsproc3_readdir_3_svc 
		(READDIR3args *argp, struct svc_req *rqstp) {
	static READDIR3res 		readdirres;
	entry3 				**e;	
	__u32 				dloc;  
	DIR 				* dirp;	
	struct dirent 			*dp;
	struct stat 			sbuf;
	fhcache 			*h;
	nfsstat3 			status;		
	int 				hideit;
	int 				res_size;
	static int			cookieval = 0;


	// printf("ENTERED READDIR \n");
	// printf("dir is %ld\n", argp->dir);	
	// authenticate the given file handle.
	h = auth_fh(rqstp, argp->dir.data.data_val, &status, CHK_READ);

	if (h == NULL){
    	readdirres.status = NFS3ERR_INVAL;  			 	
    	return (&readdirres);	 
 	}     
 	errno = 0;
 	// printf("h-pathis %s\n", h->path); 			
 	if (lstat(h->path, &sbuf)  < 0  || ! (S_ISDIR(sbuf.st_mode))){
	readdirres.status = NFS3ERR_NOTDIR;	
	return (&readdirres);			
        }       
 	// open the directory.
	if ((dirp = opendir(h->path)) == NULL){
	errno ? nfs_errno() : NFS3ERR_NAMETOOLONG;	
        readdirres.status = errno;
	return(&readdirres);
	}
    	res_size = 0;	
    	// printf("argcookie is %d\n", argp->cookie);
	/* memcpy(&dloc, argp->cookie, sizeof(dloc)); */
	dloc = argp->cookie;
	if(dloc != 0)
		seekdir(dirp, ntohl(dloc));  /* subsequent readdir call */

	
	readdirres.status = NFS3_OK;
	// retreive the readdir entries.
	e = &(readdirres.res_u.ok.reply.entries);	
        while ((dp = readdir(dirp)) != NULL) {
		*e = (entry3 *) malloc(sizeof(entry3));
		(*e)->fileid = pseudo_inode (dp->d_ino, sbuf.st_dev);
		(*e)->name =  malloc( strlen(dp->d_name) + 1);
        	/* (*e)->cookie = cookieval;	*/
        	strcpy((*e)->name , dp->d_name);
		dloc = htonl(telldir(dirp));
		// printf("fileid is %ld\n", (*e)->fileid);
		// printf("name is %s\n", (*e)->name);
		/* memcpy((*e)->cookie, &dloc, sizeof(__u64)); */
		(*e)->cookie = dloc;
		e = &((*e)->nextentry);		
		/* cookieval++; */
        }
	*e =  NULL;
	closedir(dirp);
	
	readdirres.res_u.ok.reply.eof = TRUE;
	
	// get the directory attributes post operation.
	readdirres.res_u.ok.dir_attributes.attributes = TRUE;
	status = fhc_getattr (h, 
		 &(readdirres.res_u.ok.dir_attributes.attr), 
		 NULL, rqstp);
	/* printf("TYPE is %d\n",
		 readdirres.res_u.ok.dir_attributes.attr.type); */
	/* while (readdirres.res_u.ok.reply.entries != NULL) {
		printf("fileid is %d\n", 
		readdirres.res_u.ok.reply.entries->fileid);
		readdirres.READDIR3res_u.resok.reply.entries =
		readdirres.res_u.ok.reply.entries->nextentry;
	} */
	// strcpy (readdirres.res_u.ok.cookieverf, "0\0");	
	readdirres.status = NFS3_OK;
 return (&readdirres);
}

/* WRITE */
WRITE3res * nfsproc3_write_3_svc
		(WRITE3args * argp, struct svc_req *rqstp){
  static WRITE3res 	writeres;
  nfsstat3 		status;
  fhcache 		*fhc;
  int 			fd;
  int			writeval;

  // printf("ENTERED WRITE\n");
  // printf("WRITE: string is %s\n",  argp->data.data_val);

  // authenticate the file handle.
  fhc = auth_fh(rqstp, argp->file.data.data_val,  
			&status, CHK_WRITE | CHK_NOACCESS);

  if(fhc == NULL){
		writeres.status = NFS3ERR_INVAL;  			 	
		return (&writeres);	 
  }

  // get the file descriptor.
  if ((fd = fh_fd(fhc, &status, O_WRONLY)) < 0) {
	       writeres.status = NFS3ERR_IO;
	       return (&writeres);	 
  } 

  // printf("WRITE: string is %s\n",  argp->data.data_val);
  errno = 0;
  (void) lseek (fd, (long) argp->offset, SEEK_SET);

  if( errno == 0) { /* we should not fail */
		// do a write call.
	if ((writeval = write(fd, argp->data.data_val, argp->data.data_len)) 
	    != argp->data.data_len)  {
            // printf("WRITE Failure errno is %d\n", errno);	 
        } 
	// printf("WRITE: writeval is %d\n", writeval);
   } 
  fd_inactive (fd);
  if (errno) {
      writeres.status = nfs_errno();
      return (&writeres);
   }

  // count
  /* writeres.res_u.ok.count = writeval;
     writeres.res_u.ok.committed = FILE_SYNC;
     strcpy (writeres.res_u.ok.verf, "0"); */

   status = fhc_getattr (fhc, 
		 &(writeres.res_u.ok.file_attributes), 
		 NULL, rqstp);
   if (status != NFS3_OK) {
	writeres.status = status;
	return(&writeres);
   }
    
   writeres.status = NFS3_OK ; 
   return (&writeres);
}

static inline nfsstat3 
build_path (struct svc_req *rqstp, char *buf, diropargs3 *da, int flags)

{
       fhcache 		*fhc;
       nfsstat3 		status;
       char 		*path = buf, *sp;
        
       /* Authenticate directory file handle */
        if ((fhc = auth_fh(rqstp, da->dir.data.data_val, &status, flags))
		 == NULL)
                return status;

        /* Get the directory path and append "/" + dopa->filename */  
        sp = fhc->path;
   	// printf("BUILD pATH is %s\n", sp);

        while (*sp)             /* strcpy(buf, fhc->path); */
                *buf++ = *sp++;    
        *buf++ = '/';           /* strcat(buf, "/");  */
	// printf("before daname\n");
        sp = da->name;
        
	// printf("BP: after cat %c", *sp );
  
        while (*sp) {           /* strcat(pathbuf, argp->where.name); */
                if (*sp == '/')
                        return NFS3ERR_INVAL;
                *buf++ = *sp++;
        }
        *buf = '\0';
	// printf("BP: before return\n");
        if (strlen(path) > NFS3_MAXPATHLEN)
                return NFS3ERR_NAMETOOLONG;
    
     return (NFS3_OK);
}

#define CREATE_OMODE O_WRONLY 

/* CREATE */

CREATE3res *nfsproc3_create_3_svc 
		(CREATE3args *argp, struct svc_req *rqstp ){
      static CREATE3res 	createres;
      nfsstat3 			status, status1;
      int 			tmpfd, flags;
      struct stat 		sbuf;
      struct stat 		*sbp = &sbuf;
      int 			exists;	

      // printf("ENTERED CREATE\n");
      // create service routine.
      // pre_op_attr : pre operation attributes.
      /* createres.res_u.ok.dir_wcc.before.attributes = TRUE;	 
      status1 =  fh_wcc_attr (argp->where.dir.data.data_val,
		   &(createres.res_u.ok.dir_wcc.before.attr),	
		   NULL, rqstp); 
      // printf ("CREATE status 1 is %d\n", status1);
      // printf ("CREATE PRE: %ld\n",
      createres.res_u.ok.dir_wcc.before.attr.size); */
      
      // given the directory : build the path	
      status = build_path (rqstp, pathbuf, &argp->where, CHK_WRITE | 
							    CHK_NOACCESS);
      if( status != NFS3_OK && status != NFS3ERR_ROFS)
			{
		        createres.status = status;
			return (&createres);     	
			}
      // printf("full pat is %s\n", pathbuf);
      errno = 0;
      exists = lstat (pathbuf, &sbuf) == 0;
      // printf("exists is %d\n", exists); 

      // general case : for reg file creation.
      {
      flags = CREATE_OMODE ;	
      if(!exists)
		flags |= O_CREAT; //bitwise ored with O_CREAT to create file. 
       
      tmpfd = path_open(pathbuf, flags,  S_IRWXU);
         
      if (tmpfd < 0){
		// printf("entered failure\n");
		goto failure;
      		}
      (void) fstat ( tmpfd, &sbuf);
      }	
      // printf("before fh_compose\n"); 
	
      // Compose the file handle for the newly created file.
      createres.res_u.ok.obj.handle_follows = TRUE;
      status = fh_compose (&(argp->where), 
		   &(createres.res_u.ok.obj.handle),
	            &sbp, tmpfd, flags, 0);
        
      if (status != NFS3_OK)
		goto failure;

	// attributes of the newly created file.
       createres.res_u.ok.obj_attributes.attributes = TRUE;
       status = fh_getattr (   	
		   createres.res_u.ok.obj.handle.data.data_val,
		   &(createres.res_u.ok.obj_attributes.attr),
	           sbp, rqstp);
		
      if (status != NFS3_OK) {
		tmpfd = -1;
	 	goto failure;
       }	
	
       createres.status = NFS3_OK; // return success.
       return (&createres);
failure:
	if (tmpfd != -1)
		close (tmpfd);
	 createres.status = errno;
	 return (&createres);
}

/* MKNOD   */
MKNOD3res *nfsproc3_mknod_3_svc 
			(MKNOD3args *argp, 
				struct svc_req *rqstp) {
  static MKNOD3res 	mknodres;
  nfsstat3 		status, status1; 
  struct stat 		sbuf;
  struct stat 		*sbp = &sbuf;
  int 			dev;
  int 			is_borc;
  int 			exists;
  struct 		sockaddr_un sa;  
  int 			s;
  int			tmpfd, flags;


  // printf("ENTERED MKNOD\n");

  /* pre_op_attr: dir_wcc */
  mknodres.res_u.ok.dir_wcc.before.attributes = TRUE;	 
  status1 =  fh_wcc_attr (argp->where.dir.data.data_val,
		   &(mknodres.res_u.ok.dir_wcc.before.attr),	
		   NULL, 
		   rqstp); 
    
  // build the path given the directory path. 
  status = build_path (rqstp, pathbuf, &argp->where, CHK_WRITE | 
							    CHK_NOACCESS);
  if( status != NFS3_OK && status != NFS3ERR_ROFS)
			{
 	                mknodres.status = status;
			return (&mknodres);     	
			}
  // printf("full pat is %s\n", pathbuf);
  errno = 0;
  exists = lstat (pathbuf, &sbuf) == 0;
  // printf("exists is %d\n", exists); 
	
  /* First handle any unusual file-types */  
	if (argp->what.type != NF3REG) {
		if ((argp->what.type == NF3BLK) ||
		    (argp->what.type == NF3CHR)) {
	// block or character device file.
	is_borc = 1;        	

	dev = (dev_t) argp->what.mknoddata3_u.device.dev_attributes.size.size;  
	if (dev != argp->what.mknoddata3_u.device.dev_attributes.size.size){
			 mknodres.status = NFS3ERR_INVAL; 
                         return(&mknodres) ;     	
	}
         	

   } 
   else {
	  is_borc = 0;
	  dev = 0;	
   }  
	
   if (!exists) { /* to create a socket. */
		// printf("enters exist tyup eis %d\n",argp->what.type );
			  if(argp->what.type == NF3SOCK) { 
			  // printf("before sock creation\n");
                          if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0){
                           mknodres.status = nfs_errno();
			   	   return (&mknodres);
                          }
                          sa.sun_family = AF_UNIX;
                          strncpy(sa.sun_path, pathbuf, sizeof(sa.sun_path));
                          if (bind(s, (struct sockaddr *)&sa, sizeof(sa)) < 0){
                                (void) close(s);
				{
                          mknodres.status = nfs_errno();
				  return (&mknodres);
    				}
                          }
			(void) close (s);
	               } else {
           		/*	 for remaining special file types  */
		 	if (mknod(pathbuf, 
			argp->what.mknoddata3_u.pipe_attributes.mode.mode, dev) < 0){
                        mknodres.status = nfs_errno();
		        return (&mknodres);
                 	}
                 	if (stat(pathbuf, &sbuf) < 0)  {
                        	mknodres.status = nfs_errno();
		        	return (&mknodres);
	         		}	
	    	       }
       } else {
	// IF the special file exists.
	/* But make sure it's the same kind of special file. */
	// check for the mode of the special file.
        // check if the major and minor device numbers agree 
	// if they are block or character file.	
      } 
    } else {
	   /* REGULAR file to be handled by CREATE, MKDIR or SYMLINK */
	
	mknodres.status = NFS3ERR_BADTYPE;
	return (&mknodres);
    }

    /* set the attributes */
 	if (!exists) {
         argp->what.mknoddata3_u.pipe_attributes.gid.gid  = -1;
	
	status = setattr (pathbuf, 
				&argp->what.mknoddata3_u.pipe_attributes,
				&sbuf, rqstp, SATTR_ALL & ~SATTR_SIZE);
   } else {
	status = setattr (pathbuf, &argp->what.mknoddata3_u.pipe_attributes,
			  &sbuf, rqstp, SATTR_SIZE); 
   } 

  if (status != NFS3_OK){
	mknodres.status = status;
	return(&mknodres);   
	}
   /* post_op_fh3 */
   mknodres.res_u.ok.obj.handle_follows = TRUE;
   status = fh_compose (&(argp->where), 
		&(mknodres.res_u.ok.obj.handle),
			&sbp, tmpfd, CREATE_OMODE, 0);
   /* post_op_attr */
   mknodres.res_u.ok.obj_attributes.attributes = TRUE;
   status = fh_getattr (   	
		   mknodres.res_u.ok.obj.handle.data.data_val,
		   &(mknodres.res_u.ok.obj_attributes.attr),
	           sbp, rqstp);
  /* post_op_attr : dir_wcc */

  mknodres.status = NFS3_OK; // return success. 
  return (&mknodres);

failure:
	if (tmpfd != -1)
		close (tmpfd);
	mknodres.status = (errno? nfs_errno() : status);
	return (&mknodres);
} 


/* MKDIR */
MKDIR3res * nfsproc3_mkdir_3_svc 
		(MKDIR3args *argp, struct svc_req *rqstp) {
	static MKDIR3res 		mkdirres ;
	nfsstat3 			status, status1;
	struct stat 		sbuf;
	struct stat 		*sbp = &sbuf;
	
	// printf("ENTERED MKDIR\n");
	// pre_op_attr : pre operation attributes.
	
        /* mkdirres.res_u.ok.dir_wcc.before.attributes = TRUE;	 
        status1 =  fh_wcc_attr (argp->where.dir.data.data_val,
		   &(mkdirres.res_u.ok.dir_wcc.before.attr),	
		   NULL, 
		   rqstp); 
        printf ("MKDIR status 1 is %d\n", status1);
        printf ("MKDIR PRE: %ld\n",
	    mkdirres.res_u.ok.dir_wcc.before.attr.size); */

        status = build_path(rqstp, pathbuf, &argp->where, 
				CHK_WRITE | CHK_NOACCESS);
	if (status != NFS3_OK)
		{
		mkdirres.status = status; 
		return (&mkdirres);	
		}
	// mkdir the new directory.
	if (mkdir (pathbuf, 755) != 0)
		{
		status  = nfs_errno();
		mkdirres.status = status;
		return (&mkdirres);
	}
	// Compose the corresponding file handle.
        mkdirres.res_u.ok.obj.handle_follows = TRUE;
        status = fh_compose (&(argp->where), 
		   &(mkdirres.res_u.ok.obj.handle),
				&sbp, -1, -1, 0); 
	// post_op_attr: post operation attributes.
	// and the attributes.
	mkdirres.res_u.ok.obj_attributes.attributes = TRUE;
	status = fh_getattr (   	
		   mkdirres.res_u.ok.obj.handle.data.data_val,
		   &(mkdirres.res_u.ok.obj_attributes.attr),
	           sbp, rqstp);
	        	
      if  (status != NFS3_OK) {
	   mkdirres.status = status;
         return(&mkdirres); 
      }
      mkdirres.status = NFS3_OK; // return success.
      return (&mkdirres);
}


/* SYMLINK:  not ok  */
SYMLINK3res *nfsproc3_symlink_3_svc 
			(SYMLINK3args *argp, struct svc_req *rqstp) {
   static SYMLINK3res 	symlinkres;
   nfsstat3		status, status1;
   int 			ispublic;
   struct stat		sbuf;
   struct stat		*sbp = &sbuf;
   fhcache		*fhc;
   // fhcache  		*fhc1, *fhc2;
	
   // printf("SYMLINK argp is %ld\n", argp->where.dir.data.data_val); 	
   // printf("SYMLINK argp is %s\n", argp->where.name);
   /* printf("SYMLINK link is %ld\n", 
           argp->symlink.symlink_attributes.mode.mode); */
   /* printf("\nSYMLINKold  path is %s\n", 
	   argp->symlink.symlink_data); */
   // printf("\nENTERED SYMLINK\n");
	
   // pre_op_attr : pre operation attributes. 
   /* symlinkres.res_u.ok.dir_wcc.before.attributes = TRUE;	 
   status1 = fh_wcc_attr (argp->where.dir.data.data_val,
			  &(symlinkres.res_u.ok.dir_wcc.before.attr),	
			  NULL, rqstp); 
   printf("SYMLINK status 1 is %d\n", status1);
   printf("SYMLINK PRE: %ld\n",
	    symlinkres.res_u.ok.dir_wcc.before.attr.size); */
					    
   status = build_path (rqstp, pathbuf, &argp->where, 
				CHK_WRITE | CHK_NOACCESS);

   if (status != NFS3_OK) {
   	symlinkres.status = status;
	return (&symlinkres);
	}
    // printf("SYMLINK path is %s\n", pathbuf);
    // printf("\nSYMLINKold  path is %s\n", argp->symlink.symlink_data);
   // create the symlink.
   if (symlink(argp->symlink.symlink_data, pathbuf) != 0) {
   symlinkres.status = nfs_errno();
   return (&symlinkres);
   }
    // post_op_fh3
   symlinkres.res_u.ok.obj.handle_follows = TRUE;
   status = fh_compose (&argp->where, 
			     &(symlinkres.res_u.ok.obj.handle), 
			     &sbp, -1, -1, ispublic);

   // authenticate the file handle.	
   fhc = auth_fh (rqstp, 
	      symlinkres.res_u.ok.obj.handle.data.data_val, 
			&status, CHK_READ);
   // get the file attributes.
   status = fhc_getattr (fhc,
	    &(symlinkres.res_u.ok.obj_attributes.attr),
	    NULL, rqstp);
   /* printf("nlink is %d\n",
	       symlinkres.res_u.ok.obj_attributes.attr.nlink); */

    // post_op_attr
    /* fhc1 = auth_fh (rqstp, 
	      	    argp->where.dir.data.data_val, 
		    &status1, CHK_READ);
    symlinkres.res_u.ok.dir_wcc.after.attributes = TRUE;	 
    status1 = fhc_getattr (fhc1,
			   &(symlinkres.res_u.ok.dir_wcc.after.attr),	
			   sbp, rqstp); */ 
    symlinkres.status = NFS3_OK;
    return (&symlinkres);
}

/* RENAME */

RENAME3res * nfsproc3_rename_3_svc 
		(RENAME3args *argp, struct svc_req *rqstp) {
	static RENAME3res 	renameres;
	nfsstat3 		status, status1;
   	// struct stat		sbuf;
   	// struct stat		*sbp = &sbuf;

        // printf("ENTERED RENAME\n");
 	// rename service routine.
	// build the path given the directory. 
	status = build_path (rqstp, pathbuf, &argp->from, 
					CHK_WRITE | CHK_NOACCESS);
	if (status != NFS3_OK) {
	    renameres.status = status;
	    return (&renameres);
        }
	
        status = build_path (rqstp, pathbuf_1, &argp->to, 
					CHK_WRITE | CHK_NOACCESS);
	if (status != NFS3_OK) { 
	    renameres.status = status;
	    return (&renameres);
         }
	
	// pre_op_attr: fromdir

         renameres.res_u.ok.fromdir_wcc.before.attributes = TRUE; 
         status1 =  fh_wcc_attr (argp->from.dir.data.data_val,
   			&(renameres.res_u.ok.fromdir_wcc.before.attr),	
		   		NULL, rqstp); 
      	 // printf ("RENAME status 1 is %d\n", status1);
         /* printf ("RENAME PRE: %ld\n",
    		renameres.res_u.ok.fromdir_wcc.before.attr.size); */

	// pre_op_attr: todir	
         renameres.res_u.ok.todir_wcc.before.attributes = TRUE;	 
         status1 =  fh_wcc_attr (argp->to.dir.data.data_val,
   			&(renameres.res_u.ok.todir_wcc.before.attr),	
   			NULL, rqstp); 

         // printf ("RENAME status 1 is %d\n", status1);
         /* printf ("RENAME PRE: %ld\n",
  		renameres.res_u.ok.todir_wcc.before.attr.size); */
		
		
         /* remove any file handle from our cache */
	 fh_remove (pathbuf);
	 fh_remove (pathbuf_1);

	 if (rename (pathbuf, pathbuf_1) != 0){
	 renameres.status = nfs_errno();
         return (&renameres);
	 }
	 // post_op_attr: from dir
         renameres.res_u.ok.fromdir_wcc.after.attributes = TRUE;
         status = fh_getattr(argp->from.dir.data.data_val, 
			&(renameres.res_u.ok.fromdir_wcc.after.attr),
        		NULL, rqstp);
         /* printf("type is %d\n", 
			renameres.res_u.ok.fromdir_wcc.after.attr.type); */
	
	// post_op_attr : to dir
        renameres.res_u.ok.todir_wcc.after.attributes = TRUE;
        status = fh_getattr(argp->to.dir.data.data_val, 
			&(renameres.res_u.ok.todir_wcc.after.attr),
      		NULL, rqstp);
        /* printf("type is %d\n", 
			renameres.res_u.ok.todir_wcc.after.attr.type); */
			
	renameres.status = NFS3_OK; // return success. 
	return (&renameres);
}

/* REMOVE */

REMOVE3res *nfsproc3_remove_3_svc 
			(REMOVE3args *argp, struct svc_req *rqstp) {
   static REMOVE3res 	removeres; 
   nfsstat3 		status, status1;
   // struct stat		sbuf;
   // struct stat		*sbp = &sbuf;
   
   // printf("ENTERED REMOVE\n");
    
   // printf("RM: path is %s\n", argp->object.name); 
   // build the path given the directory.
   status = build_path (rqstp, 
	pathbuf, &argp->object, CHK_WRITE | CHK_NOACCESS);
	if (status != NFS3_OK) {
		removeres.status = status;
	 	return(&removeres); 
	}  

    /* pre_op_attr */
    removeres.res_u.ok.dir_wcc.before.attributes = TRUE;	 
    status1 =  fh_wcc_attr (argp->object.dir.data.data_val,
   			&(removeres.res_u.ok.dir_wcc.before.attr),	
   			NULL, rqstp); 
    // printf ("REMOVE status 1 is %d\n", status1);
    /* printf ("REMOVE PRE: %ld\n",
   		removeres.res_u.ok.dir_wcc.before.attr.size); */

    // printf("RM: pathbuf is %s\n", pathbuf);
    /* remove the file handle from our cache */
    fh_remove (pathbuf);
 
    if (unlink (pathbuf) != 0){
	removeres.status = nfs_errno ();	
	return (&removeres);
    }
  
    /* post_op_attr */ 
    removeres.res_u.ok.dir_wcc.after.attributes = TRUE;
    status = fh_getattr(argp->object.dir.data.data_val, 
				&(removeres.res_u.ok.dir_wcc.after.attr),
                        NULL, rqstp);
    /* printf("type is %d\n", 
			removeres.res_u.ok.dir_wcc.after.attr.type); */

    removeres.status = NFS3_OK ; // return the success status.
    return (&removeres);
}

/* RMDIR */

RMDIR3res *nfsproc3_rmdir_3_svc 
		(RMDIR3args *argp, struct svc_req *rqstp) {
 	static RMDIR3res	rmdirres;
 	nfsstat3 		status=0, status1;
   	// struct stat		sbuf;
   	// struct stat		*sbp = &sbuf;
 
 	// printf("INSIDE RMDIR\n");
	// rmdir service routine.

 	status = build_path (rqstp, pathbuf, &argp->object, 
					CHK_WRITE | CHK_NOACCESS);
 	if (status != NFS3_OK) {
	rmdirres.status = status;
 	return(&rmdirres); 
  	} 
	
	// pre_op_attr.
    	rmdirres.res_u.ok.dir_wcc.before.attributes = TRUE;	 
    	status1 =  fh_wcc_attr (argp->object.dir.data.data_val,
   				&(rmdirres.res_u.ok.dir_wcc.before.attr),	
   					NULL, rqstp); 
    	// printf ("RMDIR status 1 is %d\n", status1);
    	/* printf ("RMDIR PRE: %ld\n",
				rmdirres.res_u.ok.dir_wcc.before.attr.size);

 	printf("RMDIR:  path is %s\n", pathbuf); */

 	fh_remove (pathbuf);
	// remove the directory.
 	if (rmdir (pathbuf) != 0) {
   		rmdirres.status = nfs_errno ();
   		// printf("inside rmdir\n");
   		return (&rmdirres); 
 	}
	
	// post_op_attr.
    	rmdirres.res_u.ok.dir_wcc.after.attributes = TRUE;
        status = fh_getattr(argp->object.dir.data.data_val, 
				&(rmdirres.res_u.ok.dir_wcc.after.attr),
        			NULL, rqstp);
    	/* printf("type is %d\n", 
			rmdirres.res_u.ok.dir_wcc.after.attr.type); */
 	
	rmdirres.status = NFS3_OK; // return success.
 	return (&rmdirres);
}

/* READLINK : not ok */
READLINK3res *nfsproc3_readlink_3_svc 
		(READLINK3args *argp, struct svc_req *rqstp) {
 	nfsstat3 			status;
	static READLINK3res 		rdlinkres;
	fhcache 			*fhc;
	char 				*path;
	int 				cc;

	// printf("ENTERED READLINK\n");
	// authenticate the file handle.
	fhc = auth_fh (rqstp, argp->symlink.data.data_val, &status, CHK_READ | CHK_NOACCESS);

	if (fhc == NULL) {
	rdlinkres.status = status;
	return (&rdlinkres);
	}

	path = fhc->path;
	errno = 0;
	// read the link.
	if ((cc = readlink (path, pathbuf, NFS3_MAXPATHLEN)) < 0) {
	rdlinkres.status = nfs_errno ();
	return (&rdlinkres);
        }
	status = NFS3_OK;
	pathbuf[cc] = '\0';
	rdlinkres.res_u.ok.data = pathbuf;
	// printf("RDLINK pathbuf is %s\n", pathbuf);
	if (pathbuf[0] == '/') {
         	int slash_cnt = 0;
	      char *p, *q;

	    /* count how many directories down we are */
	
	   for (p = path + 1; *p != '\0'; p++)
              if (*p == '/')
                  slash_cnt++;
                  p = &pathbuf[cc];   /* Point to the end and calculate */
                if (slash_cnt == 0)
                    q = p + 1;      /* the extra space taken by a   */
                else                /* prepended '.'                */
                    q = p + 3 * slash_cnt - 1;      /* or '../.../..' */
                 
                if (q >= pathbuf + NFS3_MAXPATHLEN) {
                        status = NFS3ERR_NAMETOOLONG;
			rdlinkres.status = status;
			return (&rdlinkres);
			} else {

  			/* Add some space at the beginning of the string. */
                        	while (p >= pathbuf)
                                *q-- = *p--;
                
                        	if (slash_cnt == 0)
                                pathbuf[0] = '.';
                        	else {
                                /*
                                 * This overwrites the leading '/' on the
                                 * last iteration.
                                 */
                                for (p = pathbuf; slash_cnt > 0; slash_cnt--) {
                                        *p++ = '.';
                                        *p++ = '.';
                                        *p++ = '/';
                                	}
                                    }
			      }
		}		
	 // printf("RD data :%s\n", rdlinkres.res_u.ok.data);
	 
	 // post_op_attr : symlink_attributes
	 rdlinkres.res_u.ok.symlink_attributes.attributes = TRUE; 
         status = fh_getattr (argp->symlink.data.data_val,
	 		&(rdlinkres.res_u.ok.symlink_attributes.attr),
	   				NULL, rqstp);
         /* printf("TYPE is %d\n",
	   	 rdlinkres.res_u.ok.symlink_attributes.attr.type); 
	   
         printf("mode is %d\n",
	   	 rdlinkres.res_u.ok.symlink_attributes.attr.mode); */ 

   	 rdlinkres.status = NFS3_OK;  // return success.
	 return (&rdlinkres);	
}


/* LINK  : not ok*/
LINK3res * nfsproc3_link_3_svc 
			(LINK3args *argp, struct svc_req *rqstp) {
   static LINK3res 	linkres;
   nfsstat3 		status,status1;
   fhcache 			*fhc;
   char 			*path;
   // struct stat		sbuf;
   // struct stat		*sbp = &sbuf;
  
   // printf("ENTERED LINK\n");

   // pre_op_attr.
   linkres.res_u.ok.linkdir_wcc.before.attributes = TRUE;	 
   status1 =  fh_wcc_attr (argp->link.dir.data.data_val,
		   		  &(linkres.res_u.ok.linkdir_wcc.before.attr),	
		   		  NULL, rqstp); 
   // printf ("LINK status 1 is %d\n", status1);
   /* printf ("LINK PRE: %ld\n",
    		linkres.res_u.ok.linkdir_wcc.before.attr.size); */
	 	
   fhc = auth_fh (rqstp, argp->file.data.data_val, &status, CHK_WRITE | CHK_NOACCESS);
   if (fhc == NULL){
   linkres.status = status;
   return(&linkres);  
   } 	
       
   path = fhc->path;
   status = build_path(rqstp, pathbuf_1, &argp->link, CHK_WRITE | CHK_NOACCESS);

   if (status != NFS3_OK){
   linkres.status = status;
   return(&linkres);
   } 
   // printf("LINK: path is %s\n", path);
   // printf("LINK: pathbuf is %s\n",pathbuf_1);

   // create the link. 
   if (link (path, pathbuf_1) != 0){
   linkres.status = nfs_errno ();
   // printf("LINK status is %d\n", linkres.status);
   return (&linkres);
   }	
   linkres.res_u.ok.file_attributes.attributes = TRUE;
   status = fhc_getattr (fhc,
	    			&(linkres.res_u.ok.file_attributes.attr),
	    			NULL, rqstp);
   /* printf("TYPE is %d\n",
	     linkres.res_u.ok.file_attributes.attr.type); */ 

   // post_op_attr: linkdir

   linkres.res_u.ok.linkdir_wcc.after.attributes = TRUE;
   status = fh_getattr(argp->link.dir.data.data_val, 
		&(linkres.res_u.ok.linkdir_wcc.after.attr),
                     NULL, rqstp);
   /* printf("type is %d\n", 
	       linkres.res_u.ok.linkdir_wcc.after.attr.type); */
	   
   linkres.status = NFS3_OK; // return success.		
   return (&linkres);
}

/* SETATTR */

SETATTR3res * nfsproc3_setattr_3_svc ( SETATTR3args *argp, 
				       struct svc_req *rqstp ) {
    static SETATTR3res 		setres;
    nfsstat3 			status, status1;
    fhcache 			*fhc;
    char 				*path;
    struct stat 			buf, *opt;
    // struct stat		sbuf;
    // struct stat		*sbp = &sbuf;

    // printf("ENTERED SETATTR\n");
    // authenticate the given file handle.
    fhc = auth_fh (rqstp, argp->object.data.data_val, 
			&status, CHK_WRITE | CHK_NOACCESS);
    // pre_op_attr.
    setres.res_u.ok.obj_wcc.before.attributes = TRUE;	 
    status1 =  fh_wcc_attr (argp->object.data.data_val,
		   &(setres.res_u.ok.obj_wcc.before.attr),	
		   NULL, rqstp); 
    // printf ("SETATTR status 1 is %d\n", status1);
    /* printf ("SETATTR size: %ld\n",
    		setres.res_u.ok.obj_wcc.before.attr.size); */
    /* printf("setattr secs is %ld\n",
		setres.res_u.ok.obj_wcc.before.attr.ctime.seconds); */
 
    if (fhc == NULL) {
         setres.status = status;	
         return (&setres);
    }

    path = fhc->path;
    errno = 0;
    /* stat the file first and only change fields that are different. */
    if (lstat (path, &buf) < 0)
	 goto failure;

    status = setattr (path, &(argp->new_attributes), &buf, rqstp, SATTR_ALL);
    if (status != NFS3_OK ) {

    setres.status = status;
    return (&setres);
    }
   opt = &buf;
   if (argp->guard.obj_ctime.seconds == -1 )
	opt = NULL;
   /* get the post operation attributes */
    
   setres.res_u.ok.obj_wcc.after.attributes = TRUE;
   status = fh_getattr(argp->object.data.data_val, 
		&(setres.res_u.ok.obj_wcc.after.attr),
                     NULL, rqstp);
   /* printf("type is %d\n", 
	       setres.res_u.ok.obj_wcc.after.attr.type); */
   
   setres.status = NFS3_OK; 	 // return success. 
   return (&setres);

 failure:
	setres.status = nfs_errno ();
	return (&setres);
}


/* fsstat retrieves volatile file system state information */

FSSTAT3res * nfsproc3_fsstat_3_svc ( FSSTAT3args *argp, 
					struct svc_req * rqstp) {
  static FSSTAT3res 	fsres;
  nfsstat3 		status=0;
  fhcache 		*fhc;
  char 			*path;
  struct statfs 	sbuf;
  struct statfs 	*buf = &sbuf;

  // printf("ENTERED FSSTAT\n");
  // file system status information.
  // authenticate the given file handle.
  fhc = auth_fh (rqstp, argp->fsroot.data.data_val, &status, CHK_READ | CHK_NOACCESS );  
  if (fhc == NULL) {

  fsres.status = status; 
  return (&fsres);
  }    

  path = fhc->path;
  
  if (statfs ( path, buf) < 0) {
  status = nfs_errno();
  fsres.status = nfs_errno();
  return (&fsres);
  } 

  fsres.res_u.ok.obj_attributes.attributes = 1;
  status = fh_getattr(argp->fsroot.data.data_val, 
			&(fsres.res_u.ok.obj_attributes.attr),
                  NULL, rqstp);
  /* printf("type is %d\n", 
		fsres.res_u.ok.obj_attributes.attr.type); */
	
  fsres.res_u.ok.tbytes = buf->f_blocks;
  fsres.res_u.ok.fbytes = buf->f_bfree;
  fsres.res_u.ok.tfiles = buf->f_files;
  fsres.res_u.ok.ffiles = buf->f_ffree;
  fsres.res_u.ok.afiles = 0;
  fsres.res_u.ok.invarsec = 0;

  fsres.status = NFS3_OK;  // return success.
  return ( &fsres);
}

/* COMMIT : not ok */
COMMIT3res *nfsproc3_commit_3_svc (COMMIT3args *argp, struct svc_req *rqstp) {
  static COMMIT3res 	commitres;
  nfsstat3 			status, status1;
  fhcache 			*fhc;
  int 			fd;
  // struct stat		sbuf;
  // struct stat		*sbp = &sbuf;
  
  // printf("ENTERED COMMIT\n");
 
  // authenticate the given file handle. 
  fhc = auth_fh(rqstp, argp->file.data.data_val, &status, CHK_WRITE | CHK_NOACCESS);


  // pre_op_attr : pre operation attributes.
   commitres.res_u.ok.file_wcc.before.attributes = TRUE;	 
   status1 = fh_wcc_attr (argp->file.data.data_val,
			  &(commitres.res_u.ok.file_wcc.before.attr),	
			  NULL, rqstp); 
   // printf("SYMLINK status 1 is %d\n", status1);
   /* printf("SYMLINK PRE: %ld\n",
	    commitres.res_u.ok.file_wcc.before.attr.size); */

  if (fhc == NULL) {
		   commitres.status = NFS3ERR_INVAL;
		   return (&commitres); 
  }
  if ((fd = fh_fd(fhc, &status, O_WRONLY)) < 0) {
		commitres.status = NFS3ERR_IO;
		return (&commitres);
  }	

  errno = 0;

  (void) lseek (fd, (long)argp->offset, SEEK_SET); 
 
  if (errno == 0) {  /* commit or sync to the disk  */

	if (fsync(fd) < 0) {
		status = errno;  	
		} 
	}
  fd_inactive (fd);
  if (errno) {
	commitres.status = nfs_errno();
	return (&commitres);
  }
 // post_op_attr 
  
 strcpy ( commitres.res_u.ok.verf, "0");
  
 commitres.status = NFS3_OK;  // return success.
 return (&commitres);

}  

/* PATHCONF : not ok */ 
PATHCONF3res * nfsproc3_pathconf_3_svc (PATHCONF3args *argp, 
			struct svc_req *rqstp) {
   static PATHCONF3res 		pathres;
   nfsstat3 			status;
   int 				fd;
   fhcache 				*fhc;
 

   // printf("ENTERED PATHCONF\n"); 
   // obtain the file descriptor given the file handle. 
      
   // printf("full path is %s\n", pathbuf);
   // retrieve the configuration values.
    fhc = auth_fh (rqstp, argp->object.data.data_val, &status, CHK_READ | CHK_NOACCESS);
   if ((fd = fh_fd (fhc, &status, O_RDWR)) < 0) {
		// printf("neg case\n");
		status = NFS3ERR_ISDIR;
            pathres.status = status;
		return (&pathres);
	}  
   
   // printf("fd is %d\n", fd); 
   // retrieve the attributes of the file.
   pathres.res_u.ok.obj_attributes.attributes = TRUE; 
   pathres.status = fh_getattr(argp->object.data.data_val, 
					&(pathres.res_u.ok.obj_attributes.attr), 
                           	NULL, rqstp);
   // retrieve POSIX information.
   // printf("PCF: status is %d\n", pathres.status); 
   pathres.res_u.ok.link_max = fpathconf(fd, _PC_LINK_MAX);
   pathres.res_u.ok.name_max = fpathconf(fd, _PC_NAME_MAX);
   pathres.res_u.ok.no_trunc = fpathconf(fd, _PC_NO_TRUNC);
   pathres.res_u.ok.chown_restricted = 
					fpathconf(fd, _PC_CHOWN_RESTRICTED);

   pathres.status = NFS3_OK;
   return (&pathres);
}   


/* READDIRPLUS3 : not ok */

READDIRPLUS3res *nfsproc3_readdirplus_3_svc 
			(READDIRPLUS3args *argp, struct svc_req *rqstp)  {
    static READDIRPLUS3res 	readdirplus;
    entryplus3 			**e;
    DIR 			*dirp;
    struct dirent 		*dp;
    struct stat			sbuf;
    struct stat			*sbp = &sbuf;
    fhcache 			*h;
    nfsstat3 			status;
    diropargs3 			*dirh;
    int 			ispublic = 0, iterate;
     

    dirh = (diropargs3 *)malloc (sizeof(struct diropargs3));
    dirh->name = (char *)malloc (sizeof(char) *20);

    dirh->dir.data.data_val = (char *) malloc (sizeof(char)*MAX_SIZE);	
	 
    // printf("ENTERED READDIRPLUS");

    // authenticate the given file handle.
    h = auth_fh(rqstp, argp->dir.data.data_val, &status, CHK_READ);
    if (h == NULL){   
        readdirplus.status = NFS3ERR_INVAL;
        return (&readdirplus);
    }
	
    errno = 0; 
    // printf("h-pathis %s\n", h->path);
    if (lstat(h->path, &sbuf)  < 0  || ! (S_ISDIR(sbuf.st_mode))){
        readdirplus.status = NFS3ERR_NOTDIR;
        return (&readdirplus);
        }

     // open the directory.
    if ((dirp = opendir(h->path)) == NULL){
                errno ? nfs_errno() : NFS3ERR_NAMETOOLONG;  
                readdirplus.status = errno;
                return(&readdirplus);
                }
    // printf("argcookie is %ld\n", argp->cookie);
   
    e = &(readdirplus.res_u.ok.reply.entries);
	dirh->dir = argp->dir;
	// get the directory entries.
	while ((dp = readdir(dirp)) != NULL) {
        
        *e = (entryplus3 *) malloc(sizeof(entryplus3));
        (*e)->fileid = pseudo_inode (dp->d_ino, sbuf.st_dev);
        (*e)->name =  malloc( strlen(dp->d_name) + 1);
        strcpy((*e)->name , dp->d_name);
        // printf("name is %s\n", (*e)->name);
	dirh->dir.data.data_len = argp->dir.data.data_len;
	for (iterate = 0; iterate < MAX_SIZE; iterate++) {
	dirh->dir.data.data_val[iterate] = argp->dir.data.data_val[iterate];
	}
	strcpy(dirh->name, (*e)->name);
	(*e)->cookie = 1;
	// access the file handle .
	(*e)->name_handle.handle_follows = 1;
        status = fh_compose (dirh, &((*e)->name_handle.handle), 
				&sbp, -1, -1, ispublic);
	// printf("RDPLUS FH status is %d\n", status);
        // access the file attributes.
        (*e)->name_attributes.attributes = 1;	
   	status = fh_getattr (((*e)->name_handle.handle.data.data_val), 
		&((*e)->name_attributes.attr), sbp, rqstp);  
        e = &((*e)->nextentry);
        }
        
	*e =  NULL;
        closedir(dirp);
         
	readdirplus.res_u.ok.dir_attributes.attributes = TRUE;
	status = fhc_getattr (h, 
		&(readdirplus.res_u.ok.dir_attributes.attr),
		NULL, rqstp);
	// strcpy(readdirplus.res_u.ok.cookieverf, "0\0"); 

        // printf("before returning\n");
   	readdirplus.status = NFS3_OK; // return success.
   	return (&readdirplus);

} 


FSINFO3res * nfsproc3_fsinfo_3_svc ( FSINFO3args *argp, 
					struct svc_req * rqstp) {

  static FSINFO3res 		fsinfores;
  nfsstat3 			status=0;
  fhcache 			*fhc;
	

  // authenticate the given file handle.
  fhc = auth_fh(rqstp, argp->fsroot.data.data_val, &status, CHK_READ);

  if (fhc == NULL) {
  fsinfores.status = status; 
  return (&fsinfores);
  }    

  // obtain the static file system information.

  fsinfores.res_u.ok.rtmax = 8192;
  fsinfores.res_u.ok.rtpref = 8192;
  fsinfores.res_u.ok.rtmult = 5;
  fsinfores.res_u.ok.wtmax = 8192;
  fsinfores.res_u.ok.wtpref = 8192;
  fsinfores.res_u.ok.wtmult = 5;
  fsinfores.res_u.ok.dtpref = 8192;
  fsinfores.res_u.ok.maxfilesize = 4096;
  fsinfores.res_u.ok.time_delta.seconds = 1;
  fsinfores.res_u.ok.time_delta.nseconds = 0;
  fsinfores.res_u.ok.properties = 0x0001;
  
  // get the post-operation attributes. 
  fsinfores.res_u.ok.obj_attributes.attributes = 1;
  status = fh_getattr(argp->fsroot.data.data_val, 
			&(fsinfores.res_u.ok.obj_attributes.attr),
                  		NULL, rqstp);
  
  fsinfores.status = NFS3_OK;
  return (&fsinfores);		
}


ACCESS3res * nfsproc3_access_3_svc ( ACCESS3args *argp, 
					struct svc_req * rqstp) {

  static ACCESS3res 		accessres;
  nfsstat3 			status=0;
  fhcache 			*fhc;

  
  // printf("Access service routine\n");
  // authenticate the given file handle.
  fhc = auth_fh(rqstp, argp->object.data.data_val, &status, CHK_READ);

  if (fhc == NULL) {
  accessres.status = status; 
  return (&accessres);
  }    

  if(argp == NULL) {
  return (&accessres);
  }

  /* given the directory : build the path	
  status = build_path (rqstp, pathbuf, &argp->object, CHK_WRITE | 
							    CHK_NOACCESS);
  */

  if (status != NFS3_OK)
		{
		accessres.status = status; 
		return (&accessres);	
   }
 
   // check access permissions.

   status = access (fhc->path, argp->access);
   accessres.status = status;
   return (&accessres);	
}
