/*  MOUNT Server:
 *
 *      1. null call  	: initial client server interaction.
 *      2. mount call 	: mount a directory from server to client 
 *	                  (return the mount file handle).
 *      3. dump call 	: retreive a mount list from the server.
 *      4. umnt call  	: unmount the client entry from the mount list on 
 *			  the server. 
 *      5. umntall call : unmount all the entries of client from the server 
 *	                  mount list.
 *
 *    
 */

#include "mount.h"
#include "nfs_prot.h"
#include <linux/string.h>


int fh_create(nfs_fh3 *fh, char *arg);
extern mountlist *rmtab_list_client (void); 
extern void rmtab_del_client (dirpath path, struct svc_req *rqstp);   
extern void rmtab_mdel_client (struct svc_req *rqstp);

 
void * 
mountproc3_null_3_svc(void *argp, struct svc_req *rqstp)
{

	static char* result;

	/* return nothing */

	// printf("NULL call serviced\n");
	return((void*) &result);
}


char argbuf[MNTPATHLEN + 1];
mountres3 * 
mountproc3_mnt_3_svc(dirpath *argp, struct svc_req *rqstp)
{

	static mountres3  result;
        mountres3 *res = &result;

	res->mountres3_u.mountinfo.fhandle.fhandle3_val =
		(char *)malloc (sizeof(char)*FHSIZE3);
	
	// printf("dirpath is %s\n", *argp);  
         if(**argp == '\0') {
            strcpy(argbuf, "/");   /* if the path is null */
         }
         else {
                strncpy(argbuf, *argp, MNTPATHLEN);
                argbuf[MNTPATHLEN] = '\0';
         }
	// printf("argbuf is %s\n", argbuf);
        // printf("before file handle create\n");
	
	/* create the mount file handle and return it (NFS V3 file handle) */
        res->fhs_status = fh_create ((nfs_fh3  *)
                          &(res->mountres3_u.mountinfo.fhandle), argbuf);

	rmtab_add_client (argbuf, rqstp);
	
	/* printf("sz: is %d\n", 
	((nfs_fh3 *)&(res->mountres3_u.mountinfo.fhandle))->data.data_len); */       
	// printf ("MFH STATUS IS %d\n", res->fhs_status);
       /* printf("MFH is %08x%08x\n", res->mountres3_u.mountinfo.fhandle.fhandle3_val[0], res->mountres3_u.mountinfo.fhandle.fhandle3_val[1]); */
        return(res);
}

mountlist * 
mountproc3_dump_3_svc(void *argp, struct svc_req *rqstp)
{

	static mountlist *res;

	/* call to retreive the mount list */

        res = rmtab_list_client();
        if (res != NULL) 
	      return(res);
return(NULL);	
}

void * 
mountproc3_umnt_3_svc(dirpath *argp, struct svc_req *rqstp)
{

	static char* result;
	
	// printf("entered umnt program\n");
	// printf("UMNT: path is %s\n", *argp); 
	rmtab_del_client (*argp, rqstp);
	// printf("after rmtab_del_client\n");
	return((void*) &result);
}

void * 
mountproc3_umntall_3_svc(void *argp, struct svc_req *rqstp)
{
	static char* result;

	/* delete the client from the server mount list */	
	rmtab_mdel_client (rqstp);
	return((void*) &result);
}

exports * 
mountproc3_export_3_svc(void *argp, struct svc_req *rqstp)
{

	static exports  result;

	/*
	 * insert server code here
	 */

	return(&result);
}
