/* 
 * NFSV3 CLIENT:  	
 * Client end	     : Invokes the RPC procedures.
 * Mount protocol    : Understands the File Handle Size Change.
 * GETATTR call :
 *	       	       returns attributes of a given call. 
 * LOOKUP  call  :
 *		       returns  a file handle. 
 * READ    call  :     returns read bytes from a file.
 *
 * READDIR call  :     return contents from a directory. 
 *
 * READDIRPLUS call :  return contents from a directory with 
 *		       file-handles of the entries.
 * Copyright (c) -- 1998 - 1999 : Harish Kaushik Calathur Gopal.
 */

#include "nfs.h"
#include "mount.h"
/* system.h */
#include <sys/time.h>
#include <unistd.h>

#define MAX_SIZE 	64	
#define HALF_SIZE	32
#define CHAR_SIZE	10
#define DIR_SIZE	15
#define OFFSET		0
#define MAX_COUNT	1024
#define MAX_DATA        1024	

extern double timestamp();

/*
 * NULL call:
 * a service routine to benchmark the total overhead during a single 
 * rpc call from client to the server.
 */

void null_call(char *nfsproc3_null_3_arg, CLIENT *clt){
    void *result_1;
    struct rpc_err err;

    /* Null procedure.  */
    // printf("NFS : Null procedure\n");
    result_1 = nfsproc3_null_3((void *)&nfsproc3_null_3_arg, clt);
    if (result_1 == NULL) {
                clnt_perror(clt, "NFS null call failed:");
		printf("err stat is %d\n", err.re_status); 
		exit(0);
        }
}

/*
 * GETATTR call:
 * pre: a file handle .
 * post : a set of attributes corresponding to the file handle.
 */
void get_attr(GETATTR3args nfsproc3_getattr_3_arg, CLIENT *clt) {
        /* GETATTR procedure */
        GETATTR3res *nfs_result;
	
	// printf("entered getattr\n");  
        nfs_result = (GETATTR3res *) malloc(sizeof(GETATTR3res));
        nfs_result = nfsproc3_getattr_3(&nfsproc3_getattr_3_arg,  clt);

	if(nfs_result == NULL) {
             clnt_perror(clt, "GETATTR call failed:");
	     exit(-1);
	}        
	if (nfs_result->status  == NFS3_OK) {
	printf("\nGETATTR: attributes\n");
	printf("RESULT:status is  
		%d\n", nfs_result->status);
        printf("RESULT: result file type is %ld\n", (long) 
		nfs_result->GETATTR3res_u.resok.obj_attributes.type);
        printf("RESULT: result mode is %ld\n", (long)	
		nfs_result->GETATTR3res_u.resok.obj_attributes.mode);
        printf("RESULT: result nlink is %ld\n",
	(long)nfs_result->GETATTR3res_u.resok.obj_attributes.nlink); 
        printf("RESULT: result uid is %ld\n",
	(long)nfs_result->GETATTR3res_u.resok.obj_attributes.uid); 
        printf("RESULT: result gid is %ld\n",
	(long)nfs_result->GETATTR3res_u.resok.obj_attributes.gid); 
        printf("RESULT: result size is %ld\n",
	(long)nfs_result->GETATTR3res_u.resok.obj_attributes.size); 
	printf("RESULT: result used is %ld\n",
	(long)nfs_result->GETATTR3res_u.resok.obj_attributes.used); 
	printf("RESULT: result fileid is %ld\n",
	(long)nfs_result->GETATTR3res_u.resok.obj_attributes.fileid); 
	printf("RESULT: result atime (in seconds) is %ld\n",
        (long)nfs_result->GETATTR3res_u.resok.obj_attributes.atime.seconds); 
	printf("RESULT: result mtime (in seconds) is %ld\n",
        (long)nfs_result->GETATTR3res_u.resok.obj_attributes.mtime.seconds); 
     }
     else {
     printf("GETATTR ERROR is %d\n",nfs_result->status); 
     }
}

// ACCESS call.

/*
 * ACCESS call
 * pre: check access permission.
 * post: status 
 *
 */
	
void access_call (LOOKUP3res *lookres, CLIENT *clt) {
	ACCESS3args  		acargs;
	ACCESS3res		*acres;
	int			iterate;
	struct  timeval		start1;
	struct  timeval		end1;


        acres = (ACCESS3res *) malloc (sizeof(struct ACCESS3res));
		

        acargs.object.data.data_val =
	      (char *) malloc (sizeof(char)*MAX_SIZE);
	acargs.object.data.data_len =
		lookres->LOOKUP3res_u.ok.object.data.data_len;
	
  	for (iterate = 0; iterate < MAX_SIZE; iterate++) {
  	acargs.object.data.data_val[iterate] =
	       lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }
	acargs.access = 0x0001;
        // printf("before access call\n");

        // printf("start is %d\n", (int) start1.tv_usec);
        acres = nfsproc3_access_3 (&acargs, clt);
  
	if (acres == NULL) {
        clnt_perror(clt, "ACCESS call failed:");
	exit(-1);
	}	
	if (acres->status == NFS3_OK) {
  		printf("NFS: ACCESS call success\n");
  	} 
}

// READLINK call.
/*
 * readlink :
 *	pre  : symbolic path to be read.
 *      post : return status after symbolic link is read.   
 */

void readlink_call (LOOKUP3res *lookres, CLIENT *clt) {
	READLINK3args	rdlinkargs;
	READLINK3res	*rdlinkres;
	int		iterate;
	struct  	timeval	start1;
	struct  	timeval	end1;

	// printf("entered readlink call\n");

	rdlinkres = (READLINK3res *) malloc(sizeof(READLINK3res));

        rdlinkargs.symlink.data.data_val =
	      (char *) malloc (sizeof(char)*HALF_SIZE);

	rdlinkargs.symlink.data.data_len =
		lookres->LOOKUP3res_u.ok.object.data.data_len;

	/* printf( "rdlink length	is %d\n", 
			rdlinkargs.symlink.data.data_len); */

	for (iterate = 0; iterate < HALF_SIZE; iterate++ ) {
        rdlinkargs.symlink.data.data_val[iterate] =
           lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	rdlinkres = nfsproc3_readlink_3 (&rdlinkargs, clt);

	if(rdlinkres == NULL) {
             clnt_perror(clt, "READLINK call failed:");
	     exit(-1);
	}        
			
	if(rdlinkres->status == NFS3_OK){
        printf("READLINK status is %d\n", rdlinkres->status);
	}else {
        printf("READLINK error is %d\n", rdlinkres->status);
	} 
}

// READ call.
/*
 * READ :
 * pre  : a file handle 
 * post : data read from the file corresponding to the file handle.
 *
 */

void read_call (LOOKUP3res *lookres, CLIENT *clt) {
	READ3args	rdargs;
	READ3res	*rdres;
	int		iterate;
	struct  	timeval	start2;
	struct  	timeval	end2;

	// printf("Entered READ client side\n");	
	rdres = (struct READ3res *) malloc (sizeof(struct READ3res));
	
	rdargs.file.data.data_val =
		(char *) malloc (sizeof(char)*MAX_SIZE);
	rdargs.file.data.data_len =
		lookres->LOOKUP3res_u.ok.object.data.data_len;
	
	for (iterate = 0; iterate < MAX_SIZE; iterate++) {
	rdargs.file.data.data_val[iterate] =
		lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];	
	}		

      	rdargs.offset = 0;
	rdargs.count = 40;
	// printf("before read call\n");

        // printf("start is %d\n", (int) start2.tv_usec);
	rdres = nfsproc3_read_3 (&rdargs, clt);
		
	if(rdres == NULL) {
             clnt_perror(clt, "READ failed:");
	     exit(-1);
	}        
	// printf("after read call\n");
	if(rdres->status == NFS3_OK ) {
	printf("NFS : read success\n");	

	printf("data is %s\n", rdres->res_u.ok.data.data_val);
	printf("data is %d\n", rdres->res_u.ok.data.data_len);
	} 
}

// WRITE call.

/*
 * write call :
 * 	pre  : file handle, data to be  written. 
 *	post : return status after data is written.
 */

void write_call (LOOKUP3res *lookres, CLIENT *clt) {
	WRITE3args	writeargs;
	WRITE3res	*writeres;
	char test[100] 	= "hello write to try test\0";
	int		iterate;
	
	struct  	timeval	start2;
	struct  	timeval	end2;
	
	writeres = (WRITE3res *) malloc (sizeof(WRITE3res)*CHAR_SIZE);
	
	writeargs.data.data_val	 = 
			(char *) malloc (sizeof(char)*MAX_DATA);
	writeargs.file.data.data_val =
		(char *) malloc (sizeof(char)*MAX_SIZE);
	writeargs.file.data.data_len =
		lookres->LOOKUP3res_u.ok.object.data.data_len;
	for (iterate = 0; iterate < MAX_SIZE; iterate++) {
	writeargs.file.data.data_val[iterate] =
		lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
	}
	strcpy (writeargs.data.data_val, test);
	writeargs.offset = 0;
	writeargs.count = 20;
	writeargs.data.data_len = 20;
	writeargs.stable = DATA_SYNC;

	// printf("before write call\n");

        writeres = nfsproc3_write_3 (&writeargs, clt);     	
	
	if(writeres == NULL) {
             clnt_perror(clt, "WRITE failed:");
	     exit(-1);
	}        
	if (writeres->status == NFS3_OK) {
	printf("NFS write: success\n");	
	} 	
}

// CREATE call.
/*
 * create call :
 *		pre  : 
 *		directory file handle with name of file to be created. 
 *		post : return status after successful creation of file.
 */

void create_call (LOOKUP3res *lookres, CLIENT *clt) {
	CREATE3args	createargs;
	CREATE3res	*createres;
	int		iterate;
	struct  	timeval	start2;
	struct  	timeval	end2;
	
	createargs.where.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
        createres = 
	(struct CREATE3res  *) malloc (sizeof(struct CREATE3res));

	createargs.where.name = 
	(char *) malloc (sizeof(char)*CHAR_SIZE);
	
	// printf("entered create\n");	
        createargs.where.dir.data.data_len =
        lookres->LOOKUP3res_u.ok.object.data.data_len;
	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        createargs.where.dir.data.data_val[iterate] =
        lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	// printf("create : after iterate\n");
	createargs.where.name = "new2";
	// printf("after name\n");
	
        if(gettimeofday(&end2, (struct timezone *) 0) < 0)
        printf("getttimeofday : error\n");
        // printf("end is %d\n", (int) end2.tv_sec);
        // printf("end is %d\n", (int) end2.tv_usec);
        // printf("ELAPSED time is %ld\n", (long)end2.tv_usec-start2.tv_usec);
	// printf("after call \n");	
	
	if (createres->status == NFS3_OK ) {
        // printf("CREATE status: is %d\n", createres->status);
        }
	else {
        // printf("CREATE error status: is %d\n", createres->status);
	}
}

// MKDIR call.

/*
 * mkdir call :
 *	pre  : sub-directory to be created. 
 *      post : return status after successful sub-directory creation.
 */

void mkdir_call (LOOKUP3res *lookres, CLIENT *clt) {
	MKDIR3args	mkdargs;
	MKDIR3res	*mkdirres;
	int		iterate;
	
	struct  	timeval	start2;
	struct  	timeval	end2;
	
	mkdargs.where.dir.data.data_val =
                (char *) malloc (sizeof(char)*HALF_SIZE);
        mkdirres = (MKDIR3res  *) malloc (sizeof(MKDIR3res )*CHAR_SIZE);

   
        mkdargs.where.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;
	for (iterate = 0; iterate < HALF_SIZE; iterate++ ) {
        mkdargs.where.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	mkdargs.where.name = "temp";
	
    	mkdirres = nfsproc3_mkdir_3 (&mkdargs, clt);

	if (mkdirres == NULL) {
             clnt_perror(clt, "MKDIR failed:");
	     exit(-1);
	}	
	if (mkdirres->status == NFS3_OK ) {
        printf("MKDIR status: is %d\n", mkdirres->status);
        }
	else {
        printf("MKDIR error status: is %d\n", mkdirres->status);
	}
}


// SYMLINK call.

/*
 * symlink call :
 *      pre  : path to be created.
 *      post : return status after successful creation
 *              of the symbolic creation.
 */
  
void symlink_call (LOOKUP3res *lookres, CLIENT *clt) {
        SYMLINK3args    symlinkargs;
        SYMLINK3res     *symlinkres;
	int		iterate;
	struct  timeval	start1;
	struct  timeval	end1;
        
	symlinkargs.where.name = (char *) malloc(sizeof(char)*CHAR_SIZE);
        symlinkres = (SYMLINK3res *) malloc (sizeof(struct SYMLINK3res));

        symlinkargs.where.dir.data.data_val =
                                (char *) malloc (sizeof(char)*MAX_SIZE);
        symlinkargs.symlink.symlink_data =
                                (char *) malloc (sizeof(char)*MAX_DATA);
	
  	// printf("SYMLINK: inside symlink\n");

	symlinkargs.where.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;
        for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
           symlinkargs.where.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }
	symlinkargs.where.name = "sym\0";
        strcpy (symlinkargs.symlink.symlink_data , "test\0");
	 
	// printf("before call\n");

	symlinkres = nfsproc3_symlink_3 (&symlinkargs, clt);

	if (symlinkres == NULL) {
             clnt_perror(clt, "SYMLINK failed:");
	     exit(-1);
	}	
	if(symlinkres->status == NFS3_OK) {
        printf("SYMLINK : status is %d\n", symlinkres->status);
        } else {
        printf("SYMLINK ERROR : status is %d\n", symlinkres->status);
        }
}


// MKNOD call.

/*
 * mknod call :
 *		pre  : file to create.
 *		post : return status after successful 
 *		       creation of special file.
 */

void mknod_call (LOOKUP3res *lookres, CLIENT *clt) {
	MKNOD3args	mknodargs;
	MKNOD3res	*mknodres;
	int		iterate;
	struct  timeval	start1;
	struct  timeval	end1;
  	
	mknodres= (MKNOD3res *) malloc (sizeof(MKNOD3res));
  	mknodargs.where.name = (char *) malloc (sizeof(char) *CHAR_SIZE);
  	mknodargs.where.dir.data.data_val =  
                        (char *) malloc (sizeof(char)*MAX_SIZE); 
    

	mknodargs.where.dir.data.data_len =
                        lookres->LOOKUP3res_u.ok.object.data.data_len;
  	for (iterate = 0; iterate < MAX_SIZE; iterate++) {
   	mknodargs.where.dir.data.data_val[iterate] =
        	lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
  	}
  	mknodargs.where.dir = lookres->LOOKUP3res_u.ok.object;
  	mknodargs.where.name = "mysock";
  	mknodargs.what.type = NF3SOCK;

 	mknodres= nfsproc3_mknod_3 (&mknodargs, clt);

	if (mknodres == NULL) {
             clnt_perror(clt, "MKNOD failed:");
	     exit(-1);
	}	
	if (mknodres->status == NFS3_OK)
        	printf("MKNOD: status is %d\n", mknodres->status);
  	else {
        	printf("MKNOD ERROR : status is %d\n", mknodres->status);
  	}
}
 
// REMOVE call.

/*
 * remove call :
 *      pre  : file to be removed in a particular directory. 
 *	post : retrun status after successful removal of file.
 */

void remove_call (LOOKUP3res *lookres, CLIENT *clt) {
	REMOVE3args	removeargs;
	REMOVE3res	*removeres;
	int		iterate;
	struct  timeval	start1;
	struct  timeval	end1;

	removeargs.object.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
        removeres = 
		(REMOVE3res  *) malloc (sizeof(struct REMOVE3res ));

        removeargs.object.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;
	
	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        removeargs.object.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	removeargs.object.name = "new";
    	removeres = nfsproc3_remove_3 (&removeargs, clt);

	if (removeres == NULL) {
             clnt_perror(clt, "REMOVE failed:");
	     exit(-1);
	}
	// printf("remove: after remove\n");	
	if (removeres->status == NFS3_OK ) {
          printf("REMOVE status: is %d\n", removeres->status);
        }
	else {
          printf("REMOVE error status: is %d\n", removeres->status);
	}
}


// RMDIR call.

/*
 * rmdir call :
 *  	 pre  : remove a particular directory.
 *	 post : return status after successful removal of sub-directory.
 */

void rmdir_call (LOOKUP3res *lookres, CLIENT *clt) {
	RMDIR3args	rmdirargs;
	RMDIR3res	*rmdirres;
	int		iterate;
	struct  timeval	start1;
	struct  timeval	end1;
        
	rmdirres = (RMDIR3res  *) malloc (sizeof(struct RMDIR3res ));

	rmdirargs.object.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
	
	rmdirargs.object.name = (char *) malloc(sizeof(char)*CHAR_SIZE);
	
	rmdirargs.object.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;

	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        rmdirargs.object.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }
	
	// printf("before rmdir call alloc dir\n");
	rmdirargs.object.name = "try2";

    	rmdirres = nfsproc3_rmdir_3 (&rmdirargs, clt);

	if (rmdirres == NULL) {
             clnt_perror(clt, "RMDIR failed:");
	     exit(-1);
	}	
	// printf("rmdir : after call\n");	
	if (rmdirres->status == NFS3_OK ) {
                printf("RMDIR status: is %d\n", rmdirres->status);
        }
	else {
                printf("RMDIR error status: is %d\n", rmdirres->status);
	}

}

// RENAME call.

/*
 * rename call :
 *		pre  :  rename file names and directory file-handle. 
 *		post :  return status after successful renaming of file.
 */

void rename_call (LOOKUP3res *lookres, CLIENT *clt) {
	RENAME3args	renameargs;
	RENAME3res	*renameres;
	int		iterate;
	struct  	timeval	start1;
	struct  	timeval	end1;
	
	// printf("entered rename_call\n");
	renameres = 
		(RENAME3res *) malloc (sizeof(RENAME3res));
	
	renameargs.from.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);

	renameargs.to.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
        
	renameargs.from.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;
		
        renameargs.to.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;

	/* printf("len is %d\n", 
			lookres->LOOKUP3res_u.ok.object.data.data_len); */

	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        renameargs.to.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        renameargs.from.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }
	
	// printf("before entered rename\n");
	renameargs.from.name = "new";
	renameargs.to.name = "new2";

	// printf("after name alloc\n");	
    	renameres = nfsproc3_rename_3 (&renameargs, clt);


	if(renameres == NULL) {
             clnt_perror(clt, "RENAME failed:");
	     exit(-1);
	}	
	if (renameres->status == NFS3_OK ) {
            printf("RENAME status: is %d\n", renameres->status);
        }
	else {
            printf("RENAME error status: is %d\n", renameres->status);
	}
}


// LINK call.
/*
 * link call:
 *	pre  : hard link path. 
 *      post : return status after hard link creation.
 */

void link_call (LOOKUP3args lookuparg, LOOKUP3res *lookres ,CLIENT *clt) {
	LINK3args	linkargs;
	LINK3res	*linkres;
	int		iterate;
	struct  timeval	start1;
	struct  timeval	end1;
	
	// printf("entered link_call\n");
	
	linkres = (LINK3res *) malloc (sizeof(LINK3res));

	
	linkargs.file.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);

	linkargs.link.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
	
	linkargs.link.name =
		(char *) malloc (sizeof(char)*CHAR_SIZE);
	
	linkargs.file.data.data_len =
		lookuparg.what.dir.data.data_len;

	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        linkargs.file.data.data_val[iterate] =
                lookuparg.what.dir.data.data_val[iterate];
        }

	linkargs.link.dir.data.data_len =
		lookres->LOOKUP3res_u.ok.object.data.data_len;

	for (iterate = 0; iterate < MAX_SIZE; iterate++ ) {
        linkargs.link.dir.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }
	
	strcpy (linkargs.link.name, "hard");
	// printf("before call\n");
        linkres = nfsproc3_link_3 (&linkargs, clt);
	// printf("link : after call\n");

	if (linkres == NULL) {
             clnt_perror(clt, "LINK failed:");
	     exit(-1);
	}	
	if (linkres->status == NFS3_OK) {
        printf("LINK success:  status is %d\n", linkres->status);
        }
        else {
        printf("LINK ERROR is %d\n", linkres->status);
        }
}

// READDIR call.

/*
 * readdir call :
 *		pre  : directory to be read.
 *		post : return status after 
 *		successful read of directory entries.
 */

void readdir_call (LOOKUP3res *lookres, CLIENT *clt) {
	READDIR3args	readdirargs;
	READDIR3res	*readdirres;
	int		iterate;
	struct  	timeval	start1;
	struct  	timeval	end1;


	readdirres = (READDIR3res *) malloc (sizeof(READDIR3res));

   
	// printf("readdir call \n");     	
	
	readdirargs.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
	readdirargs.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;
	
	for (iterate = 0; iterate < 
	lookres->LOOKUP3res_u.ok.object.data.data_len; iterate++) { 
		
        readdirargs.dir.data.data_val[iterate] =
           lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	// READDIR call.
	readdirargs.cookie = 0;
	// strcpy (readdirargs.cookieverf, "0");
	// readdirargs.count = 81920;

        // printf("start is %d\n", (int) start1.tv_usec);
    	readdirres = nfsproc3_readdir_3 (&readdirargs, clt);
	
	if (readdirres == NULL) {
             clnt_perror(clt, "READDIR failed:");
	     exit(-1);
	}

	if (readdirres->status == NFS3_OK ) {
           printf("READDIR status: is %d\n",readdirres->status);
	     while(readdirres->res_u.ok.reply.entries !=
                NULL){
                printf(" RESULT: Directory entries (fileid) are %ld\n",
                (long) readdirres->res_u.ok.reply.entries->fileid);
                printf(" RESULT: Directory entries are (name) %s\n",
                readdirres->res_u.ok.reply.entries->name);
                printf(" RESULT: Directory entries(cookie) are %ld\n",
                (long) readdirres->res_u.ok.reply.entries->cookie);
                readdirres->res_u.ok.reply.entries =
                readdirres->res_u.ok.reply.entries->nextentry;
                }
        }
	else {
        printf("READDIR error status: is %d\n",readdirres->status);
	}
	// printf("end of READDIR\n");
}

// READDIRPLUS call.

/*
 * readdirplus call :
 * 		pre  : directory to be read. 
 * 		post : return status after successful 
 *		read of directory entries 
 *		with file handles.
 */

void readdirplus_call (LOOKUP3res *lookres, CLIENT *clt) {
	READDIRPLUS3args	rdplusargs;
	READDIRPLUS3res		*rdplusres;	
	int			iterate;
	struct 			timeval start1;
	struct 			timeval	end1;

	rdplusres = 
		(READDIRPLUS3res *) malloc (sizeof(READDIRPLUS3res));
	
	rdplusargs.dir.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
	rdplusargs.dir.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;

	for (iterate = 0; iterate < 
	MAX_SIZE; iterate++ ) {
        rdplusargs.dir.data.data_val[iterate] =
           lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

	
	// printf("RDPLUS call\n");	
	rdplusargs.cookie = 0;
	// strcpy (rdplusargs.cookieverf, "0");
	// rdplusargs.dircount = 1024;
	// rdplusargs.maxcount = 8192;

        // printf("start is %d\n", (int) start1.tv_usec);
    	rdplusres = nfsproc3_readdirplus_3 (&rdplusargs, clt);

	if (rdplusres == NULL) {
             clnt_perror(clt, "READDIRPLUS failed:");
	     exit(-1);
	}
	if (rdplusres->status == NFS3_OK ) {
           printf("READDIRPLUS status: is %d\n",rdplusres->status);
	
            while(rdplusres->res_u.ok.reply.entries
             != NULL) {
             printf("RESULT: Fileid value is %ld\n",
             (long) rdplusres->res_u.ok.reply.entries->fileid);
             printf(" RESULT: Directory entries are %s\n",
             rdplusres->res_u.ok.reply.entries->name);
             printf(" RESULT: Directory entries are %ld\n",
             (long) rdplusres->res_u.ok.reply.entries->cookie);
             printf("RESULT: Handle entries are %ld\n",
           (long) rdplusres->res_u.ok.reply.entries->name_handle.handle.data.data_val);
             rdplusres->res_u.ok.reply.entries =
             rdplusres->res_u.ok.reply.entries->nextentry;
           }
      }
	else {
        printf("READDIRPLUS error status: is %d\n",rdplusres->status);
	}
}

// FSSTAT call.

/*
 * fsstat call :
 *
 * 	post : return status with file system information.
 */

void fsstat_call (LOOKUP3res *lookres, CLIENT *clt) {
	FSSTAT3args	fsstatargs;
	FSSTAT3res	*fsstatres;
	int		iterate;
	struct  	timeval	start1;
	struct  	timeval	end1;


	// printf("entered fsstat_call\n");

	fsstatres = (FSSTAT3res *) malloc (sizeof(FSSTAT3res ));
		
	fsstatargs.fsroot.data.data_val =
                (char *) malloc (sizeof(char)*HALF_SIZE);
	fsstatargs.fsroot.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;

	for (iterate = 0; iterate < HALF_SIZE; iterate++ ) {
        fsstatargs.fsroot.data.data_val[iterate] =
           lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }


        // printf("start is %d\n", (int) start1.tv_usec);
    	fsstatres = nfsproc3_fsstat_3 (&fsstatargs, clt);

	if (fsstatres == NULL) {
             clnt_perror(clt, "FSSTAT failed:");
	     exit(-1);
	}

	if (fsstatres->status == NFS3_OK ) {
               printf("FSSTAT status: is %d\n", fsstatres->status);
        }
	else {
        printf("FSSTAT error status: is %d\n", fsstatres->status);
	}
}


// FSINFO call.

/*
 * fsinfo call :
 * 	pre : 
 */

void fsinfo_call (LOOKUP3res *lookres, CLIENT *clt) {
	FSINFO3args	fsinfoargs;
	FSINFO3res	*fsinfores;
	int		iterate;
	struct  	timeval	start1;
	struct  	timeval	end1;
	
	// printf("entered fsinfo_call\n");

	fsinfores = (FSINFO3res *) malloc (sizeof(FSINFO3res ));

	fsinfoargs.fsroot.data.data_val =
                (char *) malloc (sizeof(char)*HALF_SIZE);

	fsinfoargs.fsroot.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;

	for (iterate = 0; iterate < HALF_SIZE; iterate++ ) {
        fsinfoargs.fsroot.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

        // printf("start is %d\n", (int) start1.tv_usec);
    	fsinfores = nfsproc3_fsinfo_3 (&fsinfoargs, clt);

	if (fsinfores == NULL) {
             clnt_perror(clt, "FSINFO failed:");
	     exit(-1);
	}


	if (fsinfores->status == NFS3_OK ) {
        printf("FSINFO status: is %d\n", fsinfores->status);
        }
	else {
        printf("FSINFO error status: is %d\n", fsinfores->status);
	}
}

// PATHCONF call.

/*
 *  pathconf call :
 *		pre : 
 *		post : return status with the POSIX information.
 */

void pathconf_call (LOOKUP3res *lookres, CLIENT *clt) {
	PATHCONF3args	pathconfargs;
	PATHCONF3res	*pathconfres;
	int		iterate;
	struct  	timeval	start1;
	struct  	timeval	end1;
	

	// printf("entered pathconf_call\n");

	pathconfres = (PATHCONF3res *) malloc (sizeof(PATHCONF3res ));
		
	pathconfargs.object.data.data_val =
                (char *) malloc (sizeof(char)*HALF_SIZE);

	pathconfargs.object.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;

	
	for (iterate = 0; iterate < HALF_SIZE; iterate++ ) {
        pathconfargs.object.data.data_val[iterate] =
                lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
        }

        // printf("start is %d\n", (int) start1.tv_usec);
    	pathconfres = nfsproc3_pathconf_3 (&pathconfargs, clt);

	if (pathconfres == NULL) {
             clnt_perror(clt, "PATHCONF failed:");
	     exit(-1);
	}
	
	if (pathconfres->status == NFS3_OK ) {
        printf("PATHCONF status: is %d\n", pathconfres->status);
        }
	else {
        printf("PATHCONF error status: is %d\n", pathconfres->status);
        }
}

// COMMIT call.

/*
 * commit call :	
 * 		pre : file to be commited.
 *		post : return  status after successful  a commit.
 */ 

void commit_call (LOOKUP3res *lookres, CLIENT *clt) {
	COMMIT3args	commitargs;
	COMMIT3res	*commitres;
	struct  	timeval	start1;
	struct  	timeval	end1;

	// printf("entered commit_call\n");

	commitres = (COMMIT3res *) malloc (sizeof(COMMIT3res ));
	commitargs.file.data.data_val =
                (char *) malloc (sizeof(char)*MAX_SIZE);
	commitargs.file.data.data_len =
                lookres->LOOKUP3res_u.ok.object.data.data_len;
        
       
        // printf("start is %d\n", (int) start1.tv_usec);
    	commitres = nfsproc3_commit_3 (&commitargs, clt);

	if (commitres == NULL) {
             clnt_perror(clt, "COMMIT failed:");
	     exit(-1);
	}	

	if (commitres->status == NFS3_OK ) {
        printf("COMMIT status: is %d\n", commitres->status);
        }
	else {
        printf("COMMIT error status: is %d\n", commitres->status);
        }
}


/* 
 * SETATTR call: 
 * 		pre : a file handle with a new set of attributes.
 * 		post : a status.
 */ 
  
void setattr_call (LOOKUP3res *lookres, CLIENT *clt) {
  SETATTR3args 		setargs;
  SETATTR3res		*setres;
  int 			iterate;
  struct timeval	start1;
  struct timeval	end1;		


  // printf("entered setattr call\n");

  setres = (SETATTR3res *) malloc (sizeof(struct SETATTR3res));
  
  setargs.object.data.data_val =
	(char *) malloc (sizeof(char)*MAX_SIZE);

  setargs.object.data.data_len = 
		lookres->LOOKUP3res_u.ok.object.data.data_len;

  for (iterate = 0; iterate < MAX_SIZE; iterate++) {
  setargs.object.data.data_val[iterate] =
	lookres->LOOKUP3res_u.ok.object.data.data_val[iterate];
  } 

  setargs.new_attributes.mode.set_it = FALSE;
  setargs.new_attributes.uid.set_it = FALSE;
  setargs.new_attributes.gid.set_it = FALSE;
  setargs.new_attributes.size.set_it = FALSE;
  setargs.new_attributes.atime.set_it = DONT_CHANGE;
  setargs.new_attributes.mtime.set_it = DONT_CHANGE;  

  // printf("before setattr call\n");
  
  // printf("start is %d\n", (int) start1.tv_usec);
  setres = nfsproc3_setattr_3 (&setargs, clt);
 
  if (setres == NULL) {
             clnt_perror(clt, "SETATTR failed:");
	     exit(-1);
  } 
  if (setres->status == NFS3_OK) {
  printf("NFS: setattr call success\n");
  } 
}

/*
 * LOOKUP call 
 * 		pre: a file handle and a name to lookup.
 * 		post : status with a file handle corresponding 
 *		to the name,
 *	  	else a error status.
 */
void lookup_call (LOOKUP3args lookuparg, LOOKUP3args 
				lookuparg2, CLIENT *clt) {
	static LOOKUP3res	*lookres, *lookres1;
	struct timeval		start1;
        struct timeval		end1;
	int			choice, choice1;
	
	lookres = 
	(LOOKUP3res *) malloc (sizeof(struct LOOKUP3res));

	lookres1 = 
	(LOOKUP3res *) malloc (sizeof(struct LOOKUP3res));

	// printf("before lookup call\n");
 
	// printf("lookuparg is %s\n", lookuparg.what.name);	
	lookres = nfsproc3_lookup_3 (&lookuparg, clt);
	
	if(lookres == NULL) {
             clnt_perror(clt, "LOOKUP call failed:");
	     printf("lookup failed\n");
	     exit(-1);
	}        

		
	if (lookres->status == NFS3_OK) {
	printf("NFS lookup : success\n");
	printf("file handle obtained is 0%p\n", 
		lookres->LOOKUP3res_u.ok.object.data.data_val);
	
	printf("file handle length is %d\n", 
		lookres->LOOKUP3res_u.ok.object.data.data_len);
	printf("post_op_attr obj attributes\n");
	if (lookres->LOOKUP3res_u.ok.obj_attributes.attributes == 1){
        printf(" type is %d\n", 
	lookres->LOOKUP3res_u.ok.obj_attributes.attr.type);
        printf("RESULT: result mode is %ld\n", (long)	
		lookres->LOOKUP3res_u.ok.obj_attributes.attr.mode);
        printf("RESULT: result nlink is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.nlink); 
        printf("RESULT: result uid is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.uid); 
        printf("RESULT: result gid is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.gid); 
        printf("RESULT: result size is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.size); 
	printf("RESULT: result used is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.used); 
	printf("RESULT: result fileid is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.fileid); 
	printf("RESULT: result atime (in seconds) is %ld\n",
        (long)lookres->LOOKUP3res_u.ok.obj_attributes.attr.atime.seconds); 

	 }	
	// dir_attributes.

	if (lookres->LOOKUP3res_u.ok.dir_attributes.attributes == 1) {	
        printf(" type is %d\n", 
        lookres->LOOKUP3res_u.ok.dir_attributes.attr.type);
        printf("RESULT: result mode is %ld\n", (long)	
		lookres->LOOKUP3res_u.ok.dir_attributes.attr.mode);
        printf("RESULT: result nlink is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.nlink); 
        printf("RESULT: result uid is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.uid); 
        printf("RESULT: result gid is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.gid); 
        printf("RESULT: result size is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.size); 
	printf("RESULT: result used is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.used); 
	printf("RESULT: result fileid is %ld\n",
	(long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.fileid); 
	printf("RESULT: result atime (in seconds) is %ld\n",
       (long)lookres->LOOKUP3res_u.ok.dir_attributes.attr.atime.seconds); 
	}
	} else {
	printf("nfslookup status is %d\n", lookres->status);	
	} 

	if(lookres->status == NFS3_OK) {
	printf("NFS call menu\n");
	printf("1. Access call\n");
	printf("2. Readdir call\n");
	printf("3. Readdirplus call\n");
	printf("4. Readlink call\n");
	printf("5. Create call\n");
	printf("6. Rename call\n");
	printf("7. Quit\n");
	scanf("%d", &choice);

	switch (choice) {
	
	case 1:
		// ACCESS call.
	   	// printf("access call\n");
		access_call (lookres, clt);
        break;
	
	case 2:	
		// readdir call.
		// printf("readdir call\n");
		readdir_call (lookres, clt);
        break;

	case 3:	
		// readdirplus call.
		// printf("readdirplus call\n");
		readdirplus_call (lookres, clt);
        break;
	
	case 4:
		// readlink call.
		// printf("readlink call\n");
		readlink_call (lookres, clt);
        break;
	
	case 5:	
		// create call.
		// printf("create call\n");	
  		create_call (lookres, clt);
	break;
	case 6:
		// rename call.
		// printf("rename call\n");	
		rename_call (lookres, clt);
	break;
	case 7:
		// quit
		exit(0);
	break;
        }

		
	// second lookup.
	// printf("lookup2 is starting\n");

	lookres1 = nfsproc3_lookup_3 (&lookuparg2, clt);

	if (lookres1 == NULL) {
        clnt_perror(clt, "LOOKUP call failed:");
 	printf("lookup failed\n");
        exit(-1);
	}	
	printf("lookup status is %d\n", lookres1->status);
	printf("file handle len is obtained is %d\n", 
		lookres1->LOOKUP3res_u.ok.object.data.data_len);
	
	printf("file handle obtained is 0%x\n", 
		lookres1->LOOKUP3res_u.ok.object.data.data_val); 

	printf("please enter your choice\n");
	printf("1.  Read call.\n");
	printf("2.  Setattr call.\n");
	printf("3.  Write call.\n");
	printf("4.  Commit call.\n");
	printf("5.  Mkdir call.\n");
	printf("6.  Remove call.\n");
	printf("7.  Rmdir call.\n");
	printf("8.  Symlink call.\n");
	printf("9.  Pathconf call.\n");
	printf("10. Fsstat call.\n");
	printf("11. Fsinfo call.\n");
	printf("12. Mknod call.\n");
	printf("13. Link call.\n");	
	printf("14. Quit\n");
	scanf("%d", &choice1);
	
	switch (choice1) {
	
	case 1:
		// READ
		// printf("read call\n");
        	read_call (lookres, clt);	
	break;
	
	case 2:	
		// SETATTR call.
		// printf("setattr call\n");
		setattr_call (lookres, clt);
	break;

	case 3:	
		// WRITE call
	   	// printf("write call\n");
		write_call (lookres, clt);
        break;
	
	case 4:	
		// commit call.
		// printf("commit call\n");
		commit_call (lookres, clt);
	break;

	case 5:	
		// MKDIR call
		// printf("mkdir call\n");
		mkdir_call (lookres, clt);
        break;
	
	case 6:	
		// remove call.
		// printf("remove call\n");
		remove_call (lookres, clt);
	break;
	
	case 7:
		// rmdir call
		// printf("rmdir call\n");
		rmdir_call (lookres, clt);
	break;
	
	case 8:
		// symlink call.
		// printf("symlink call\n");
		symlink_call (lookres, clt);	
	break;

	case 9:
		// pathconf call.
		// printf("pathconf call\n");
		pathconf_call (lookres, clt);
	break;
	
	case 10:
		// fsstat call
		// printf("fsstat call\n");
		fsstat_call (lookres, clt);
	break;
 
	case 11:
		// fsinfo call
		// printf("fsinfo call\n");
		fsinfo_call (lookres, clt);
	break;
	
	case 12:
		// mknod call
		// printf("mknod call\n");
		mknod_call (lookres, clt);
	break;
	
	case 13:
		// link call
		link_call (lookuparg, lookres1, clt);
	break;
	
	case 14:
		exit (0);
	break;
	}
     }
}

/*
 * NFS program to test the the NFS protocol.
 */
void nfs_program_3(char* host , mountres3 *fh_r, char *trans) {
        CLIENT 			*clnt;
	CLIENT 			*clnt1;
	struct rpc_err  	*errp;
        static GETATTR3args 	nfsproc3_getattr_3_arg;
	char 			*nfsproc3_null_3_arg;
        int 			iter;
	struct timeval 		start1, end1, start2, end2;
	struct timeval 		start3, end3;
	static LOOKUP3args 	lookuparg, lookuparg2;
	int			option;	
		
	nfsproc3_getattr_3_arg.object.data.data_val =
		(char *)malloc(sizeof(char)*MAX_SIZE);

	lookuparg.what.dir.data.data_val =
		(char *) malloc (sizeof(char)*MAX_SIZE);
	lookuparg.what.name = (char *) malloc (sizeof(char)*CHAR_SIZE);


	lookuparg2.what.dir.data.data_val =
		(char *) malloc (sizeof(char)*MAX_SIZE);
	lookuparg2.what.name = (char *) malloc (sizeof(char)*CHAR_SIZE);
	
	errp = (struct rpc_err *) malloc (sizeof (struct rpc_err));

	// printf("NFS: entered nfs_program\n");		        
        /* Client Connection */
	// printf("host is %s\n", host);
	// printf("trans is %s\n", trans);

       	clnt = clnt_create(host, NFS_PROGRAM, NFS_V3, trans);
	// (AUTH *) clnt->cl_auth = authunix_create_default();

  	clnt_pcreateerror (host);
	if (clnt == NULL)
		exit (-1);
	 
	(AUTH *) clnt->cl_auth = authunix_create_default();
        if (clnt == NULL) {
                clnt_pcreateerror(host);
                exit(0);
        }
	
        clnt1 = clnt_create(host, NFS_PROGRAM, NFS_V3, trans);
        if (clnt1 == NULL) {
                clnt_pcreateerror(host);
                exit(0);
        }


	// printf("before assignments\n");		
	nfsproc3_getattr_3_arg.object.data.data_len = 
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_len;

	printf("mhfi %d\n", 
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_len);
	

	lookuparg.what.dir.data.data_len = 
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_len;
	
	lookuparg2.what.dir.data.data_len = 
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_len;
	
	for (iter = 0; iter < MAX_SIZE ; iter++) {
	nfsproc3_getattr_3_arg.object.data.data_val[iter] =
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_val[iter];

	lookuparg.what.dir.data.data_val[iter] = 
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_val[iter];
	
	lookuparg2.what.dir.data.data_val[iter] = 
		fh_r->mountres3_u.mountinfo.fhandle.fhandle3_val[iter];
	}
	printf("NFS call menu\n");
	printf("1. Null Call\n");
	printf("2. Getattr Call\n");
	printf("3. Lookup Call\n");
	printf("4. Quit\n");
 	printf("Please enter your option\n");
	scanf("%d", &option);
	switch(option) {

	case 1:
		
         	null_call(nfsproc3_null_3_arg, clnt);
	break;

	case 2:
		
        	get_attr(nfsproc3_getattr_3_arg, clnt);
	break;		 
	
	case 3:
	
		// LOOKUP
		// printf("nfs: before  lookup call\n");
		strcpy(lookuparg.what.name,"new");
		strcpy (lookuparg2.what.name,"new3.c");
	 	lookup_call (lookuparg, lookuparg2, clnt);
	break;
	
	case 4:
		exit (0);
	break;
	}

        clnt_destroy( clnt );
}

/*
 * MOUNT program to test the Mount protocol.
 */

mountres3 *
mount_program_3( char* host , char *dirp, char *transp )
{
        CLIENT 		*clnt;
        void  		*result_1;
        char		*mountproc3_null_3_arg;
        mountres3  	*result_2;
        dirpath  	mountproc3_mnt_3_arg;
        // mountbody resmount;
	mountbody 	*resmountptr;
        mountlist 	*result_3; 
        char 		*mountproc3_dump_3_arg;
	// int loop;	
	// mountlist cur; 
        void 		*result_4;
        dirpath 	mountproc3_umnt_3_arg; 
     	// char * mountproc3_umntall_3_arg;
	struct	timeval start1, start2, start3, start4;
	struct  timeval end1, end2, end3, end4;
	int 		choice;
 
        result_2 = (mountres3 *)malloc( sizeof(mountres3));
	resmountptr = (mountbody *) malloc (sizeof(mountbody));
	mountproc3_umnt_3_arg = (char *) malloc (sizeof (char ) * 10);
	
        strcpy (mountproc3_umnt_3_arg, "/tmp");
	
 	result_3 = &resmountptr;
	
	((mountbody *)*result_3)->ml_hostname = 
			(char *) malloc (sizeof( char) *20);

        mountproc3_mnt_3_arg = dirp; 
        // printf("after mountproc arg\n");
        clnt = clnt_create(host, MOUNT_PROGRAM, MOUNT_V3, transp);
        if (clnt == NULL) {
                clnt_pcreateerror(host);
                exit(1);   
        }
      
	printf("Menu for the Mount client\n");
	printf("1. Null call\n");
	printf("2. Mount call\n");
	printf("3. Dump call\n");
	printf("4. Umnt call\n");
	printf("5. Umntall call\n"); 
	printf("6. Quit\n");

       	printf("Please enter your choice\n");  
	scanf("%d",&choice);
	switch (choice){

	case 1:
		// printf("Null call case\n");		
        	result_1 = 
		mountproc3_null_3((void *)&mountproc3_null_3_arg, clnt);
		if (result_1 == NULL) {
                clnt_perror(clnt, "Null call failed:");
		exit(-1);
		}
		printf("Null call successful\n");
	break;

	case 2:
		// printf("Mount call case\n");	
	
        	result_2 = mountproc3_mnt_3((dirpath *)&dirp, clnt);
        	if (result_2 == NULL) {
                clnt_perror(clnt, "Mnt call failed:");
		exit(-1);
        	}
		// printf("status after a mount call is %d\n", result_2);
		printf("RESULT: result status(after mount call)is %d\n", 
						result_2->fhs_status);
        	printf("client end: mountinfo handle is  %p\n",
                   result_2->mountres3_u.mountinfo.fhandle.fhandle3_val);  
		// printf("before nfs_program_call\n");	
         	nfs_program_3(host, result_2, transp);
	break;

	case 3:
		// printf("Dump call case\n");
				
        	result_3 = 
		mountproc3_dump_3((void *) &mountproc3_dump_3_arg, clnt);
		
	break;

	case 4:
		// printf("Umnt call case\n");
	
         	result_4 = 
		mountproc3_umnt_3 ( &mountproc3_umnt_3_arg, clnt);	
	break;
	case 5:
		// printf("Umntall call case\n");
			
	break;

	case 6:
		printf("goodbye\n");
		exit(0);
	break;
		
	}		

	// printf("before nfs_program_call\n");	
        // nfs_program_3(host, result_2, transp);

	// printf("NFS PROGRAM FINISHED\n");
	// printf("NFS PROGRAM FINISHED\n");       


  return(result_2);
}


int main( int argc, char* argv[] )
{
	char *host;
        char *dirp;
        mountres3 *result_2;
        char *transport = "udp";
    
        result_2 = (mountres3 *)malloc(sizeof(mountres3));

	if(argc < 4) {
	  printf("usage: %s server_host path [transport]\n", argv[0]);
	  exit(1);
	}
	host = argv[1];
        dirp = argv[2];
	if(argc == 4)
		transport = argv[3];

        result_2 = mount_program_3(host, dirp, transport);
 return 0;
}
