#ifndef _LINUX_MYNFS_H
#define _LINUX_MYNFS_H

#include <linux/sunrpc/msg_prot.h>

#define NFS_MNTPROC_MNT 	1
#define MOUNT_V3  		3
#define MOUNT_PROGRAM 		100005
#define MOUNTPROC3_NULL		0
#define MOUNTPROC3_MNT 		1

#define NFS3_FHSIZE 		64 
#define MAX_SIZE		64
#define NFS3_COOKIEVERFSIZE	8
#define NFS3_CREATEVERFSIZE	8
#define NFS3_WRITEVERFSIZE	8
#define NFS3_READ_DATASIZE	1024
#define NFS3_WRITE_DATASIZE	64

#define NFS_PORT                4600	
#define NFS_MAXDATA     	8192
#define NFS_MAXPATHLEN  	1024
#define NFS_MAXNAMLEN   	255
#define NFS_MAXGROUPS   	16
#define NFS_COOKIESIZE  	4
#define NFS_FIFO_DEV    	(-1)
#define NFSMODE_FMT     	0170000
#define NFSMODE_DIR     	0040000
#define NFSMODE_CHR     	0020000
#define NFSMODE_BLK     	0060000
#define NFSMODE_REG     	0100000
#define NFSMODE_LNK     	0120000
#define NFSMODE_SOCK    	0140000
#define NFSMODE_FIFO    	0010000   

typedef char *filename3;
typedef char *nfspath3;
typedef char cookieverf3[NFS3_COOKIEVERFSIZE];
	
struct nfs_fh3 {
   __u32	size;	
   __u8 	data[NFS3_FHSIZE]; 
};

typedef struct nfs_fh3 nfs_fh3;

/*
struct nfs_fh3 {
char	data[NFS3_FHSIZE];
};
*/


extern struct rpc_program 	nfs_program;
extern struct rpc_stat 		nfs_rpcstat;

/* NFS V3 */

#define NFS_PROGRAM 		100003
#define NFS_VERSION		3
#define NFSPROC_NULL		0
#define NFSPROC_GETATTR  	1	
#define NFSPROC_SETATTR		2
#define NFSPROC_LOOKUP	        3 	
#define NFSPROC_ACCESS		4
#define NFSPROC_READLINK	5
#define NFSPROC_READ		6
#define NFSPROC_WRITE		7
#define NFSPROC_CREATE		8
#define NFSPROC_MKDIR		9
#define NFSPROC_SYMLINK         10	
#define NFSPROC_MKNOD		11
#define NFSPROC_REMOVE		12
#define NFSPROC_RMDIR		13
#define NFSPROC_RENAME		14
#define NFSPROC_LINK		15
#define NFSPROC_READDIR         16
#define NFSPROC_READDIRPLUS	17
#define NFSPROC_FSSTAT		18
#define NFSPROC_FSINFO		19
#define NFSPROC_PATHCONF	20
#define NFSPROC_COMMIT		21
	
#define NFS3_MAXNAMLEN 		255
#define NFS3_WRITEVERFSIZE      8	
#define NFS3_MAXPATHLEN		1024

enum ftype3 {
	NF3NON = 0,
	NF3REG = 1,
	NF3DIR = 2,
	NF3BLK = 3,
	NF3CHR = 4,
	NF3LNK = 5,
	NF3SOCK = 6,
	NF3FIFO = 7,
	NF3BAD = 8
};

typedef char writeverf3[NFS3_WRITEVERFSIZE];

struct nfstime3 {
	__u32	seconds;
	__u32	useconds;
};
struct specdata3 {
        __u32                   rdev_maj;
        __u32                   rdev_min;
};

struct fattr3 {
        enum ftype3             type;  
        __u32                   mode; 
        __u32                   nlink;
        __u32                   uid;  
        __u32                   gid;
        __u64                   size;
        __u64                   used;
	struct specdata3	rdev;
	__u64			fsid;
        __u64                   fileid;
        struct nfstime3         atime;
        struct nfstime3         mtime;
        struct nfstime3         ctime;
};
typedef  struct fattr3 fattr3;

struct nfs3_wcc_attr {
	__u64		size;	
	struct nfstime3	mtime;
	struct nfstime3 ctime;
}; 
typedef struct nfs3_wcc_attr  nfs3_wcc_attr;

struct nfs3_wcc_data {
	struct nfs3_wcc_attr	*before;
	struct fattr3		*after;
}; 

typedef struct nfs3_wcc_data nfs3_wcc_data;

struct set_mode3 {
	int 	set_it;
	__u32	mode;		
};

typedef struct set_mode3  set_mode3;

struct set_uid3	{
	int     set_it;
	__u32	uid;
};

typedef struct set_uid3 set_uid3;

struct set_gid3 {
	int  set_it;
	__u32	gid;
}; 

typedef struct set_gid3 set_gid3;

struct set_size3 {
	int  set_it;
	__u64	size;
};

typedef struct set_size3 set_size3;

struct set_atime3 {
	int	set_it;
	struct nfstime3 atime;
}; 
typedef struct set_atime3 set_atime3;

struct set_mtime3 {
	int	set_it;
	struct nfstime3 mtime;
}; 
typedef struct set_mtime3 set_mtime3;

struct setattr3 {
	struct set_mode3	mode3;
	struct set_uid3		uid3;
	struct set_gid3		gid3;
	struct set_size3	size3;
	struct set_atime3	atime3;
	struct set_mtime3	mtime3;
};

typedef struct setattr3 setattr3;

struct sattr3 {
	__u32		mode;
	__u32 		uid;
	__u32		gid;
	__u64		size;
	struct nfstime3 atime;
	struct nfstime3 mtime;
};

typedef struct sattr3  sattr3;

enum nfsstat3 {
        NFS3_OK = 		0,
        NFS3ERR_PERM =  	1,
        NFS3ERR_NOENT = 	2,
        NFS3ERR_IO = 		5,
        NFS3ERR_NXIO =  	6,
        NFS3ERR_ACCES = 	13,
        NFS3ERR_EXIST = 	17,
        NFS3ERR_XDEV =  	18,
        NFS3ERR_NODEV = 	19,
        NFS3ERR_NOTDIR = 	20,
        NFS3ERR_ISDIR = 	21,
        NFS3ERR_INVAL = 	22,
        NFS3ERR_FBIG = 		27,
        NFS3ERR_NOSPC = 	28,
  	NFS3ERR_ROFS = 		30,
        NFS3ERR_MLINK = 	31,
        NFS3ERR_NAMETOOLONG =   63,
        NFS3ERR_NOTEMPTY = 	66,
        NFS3ERR_DQUOT = 	69,
        NFS3ERR_STALE = 	70, 
        NFS3ERR_REMOTE = 	71,
        NFS3ERR_BADHANDLE = 	10001,
        NFS3ERR_NOT_SYNC = 	10002,
        NFS3ERR_BAD_COOKIE = 	10003,
 	NFS3ERR_NOTSUPP = 	10004,
        NFS3ERR_TOSMALL = 	10005,
        NFS3ERR_SERVERFAULT = 	10006,
        NFS3ERR_BADTYPE = 	10007,
        NFS3ERR_JUKEBOX = 	10008,
};

typedef enum nfsstat3 nfsstat3;

struct nfs3_diropargs {
	struct nfs_fh3 *	fh;
	const  char *		name;
};

typedef struct nfs3_diropargs 	nfs3_diropargs;

struct nfs3_diropok {
	struct nfs_fh3 *	fh;
	fattr3	*		fattr;
};

typedef struct nfs3_diropok nfs3_diropok;

// FSSTAT

struct  nfs3_fsstat {
	fattr3 *fattr;
	__u64 	tbytes;
	__u64   fbytes;
	__u64	abytes;
	__u64 	tfiles;
	__u64 	ffiles;
	__u64	afiles;
	__u32	invarsec;
};

typedef struct nfs3_fsstat nfs3_fsstat;


// READ

struct rdata {
	    __u32	data_len;		
	    __u8 	data_val[NFS3_READ_DATASIZE];
};
typedef struct rdata datablk;

struct nfs3_readargs {
	struct nfs_fh3 *	fh;
	__u32			offset;
	__u32			count;
	void *			buffer;
};

typedef struct nfs3_readargs nfs3_readargs;

struct nfs3_readres {
	fattr3*		fattr;
	unsigned int	count;
};

typedef struct nfs3_readres nfs3_readres;
	

// READDIR

struct nfs3_readdirargs {
	struct nfs_fh3*		fh;
	__u64			cookie;
	void *			buffer;
	unsigned int		bufsiz;
};

typedef struct nfs3_readdirargs		nfs3_readdirargs;

/* 
struct entry3 {
	__u64		fileid;
	filename3 	name;	
	__u64		cookie3;
	struct entry3	*nextentry;
};

struct dirlist3 {
	struct entry3	*entries;
	int		eof;	
};

typedef struct dirlist3 dirlist3;

struct nfs3_readdirres {
	fattr3*		fattr;
	cookieverf3	cookieverf;
        struct dirlist3	reply;
	__u32		size;
	__u32		count;
        __u64		cookie3;	
};

typedef struct nfs3_readdirres nfs3_readdirres;

*/

struct nfs3_readdirres {
	void*		buffer;
	unsigned int	bufsiz;
	fattr3		*fattr;
};


typedef struct nfs3_readdirres nfs3_readdirres;
// READDIRPLUS

struct nfs3_rdplusargs {
	nfs_fh3*	dir;
	__u64		cookie;
	void *		buffer;
	unsigned int	bufsiz;	
};

typedef struct nfs3_rdplusargs nfs3_rdplusargs;

struct nfs3_rdplusres {
	void *		buffer;
	unsigned int	bufsiz;
};

typedef struct nfs3_rdplusres nfs3_rdplusres;

// SETATTR

struct nfs3_sattrargs {
         nfs_fh3 	*fh;
	 setattr3	*sattr;	
};

typedef struct nfs3_sattrargs nfs3_sattrargs;


// WRITE
struct wdata {
	    __u32	data_len;		
	    __u8 	data_val[NFS3_FHSIZE];
};
typedef struct wdata wdatablk;

enum stable_how {
	UNSTABLE = 0,
	DATA_SYNC = 1,
	FILE_SYNC = 2,
};

typedef enum stable_how stable_how;
	
struct nfs3_writeargs {
  	nfs_fh3		*fh;
	__u32		offset;
	__u32		count;
	/* stable_how	stable;
	struct {
		__u16	data_len;
		__u8	data_val[NFS3_FHSIZE];	
	} data; */
	const void *buffer;
}; 

typedef struct nfs3_writeargs nfs3_writeargs;

struct nfs3_writeres {
	struct nfs3_wcc_data    *wcc_data;	
	__u32			count;
	stable_how		committed;
	writeverf3		verf;		
};
typedef struct nfs3_writeres nfs3_writeres;


// CREATE
enum createmode3 {
	UNCHECKED = 0,
	GUARD	= 1,
	EXCLUSIVE = 2,
};
typedef enum createmode3 createmode3;

struct nfs3_createargs {
 	nfs_fh3		*fh;
	const char 	*name;
	setattr3	*sattr;	
};
typedef struct nfs3_createargs 	nfs3_createargs;

struct nfs3_createres {
	struct nfs_fh3  	*fh;
	fattr3			*fattr;
	// struct nfs3_wcc_data    *wcc_data;	
};
typedef struct nfs3_createres nfs3_createres;

// MKNOD

struct nfs3_mknodargs {
	nfs_fh3 	*fh;
	const char	*name;
	enum ftype3	ftype;
};

typedef struct nfs3_mknodargs nfs3_mknodargs;
	
// SYMLINK

/* 
struct symlinkdata3 {
	setattr3 	*sattr;
	const char	*topath;
};
typedef struct symlinkdata3 symlinkdata3;
*/

struct nfs3_symlinkargs {
	nfs_fh3		*fromfh;
	const char	*fromname;
	const char	*topath;
	setattr3    	*sattr;		
};

typedef struct nfs3_symlinkargs 	nfs3_symlinkargs;


// RENAME 

struct nfs3_renameargs {
	nfs_fh3		*fromfh;
	const	char 	*fromname;
	nfs_fh3		*tofh;
	const	char	*toname;
};

typedef struct nfs3_renameargs	nfs3_renameargs;

struct nfs3_renameres {
	struct nfs3_wcc_data *from; 
	struct nfs3_wcc_data *to; 
};
typedef struct nfs3_renameres nfs3_renameres;

// READLINK

struct nfs3_readlinkres {
	fattr3		*fattr;
	nfspath3	data;
};

typedef struct nfs3_readlinkres nfs3_readlinkres;


// LINK

struct nfs3_linkargs {
	struct nfs_fh3		*fromfh;
	struct nfs_fh3		*tofh;
	const	char 		*toname;
}; 

typedef struct nfs3_linkargs	nfs3_linkargs;

struct nfs3_linkres {
	fattr3		*fattr;
	nfs3_wcc_data	*wcc_data;	
};

typedef struct nfs3_linkres nfs3_linkres;

// COMMIT

struct nfs3_commitargs {
	struct nfs_fh3		*file;
	__u64			offset;
	__u32			count;
};

typedef struct nfs3_commitargs	 nfs3_commitargs; 

struct nfs3_commitres {
	nfs3_wcc_data	*wcc_data;
	writeverf3	verf;
};

typedef struct nfs3_commitres nfs3_commitres;

// PATHCONF

struct nfs3_pathconfres {
	fattr3		*fattr;
	__u32		linkmax;
	__u32		name_max;
	int		no_trunc;
	int		chown_restricted;			
};

typedef struct nfs3_pathconfres nfs3_pathconfres;

// ACCESS
struct nfs3_accessargs {
	struct	nfs_fh3*  object;
	__u32		  access;				
};

typedef struct nfs3_accessargs nfs3_accessargs;

struct nfs3_accessres {
	fattr3		*fattr;
	__u32		access;
};

typedef struct nfs3_accessres nfs3_accessres;

// FSINFO

struct nfs3_fsinfores {
	fattr3 		*fattr;
        __u32		rtmax;
	__u32		rtpref;
	__u32		rtmult;
	__u32		wtmax;
	__u32		wtpref;
	__u32		wtmult;
	__u32		dtpref;
  	__u64		maxfilesize;
        struct nfstime3	time_delta; 				 	
	__u32		properties;
};

typedef struct nfs3_fsinfores nfs3_fsinfo;

#endif

