#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: quizgrader.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a chapter number, quiz number, and up to 25 pairs of student
#  answers and correct answers as CGI input.  The script inserts the given
#  answers and correct answers into two different arrays to allow for easier
#  processing.  The script compares the two sets of array elements and counts
#  the number of matches to determine the total number of correct responses.
#  Then the script prints out a summary of the quiz containing the percentage
#  of correct answers, the number of correct answers, the number of incorrect
#  answers, and the number of questions not answered.  Once the script finishes
#  printing the summary, it opens the quiz file using the chapter number and
#  quiz number accepted as CGI input.  The script reads the quiz questions
#  from the file and prints out all the questions.  Under every question the
#  script prints the users answer, correct answer, and whether it is correct
#  or incorrect.  The script also prints feedback about the users responses.
#  The script generates feedback by examining the word components in the
#  question and looking up the definitions of those word components in the
#  sites glossary.  These definitions are used to print out information about
#  the correct and incorrect answers for the users clarification.  The script
#  prints this information in html format using the quizzes-webpage template.
#  This template allows the user to immediately select a new chapter and quiz
#  from the current screen.  Finally, the script connects to the database using
#  DBI and stores the quiz results.  The script saves each student answer in the
#  database along with the quiz number, chapter number, and user identification
#  number.  The script inserts these quiz results into the quizzes table, and
#  these results are accessible via the View Results page.   
#=========================================================================
require 'cookielib/cookie.lib';
use CGI;
use DBI;
my $line;
my $glossaryline;
my $userid;
my $username;
my $counter=1;
my $quiznum=1;
my $question=1;
my $numcorrectanswers=0;
my $numunanswered=0;
my $qcounter=0;
my $temp=1;
my $wordfound="false";
my $concatenatedstring;
my @wordcomponent;
my @componentmeanings;
my $numwordcomponents=0;
my $numberfound=0;
my $componentmeaning="";
my $choppedletter="";
my $q=new CGI;
my $chapter = $q->param('chapter');
my $quiz = $q->param('quiz');
my $numquizzes=$q->param('numquizzes');
my @answer=$q->param('answer');
my $question1=$q->param('question1');
my $question2=$q->param('question2');
my $question3=$q->param('question3');
my $question4=$q->param('question4');
my $question5=$q->param('question5');
my $question6=$q->param('question6');
my $question7=$q->param('question7');
my $question8=$q->param('question8');
my $question9=$q->param('question9');
my $question10=$q->param('question10');
my $question11=$q->param('question11');
my $question12=$q->param('question12');
my $question13=$q->param('question13');
my $question14=$q->param('question14');
my $question15=$q->param('question15');
my $question16=$q->param('question16');
my $question17=$q->param('question17');
my $question18=$q->param('question18');
my $question19=$q->param('question19');
my $question20=$q->param('question20');
my $question21=$q->param('question21');
my $question22=$q->param('question22');
my $question23=$q->param('question23');
my $question24=$q->param('question24');
my $question25=$q->param('question25');
my @questionresult;
my @useranswers=($question1, $question2,$question3,$question4,$question5,$question6,$question7,$question8,$question9,
                 $question10, $question11, $question12, $question13, $question14, $question15, $question16, $question17,
                 $question18, $question19, $question20, $question21,$question22,$question23,$question24,$question25);


my $database = $dbname;
my $port = $dbport;
my $dsn = $dbpassword;

my $dbh = DBI->connect($dsn)
   or exit(1);

my $querystring="UPDATE quizzes SET ";
my $loop=1;

if((&GetCookies('name'))&&(&GetCookies('userid'))){
  $username = $Cookies{'name'};
  $userid = $Cookies{'userid'};
}
else{
  exit(-1);
}

while($qcounter<$numquizzes){
  if($useranswers[$qcounter] eq $answer[$qcounter]){
    $questionresult[$qcounter]="Correct";
    $numcorrectanswers=$numcorrectanswers+1;
  }
  elsif(!$useranswers[$qcounter]){
    $questionresult[$qcounter]="Not Answered";
    $numunanswered=$numunanswered+1;
  }
  else{
    $questionresult[$qcounter]="Incorrect";
  }
  $qcounter=$qcounter+1;
}
my $percentcorrect=(($numcorrectanswers/1.0)/($numquizzes/1.0))*100.0;
$percentcorrect=sprintf("%.1f", $percentcorrect);
my $numincorrectanswers=$numquizzes-$numcorrectanswers-$numunanswered;

for(my $i=0; $i<25; $i++){
   $querystring = $querystring . "answer$loop = '$useranswers[$i]' ,";
   $loop++;
}
$querystring = $querystring . "numcorrect = '$numcorrectanswers' , numquestions = '$numquizzes' ";

$querystring = $querystring . "WHERE userid='$userid' AND chapter='$chapter' AND quiznumber='$quiz'";

my $sth = $dbh->prepare("$querystring");
$sth->execute();
$sth->finish();


print "Content-type:text/html\n\n";
open(QUIZPAGE, "quizpage.html");
while($line=<QUIZPAGE>){
  print "$line";
  if($line eq "<!--CHAPTERBANNER--!>\n"){
    if(($chapter)&&($chapter ne "0")){
      print "Chapter $chapter";
    }
    else{
      print "No Chapter Selected";
    }
  }
  if($line eq "<!--STARTOFQUIZ--!>\n"){
    print "<p align=\"center\"><font size=\"4\"><b>Chapter $chapter</b></font></p>";
    print "<p align=\"center\"><font size=\"4\"><b>Quiz $quiz</b></font></p>";
  }
  if($line eq "<!--STARTOFMAIN--!>\n"){
    if((!$chapter)||($chapter eq "0")){
	print "<p align=\"center\"><b><font size=\"5\">No Chapter Selected</font></b></p>";
    }
    else{
	print "<p align=\"center\"><b><font size=\"5\">Chapter $chapter</font></b></p>";
    }
    if(!$quiz){
	print "<p align=\"center\"><b><font size=\"5\">No Quiz Selected</font></b></p>";
    }
    else{
      #print the quiz!
      print "<p align=\"center\"><b><font size=\"5\">Quiz $quiz Results</font></b></p>";
      #insert graph of results here!!! 
      print<<TABLE;
      <div align="center">
        <center>
        <table border="2" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
          <tr>
            <td width="100%">
            <p align="center"><b><font size="5">Summary: $percentcorrect% Correct</font></b></p>
            <blockquote>
              <p><font size="4">Out of $numquizzes Questions, here are 
            your results:<br>$numcorrectanswers <font color="#008000">Correct</font><br> $numincorrectanswers
              <font color="#800000">Incorrect</font><br> $numunanswered 
              <font color="#000080">Not Answered</font></font></blockquote>
            </td>
          </tr>
        </table>
        </center>
      </div>
<br><p></p><br>
TABLE
      print "<div align=\"center\"><center> <table border=\"0\" cellspacing=\"1\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"80%\">";
      print "<tr><td width=\"100%\">";

      open(QUIZ, "chapter$chapter/quiz$quiz.txt");
      $line=<QUIZ>;
      while($line=<QUIZ>){
        print "<hr>";
        if($line eq "<MC>\n"){
        $line=<QUIZ>;
        print "<b>$question.</b> $line <br>";
        print "&nbsp;&nbsp;&nbsp;Your Answer: $useranswers[$question-1]<br>";
        print "&nbsp;&nbsp;&nbsp;The Correct Answer: $answer[$question-1]<br>";
        if($questionresult[$question-1] eq "Correct"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"5\" color=\"#008000\">Correct</font></b>";
         $line=<QUIZ>;
         $line=<QUIZ>;
         $line=<QUIZ>;
         $line=<QUIZ>;
         $line=<QUIZ>;
        }
        elsif($questionresult[$question-1] eq "Incorrect"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#800000\" size=\"5\">Incorrect</font></b>";
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"4\">Feedback</font></b>";

         $concatenatedstring = $line . $useranswers[$question-1] . $answer[$question-1];
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         while($concatenatedstring =~ /<wc>(.*?)<\/wc>/){
           while($temp <= $numwordcomponents){
             if( $1 eq $wordcomponent[$temp]){
               $wordfound="true";
             }
             $temp++;
           }  
           if($wordfound eq "false"){
             $wordcomponent[$counter] = $1; 
             $numwordcomponents++;
             $counter++;
           }
           $concatenatedstring =~ s/<wc>//;
           $concatenatedstring =~ s/<\/wc>//;
         } #end while

         open(GLOSSARY, "glossary/glossary.txt");
         while($glossaryline=<GLOSSARY>){
           $componentmeaning="";
           $choppedletter="";
           $choppedletter=chop($glossaryline);
           while(($choppedletter ne ";") && ($glossaryline)){
             $choppedletter=chop($glossaryline);
             if ($choppedletter ne ";"){
               $componentmeaning=$choppedletter . $componentmeaning;
             } #end if
          } #end chopped letter
          for(my $i=1; $i<=$numwordcomponents; $i++){
            if($glossaryline eq $wordcomponent[$i]){
              if(!$componentmeanings[$i]) {
                $numberfound++;
              }
              $componentmeaning=substr($componentmeaning, 1);
              $componentmeanings[$i] = $componentmeaning;
            }
          } #end for 
        } #end line=glossary

if($numwordcomponents>=1){
  print <<FEEDBACKPART;
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="70%">
  <tr>
      <td width="20%"><p align="left">&nbsp;&nbsp;&nbsp;Remember that:</td>
FEEDBACKPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"20%\">&nbsp;&nbsp;</td><td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<p>&nbsp;&nbsp;&nbsp;No hint could be generated.";
}


         #clear all variables
         $temp=1;
         while($temp <= $numwordcomponents){
           $wordcomponent[$temp]="";
           $componentmeanings[$temp]="";
           $temp++;
         }#end while
         $numwordcomponents=0;
         $counter=1;
         $temp=1;
        } #end elsif
        elsif($questionresult[$question-1] eq "Not Answered"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#000080\" size=\"5\">Not Answered</font></b>";
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"4\">Feedback</font></b>";

         $concatenatedstring = $line . $useranswers[$question-1] . $answer[$question-1];
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         $concatenatedstring = $concatenatedstring . $line;
         $line=<QUIZ>;
         while($concatenatedstring =~ /<wc>(.*?)<\/wc>/){
           while($temp <= $numwordcomponents){
             if( $1 eq $wordcomponent[$temp]){
               $wordfound="true";
             }
             $temp++;
           }  
           if($wordfound eq "false"){
             $wordcomponent[$counter] = $1; 
             $numwordcomponents++;
             $counter++;
           }
           $concatenatedstring =~ s/<wc>//;
           $concatenatedstring =~ s/<\/wc>//;
         } #end while

         open(GLOSSARY, "glossary/glossary.txt");
         while($glossaryline=<GLOSSARY>){
           $componentmeaning="";
           $choppedletter="";
           $choppedletter=chop($glossaryline);
           while(($choppedletter ne ";") && ($glossaryline)){
             $choppedletter=chop($glossaryline);
             if ($choppedletter ne ";"){
               $componentmeaning=$choppedletter . $componentmeaning;
             } #end if
          } #end chopped letter
          for(my $i=1; $i<=$numwordcomponents; $i++){
            if($glossaryline eq $wordcomponent[$i]){
              if(!$componentmeanings[$i]) {
                $numberfound++;
              }
              $componentmeaning=substr($componentmeaning, 1);
              $componentmeanings[$i] = $componentmeaning;
            }
          } #end for 
        } #end line=glossary

if($numwordcomponents>=1){
  print <<FEEDBACKPART;
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="70%">
  <tr>
      <td width="20%"><p align="left">&nbsp;&nbsp;&nbsp;Remember that:</td>
FEEDBACKPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"20%\">&nbsp;&nbsp;</td><td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<p>&nbsp;&nbsp;&nbsp;No hint could be generated.";
}


         #clear all variables
         $temp=1;
         while($temp <= $numwordcomponents){
           $wordcomponent[$temp]="";
           $componentmeanings[$temp]="";
           $temp++;
         }#end while
         $numwordcomponents=0;
         $counter=1;
         $temp=1;

        }
        $numberfound=0;


        $question=$question+1;
        }
        elsif($line eq "<TF>\n"){
        $line=<QUIZ>;
        print "<b>$question.</b> $line <br>";
        print "&nbsp;&nbsp;&nbsp;Your Answer: $useranswers[$question-1]<br>";
        print "&nbsp;&nbsp;&nbsp;The Correct Answer: $answer[$question-1]<br>";
        if($questionresult[$question-1] eq "Correct"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"5\" color=\"#008000\">Correct</font></b>";
	    $line=<QUIZ>;
        }
        elsif($questionresult[$question-1] eq "Incorrect"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#800000\" size=\"5\">Incorrect</font></b>";
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"4\">Feedback</font></b>";

         $concatenatedstring = $line . $useranswers[$question-1] . $answer[$question-1];
         $line=<QUIZ>;
         while($concatenatedstring =~ /<wc>(.*?)<\/wc>/){
           while($temp <= $numwordcomponents){
             if( $1 eq $wordcomponent[$temp]){
               $wordfound="true";
             }
             $temp++;
           }  
           if($wordfound eq "false"){
             $wordcomponent[$counter] = $1; 
             $numwordcomponents++;
             $counter++;
           }
           $concatenatedstring =~ s/<wc>//;
           $concatenatedstring =~ s/<\/wc>//;
         } #end while

         open(GLOSSARY, "glossary/glossary.txt");
         while(($glossaryline=<GLOSSARY>)){
           $componentmeaning="";
           $choppedletter="";
           $choppedletter=chop($glossaryline);
           while(($choppedletter ne ";") && ($glossaryline)){
             $choppedletter=chop($glossaryline);
             if ($choppedletter ne ";"){
               $componentmeaning=$choppedletter . $componentmeaning;
             } #end if
          } #end chopped letter
          for(my $i=1; $i<=$numwordcomponents; $i++){
            if($glossaryline eq $wordcomponent[$i]){
              if(!$componentmeanings[$i]) {
                $numberfound++;
              }
              $componentmeaning=substr($componentmeaning, 1);
              $componentmeanings[$i] = $componentmeaning;
            }
          } #end for 
        } #end line=glossary

if($numwordcomponents>=1){
  print <<FEEDBACKPART;
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="70%">
  <tr>
      <td width="20%"><p align="left">&nbsp;&nbsp;&nbsp;Remember that:</td>
FEEDBACKPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"20%\">&nbsp;&nbsp;</td><td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<p>&nbsp;&nbsp;&nbsp;No hint could be generated.";
}


         #clear all variables
         $temp=1;
         while($temp <= $numwordcomponents){
           $wordcomponent[$temp]="";
           $componentmeanings[$temp]="";
           $temp++;
         }#end while
         $numwordcomponents=0;
         $counter=1;
         $temp=1;

        }
        elsif($questionresult[$question-1] eq "Not Answered"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#000080\" size=\"5\">Not Answered</font></b>";
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"4\">Feedback</font></b>";

         $concatenatedstring = $line . $useranswers[$question-1] . $answer[$question-1];
         $line=<QUIZ>;
         while($concatenatedstring =~ /<wc>(.*?)<\/wc>/){
           while($temp <= $numwordcomponents){
             if( $1 eq $wordcomponent[$temp]){
               $wordfound="true";
             }
             $temp++;
           }  
           if($wordfound eq "false"){
             $wordcomponent[$counter] = $1; 
             $numwordcomponents++;
             $counter++;
           }
           $concatenatedstring =~ s/<wc>//;
           $concatenatedstring =~ s/<\/wc>//;
         } #end while

         open(GLOSSARY, "glossary/glossary.txt");
         while(($glossaryline=<GLOSSARY>)){
           $componentmeaning="";
           $choppedletter="";
           $choppedletter=chop($glossaryline);
           while(($choppedletter ne ";") && ($glossaryline)){
             $choppedletter=chop($glossaryline);
             if ($choppedletter ne ";"){
               $componentmeaning=$choppedletter . $componentmeaning;
             } #end if
          } #end chopped letter
          for(my $i=1; $i<=$numwordcomponents; $i++){
            if($glossaryline eq $wordcomponent[$i]){
              if(!$componentmeanings[$i]) {
                $numberfound++;
              }
              $componentmeaning=substr($componentmeaning, 1);
              $componentmeanings[$i] = $componentmeaning;
            }
          } #end for 
        } #end line=glossary

if($numwordcomponents>=1){
  print <<FEEDBACKPART;
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="70%">
  <tr>
      <td width="20%"><p align="left">&nbsp;&nbsp;&nbsp;Remember that:</td>
FEEDBACKPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"20%\">&nbsp;&nbsp;</td><td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<p>&nbsp;&nbsp;&nbsp;No hint could be generated.";
}


         #clear all variables
         $temp=1;
         while($temp <= $numwordcomponents){
           $wordcomponent[$temp]="";
           $componentmeanings[$temp]="";
           $temp++;
         }#end while
         $numwordcomponents=0;
         $counter=1;
         $temp=1;

        }
        $question=$question+1;
        }
        elsif($line eq "<FIB>\n"){
        $line=<QUIZ>;
        print "<b>$question.</b> $line <br>";
        print "&nbsp;&nbsp;&nbsp;Your Answer: $useranswers[$question-1]<br>";
        print "&nbsp;&nbsp;&nbsp;The Correct Answer: $answer[$question-1]<br>";
        if($questionresult[$question-1] eq "Correct"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"5\" color=\"#008000\">Correct</font></b>";
          $line=<QUIZ>;
        }
        elsif($questionresult[$question-1] eq "Incorrect"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#800000\" size=\"5\">Incorrect</font></b>";
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"4\">Feedback</font></b>";

         $concatenatedstring = $line . $useranswers[$question-1] . $answer[$question-1];
         $line=<QUIZ>;
	   $concatenatedstring= $concatenatedstring . $line;
         while($concatenatedstring =~ /<wc>(.*?)<\/wc>/){
           while($temp <= $numwordcomponents){
             if( $1 eq $wordcomponent[$temp]){
               $wordfound="true";
             }
             $temp++;
           }  
           if($wordfound eq "false"){
             $wordcomponent[$counter] = $1; 
             $numwordcomponents++;
             $counter++;
           }
           $concatenatedstring =~ s/<wc>//;
           $concatenatedstring =~ s/<\/wc>//;
         } #end while

         open(GLOSSARY, "glossary/glossary.txt");
         while(($glossaryline=<GLOSSARY>)){
           $componentmeaning="";
           $choppedletter="";
           $choppedletter=chop($glossaryline);
           while(($choppedletter ne ";") && ($glossaryline)){
             $choppedletter=chop($glossaryline);
             if ($choppedletter ne ";"){
               $componentmeaning=$choppedletter . $componentmeaning;
             } #end if
          } #end chopped letter
          for(my $i=1; $i<=$numwordcomponents; $i++){
            if($glossaryline eq $wordcomponent[$i]){
              if(!$componentmeanings[$i]) {
                $numberfound++;
              }
              $componentmeaning=substr($componentmeaning, 1);
              $componentmeanings[$i] = $componentmeaning;
            }
          } #end for 
        } #end line=glossary

if($numwordcomponents>=1){
  print <<FEEDBACKPART;
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="70%">
  <tr>
      <td width="20%"><p align="left">&nbsp;&nbsp;&nbsp;Remember that:</td>
FEEDBACKPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"20%\">&nbsp;&nbsp;</td><td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<p>&nbsp;&nbsp;&nbsp;No hint could be generated.";
}


         #clear all variables
         $temp=1;
         while($temp <= $numwordcomponents){
           $wordcomponent[$temp]="";
           $componentmeanings[$temp]="";
           $temp++;
         }#end while
         $numwordcomponents=0;
         $counter=1;
         $temp=1;

        }
        elsif($questionresult[$question-1] eq "Not Answered"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#000080\" size=\"5\">Not Answered</font></b>";
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"4\">Feedback</font></b>";

         $concatenatedstring = $line . $useranswers[$question-1] . $answer[$question-1];
         $line=<QUIZ>;
	   $concatenatedstring= $concatenatedstring . $line;
         while($concatenatedstring =~ /<wc>(.*?)<\/wc>/){
           while($temp <= $numwordcomponents){
             if( $1 eq $wordcomponent[$temp]){
               $wordfound="true";
             }
             $temp++;
           }  
           if($wordfound eq "false"){
             $wordcomponent[$counter] = $1; 
             $numwordcomponents++;
             $counter++;
           }
           $concatenatedstring =~ s/<wc>//;
           $concatenatedstring =~ s/<\/wc>//;
         } #end while

         open(GLOSSARY, "glossary/glossary.txt");
         while(($glossaryline=<GLOSSARY>)){
           $componentmeaning="";
           $choppedletter="";
           $choppedletter=chop($glossaryline);
           while(($choppedletter ne ";") && ($glossaryline)){
             $choppedletter=chop($glossaryline);
             if ($choppedletter ne ";"){
               $componentmeaning=$choppedletter . $componentmeaning;
             } #end if
          } #end chopped letter
          for(my $i=1; $i<=$numwordcomponents; $i++){
            if($glossaryline eq $wordcomponent[$i]){
              if(!$componentmeanings[$i]) {
                $numberfound++;
              }
              $componentmeaning=substr($componentmeaning, 1);
              $componentmeanings[$i] = $componentmeaning;
            }
          } #end for 
        } #end line=glossary

if($numwordcomponents>=1){
  print <<FEEDBACKPART;
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="70%">
  <tr>
      <td width="20%"><p align="left">&nbsp;&nbsp;&nbsp;Remember that:</td>
FEEDBACKPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"20%\">&nbsp;&nbsp;</td><td width=\"80%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<p>&nbsp;&nbsp;&nbsp;No hint could be generated.";
}


         #clear all variables
         $temp=1;
         while($temp <= $numwordcomponents){
           $wordcomponent[$temp]="";
           $componentmeanings[$temp]="";
           $temp++;
         }#end while
         $numwordcomponents=0;
         $counter=1;
         $temp=1;

        }
        $question=$question+1;
        }
      }
      close(QUIZ);
      print "<hr><br>";
      print "</FORM>";
      print "</td></tr></table></center></div></tr></table></div>";
    }
  }
}

close QUIZPAGE;
$dbh->disconnect();
exit(0);
