#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: mainpage.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a page name as its only input from the CGI.  First, the script
#  opens the common webpage template and prints the contents of this file
#  until it finds the invisible comment used to mark the starting point of
#  the main webpage area.  When the script finds this comment, it prints
#  the html for the main area of the template based on the page name the
#  script received from the form submission.  After the script prints the
#  main area html, the script finishes printing the remaining content of
#  the webpage template html file.  Finally, the script closes home.html
#  and exits.  This script is simple but critical to the operation of
#  MostWise.  It is responsible for printing the html that transports
#  visitors around the outside of the website.  
#=========================================================================
use CGI;
require 'cookielib/cookie.lib';
my $line;
my $q=new CGI;
my $page = $q->param('page');

my $name;
my $type;
my $id;

if((&GetCookies('name'))&&(&GetCookies('userid'))&&(&GetCookies('usertype'))){
  $name=$Cookies{'name'};
  $type=$Cookies{'usertype'};
  $id=$Cookies{'userid'};
} 


print "Content-type:text/html\n\n";
if(!$type){
  open(MAINPAGE, "home.html");
}
elsif($type eq "administrator"){
  open(MAINPAGE, "administrator.html");
}
elsif($type eq "teacher"){
  open(MAINPAGE, "teacher.html");
}
elsif($type eq "student"){
  open(MAINPAGE, "student.html");
}
while($line=<MAINPAGE>){
  if($line eq "<!--MAIN--!>\n"){
    if($page eq "overview"){
print <<OVERVIEW;
<div align="center">
  <center>
  <table border="0" cellspacing="4" style="border-collapse: collapse" bordercolor="#111111" width="90%" cellpadding="3" height="296">
    <tr>
      <td width="100%" height="39">
      <p align="center"><font size="5" color="#FFFFFF"><b>Overview</b></font></td>
    </tr>
    <tr>
      <td width="100%" height="237">
      <table border="0" style="border-collapse: collapse" bordercolor="#111111" width="100%" cellpadding="6">
        <tr>
          <td width="100%">
      <ul>
        <li><font size="4">MostWise.com is a server-based testing and 
        record-keeping system that incorporates a new student feedback system as 
        well as advanced administrator and teacher options.&nbsp; </font></li>
     
          </td> </ul>
        </tr>
        <tr>
          <td width="100%">
      <ul>
        <li><font size="4">MostWise.com is designed to facilitate a learning environment 
        where students can study various forms of terminology without the need 
        of a teacher being present. &nbsp;</font></li>
     
          </td> </ul>
        </tr>
        <tr>
          <td width="100%">
      <ul>
        <li><font SIZE="4">Initially this website will be designed to complement 
        the material in the book <u>Words and Ideas</u>, but can be updated as 
        additional material becomes available. &nbsp;</font></li>
      </ul>
          </td>
        </tr>
      </table>
      </td>
    </tr>
  </table>
  </center>
OVERVIEW
      }
    elsif($page eq "home"){
      }
      elsif($page eq "siteinfo"){
       print <<SITEINFO;
<div align="center">
  <center>
  <table border="0" cellspacing="4" style="border-collapse: collapse" bordercolor="#111111" width="90%" cellpadding="3" height="296">
    <tr>
      <td width="100%" height="39">
      <p align="center"><b><font size="5" color="#FFFFFF">Site Information</font></b></td>
    </tr>
    <tr>
      <td width="100%" height="237">
      <table border="0" style="border-collapse: collapse" bordercolor="#111111" width="100%" cellpadding="6">
        <tr>
          <td width="100%">
      <ul>
        <li><font size="4">MostWise.com was created by Trevor Barnett, currently a graduate student at the University of Kentucky.</font></li>
     
          </td> </ul>
        </tr>
        <tr>
          <td width="100%">
      <ul>
        <li><font size="4">MostWise.com uses CGI, Perl, MySQL database, cookies, JavaScript, and HTML to create a free online system 
        that facilitates student learning in the area of classic terminology. </font></li>
     
          </td> </ul>
        </tr>
        <tr>
          <td width="100%">
      <ul>
        <li><font size="4">The only requirement for accessing MostWise.com is a browser that has cookies and JavaScript enabled.  Users must have these items enabled or they will be unable to use this website.
            
                </div>
                </font></li>
      </ul>
          </td>
        </tr>
      </table>
      </td>
    </tr>
  </table>
  </center>

SITEINFO
      }
	elsif($page eq "relatedwebsites"){
	 print <<RELATEDWEBSITES;
    <p align="center"><font color="#FFFFFF" style="font-size: 16pt">Related Websites

                </div></font></p>
                <div align="center">
                  <center>
                  <table border="1" style="border-collapse: collapse" bordercolor="#111111" width="55%" cellpadding="2" height="147">
                    <tr>
                      <td width="100%" align="center" height="20"><font size="4">
                      <a href="http://www.bolchazy.com/prod.php?cat=greek&id=4851" target=_blank>Words and Ideas Website</a></font></td>
                    </tr>
                    <tr>
                      <td width="100%" align="center" height="20"><font size="4">
                      <a href="http://www.uky.edu" target=_blank>University 
                      of Kentucky Homepage</a></font></td>
                    </tr>
                    <tr>
                      <td width="100%" align="center" height="20"><font size="4">
                      <a href="http://www.uky.edu/AS/" target=_blank>UK College 
                      of Arts &amp; Sciences</a></font></td>
                    </tr>
                    <tr>
                      <td width="100%" align="center" height="20"><font size="4">
                      <a href="http://www.uky.edu/AS/Classics/" target=_blank>UK Classics 
                      Department</a></font></td>
                    </tr>
                    <tr>
                      <td width="100%" align="center" height="20"><font size="4">
                      <a href="http://www.cs.uky.edu" target=_blank>UK 
                      Department of Computer Science</a></font></td>
                    </tr>
                  </table>
                  </center>
RELATEDWEBSITES
	}
	elsif($page eq "samplescreenshots"){
	 print <<SAMPLESCREENSHOTS;
<p align="center"><b><font size="5" color="#FFFFFF">Sample Screenshots</font></b></p>
<div align="center">
  <center>
  <table border="0" cellpadding="3" style="border-collapse: collapse" bordercolor="#111111" width="48%">
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/administratorhomepagescreenshot.html" target="_blank">
      <font color="#000080">Administrator Homepage</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/studenthomepagescreenshot.html"  target="_blank">
      <font color="#000080">Student Homepage</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/teacherhomepagescreenshot.html" target="_blank">
      <font color="#000080">Teacher Homepage</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/exercisescreenshot.html" target="_blank">
      <font color="#000080">Exercise</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/exercisehintscreenshot.html" target="_blank">
      <font color="#000080">Exercise Hint</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/gradedexercisescreenshot.html" target="_blank">
      <font color="#000080">Graded Exercise</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/quizscreenshot.html" target="_blank">
      <font color="#000080">Quiz</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/gradedquizscreenshot.html" target="_blank">
      <font color="#000080">Graded Quiz</font></a></font></td>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4">
      <a href="http://$URL/screenshots/messageboardscreenshot.html" target="_blank">
      <font color="#000080">Message Board</font></a></font></td>
    </tr>
  </table>
  </center>
SAMPLESCREENSHOTS
	}
	elsif($page eq "registeraccount"){
	 print <<REGISTERACCOUNT;
                <center>
<font color="#FFFFFF"><span style="font-size: 16pt">Registration</span></font></center>


                  <div align="center">
                    <center>
                    <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="75%">
                      <tr>
                        <td width="100%">
<form name="registeranaccount" method=post action="registeraccount.cgi">
                        <center>
                        <div align="center">
                          <center>
                          <table border="0" cellpadding="4" style="border-collapse: collapse" bordercolor="#111111" width="77%" cellspacing="4">
                            <tr>
                              <td width="100%">Complete this form to register for a new 
                        account. </td>
                            </tr>
                          </table>
                          </center>
                        </div>
                        </center>
                        <div align="center" style="width: 408; height: 207">
                          <center>
                          <table border="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="89%">
                            <tr>
                              <td width="40%" align="right">Username:</td>
                              <td width="61%">&nbsp;&nbsp;<input type=text name="username" size="20"></td>
                            </tr>
                            <tr>
                              <td width="40%" align="right">Password:</td>
                              <td width="61%">&nbsp;&nbsp;<input type=password name="password" size="20"></td>
                            </tr>
                            <tr>
                              <td width="40%" align="right">Retype Password:</td>
                              <td width="61%">&nbsp;&nbsp;<input type=password name="retypepassword" size="20"></td>
                            </tr>
                            <tr>
                              <td width="40%" align="right">Email Address:</td>
                              <td width="61%">&nbsp;&nbsp;<input type=text name="emailaddress" size="20"></td>
                            </tr>
                            <tr>
                              <td width="40%" align="right">Secret Question:</td>
                              <td width="61%">&nbsp;
                              <select name="SecretQuestion" id="SecretQuestion">
                              <option value="Favorite pet's name?" selected> 
                              Favorite pet's name?
                              <option value="Favorite movie?"  > Favorite movie?
                              <option value="Favorite book?" > Favorite book?
                              <option value="Mother's maiden name?" > Mother's 
                              maiden name?
                              <option value="Father's middle name?"  > Father's 
                              middle name?
                              <option value="Spouse's middle name?"  > Spouse's 
                              middle name?
                              <option value="First child's middle name?"  > 
                              First child's middle name?
                              <option value="High school mascot?"  > High school 
                              mascot?
                              <option value="Favorite teacher's name?"  > 
                              Favorite teacher's name?
                              <option value="Favorite sports team?"  > Favorite 
                              sports team?</select></td>
                            </tr>
                            <tr>
                              <td width="40%" align="right">Secret Answer:</td>
                              <td width="61%">&nbsp;&nbsp;<input type=password name="secretanswer" size="20"></td>
                            </tr>
                            <tr>
                              <td width="40%" align="right">User type:</td>
                              <td width="61%">&nbsp;                              
                              <select name="usertype" id="usertype">
                              <option value="Student" selected> Student
                              <option value="Teacher"> Teacher
                              <option value="Administrator"  > Administrator
                              </select></td>
                            </tr>
                            <tr>
                            <td width="40%" align="right">Verification Password</td>
                              <td width="61%">&nbsp; <input type="password" name="verifypassword" size="20">
                              <font size="1">
                              <a href="javascript:popup()">
                              <font color="#0000FF">What is this?</font></a></font></td>
                            </tr>

                          </table>
                          <br>
                          <input type=submit name=submit value="Create Account" style="width: 110; height: 24; font-size: 15px">
                          </center>
                        </div>
                        </td>
</FORM>
                      </tr>
                    </table>
                    </center>
                </div>
REGISTERACCOUNT
	}
	elsif($page eq "trouble"){
	 print <<TROUBLE;
<br>
                <div align="center">
                  <center>
                  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="75%" height="124">
                    <tr>
                      <td width="100%" height="48"><font face="Arial" size="4">If you had trouble logging in, have 
                      you...</font></td>
                    </tr>
                    <tr>
                      <td width="100%" height="26">
                          <form name="forgotusername" method=post action="mainpage.cgi">
                          <font face="Arial">
                          <a href="Javascript:document.forgotusername.submit()" style="text-decoration: none">
                          <font size="4" color="#FFFFFF">Forgotten your username?</font></a><font color="#FFFFFF" size="4">
                          <input type=hidden name="page" value="forgotusername">
                          </font></font>
</td>
</FORM>
                    </tr>
                    <tr>
                      <td width="100%" height="26">
                          <form name="forgotpassword" method=post action="mainpage.cgi">
                          <font face="Arial">
                          <a href="Javascript:document.forgotpassword.submit()" style="text-decoration: none">
                          <font size="4" color="#FFFFFF">Forgotten your password?</font></a><font size="4" color="#FFFFFF">
                          <input type=hidden name="page" value="forgotpassword">
                          </font></font>
</td>
</FORM>
                    </tr>
                    <tr>
                      <td width="100%" height="26">
                          <form name="registeraccount2" method=post action="mainpage.cgi">
                          <font face="Arial">
                          <a href="Javascript:document.registeraccount2.submit()" style="text-decoration: none">
                          <font size="4" color="#FFFFFF">Not signed up for an account yet?</font></a><font size="4" color="#FFFFFF">
                          <input type=hidden name="page" value="registeraccount">
                          </font></font>
</td>
</FORM>
                    </tr>
                  </table>
                  </center>
                </div>
TROUBLE
	}
	elsif($page eq "sitemap"){
	 print <<SITEMAP;
<p align="center">
<font size="5" color="#FFFFFF">Sitemap</font><p align="center">
<div align="center">
  <center>
  <table border="0" cellpadding="3" style="border-collapse: collapse" bordercolor="#111111" width="60%">
    <tr>
    <form name="sitemaphome" method="post" action="mainpage.cgi">
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.sitemaphome.submit()">
      <font color="#000080">Home</font></a></font></td>
      <input type=hidden name="page" value="home">
      </form>
    </tr>
    <tr>
    <form name="sitemapoverview" method="post" action="mainpage.cgi">
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.sitemapoverview.submit()">
      <font color="#000080">Overview</font></a></font></td>
      <input type=hidden name="page" value="overview">
      </form>
    </tr>
    <tr>
    <form name="sitemapsiteinfo" method="post" action="mainpage.cgi">
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.sitemapsiteinfo.submit()">
      <font color="#000080">Site Information</font></a></font></td>
      <input type=hidden name="page" value="siteinfo">
      </form>
    </tr>
    <tr>
    <form name="sitemaprelatedwebsites" method="post" action="mainpage.cgi">
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.sitemaprelatedwebsites.submit()">
      <font color="#000080">Related Websites</font></a></font></td>
      <input type=hidden name="page" value="relatedwebsites">
      </form>
    </tr>
    <tr>
    <form name="sitemapsamplescreenshots" method="post" action="mainpage.cgi">
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.sitemapsamplescreenshots.submit()">
      <font color="#000080">Sample Screenshots</font></a></font></td>
      <input type=hidden name="page" value="samplescreenshots">
      </form>
    </tr>
    <tr>
    <form name="sitemapcontactus" method="post" action="mainpage.cgi">
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.sitemapcontactus.submit()">
      <font color="#000080">Contact us</font></a></font></td>
      <input type=hidden name="page" value="contactus">
      </form>
    </tr>
    <tr>
      <td width="100%" align="center"><font size="4" color="#000080"><a href="Javascript:document.logout.submit()"> 
      <font color="#000080">Logout</font></a></font></td>
    </tr>
  </table>
  </center>
SITEMAP
	}
	elsif($page eq "contactus"){
	 print <<CONTACTUS;
<br>
<p>
                <center>
                <font color="#FFFFFF" style="font-size: 16pt; font-weight:700">Contact us</font><p>Questions or comments?&nbsp; Please fill out 
                our form.
                </center>
                <div align="center">
                  <center>
                  <table border="0" cellpadding="0" style="border-collapse: collapse" bordercolor="#111111" width="66%" cellspacing="0" height="40">
                    <tr>
<form name="contactus2" method=post action="contactus.cgi">
                      <td width="46%" align="right" height="10"></td>
                      <td width="54%" height="10"></td>
                    </tr>
                    <tr>
                      <td width="46%" align="right" height="23">Your name:</td>
                      <td width="54%" height="23">&nbsp;<input type=text name="yourname" size="20"></td>
                    </tr>
                    <tr>
                      <td width="46%" align="right" height="23">Your email 
                      address:</td>
                      <td width="54%" height="23">&nbsp;<input type=text name="youremail" size="20"></td>
                      
                    </tr>
                    <tr>
                      <td width="46%" align="right" height="5"></td>
                      <td width="54%" height="5"></td>
                    </tr>
                    <tr>
                    
                      </tr>
                    </table>
                  
                  <textarea name="message" cols=35 rows=6></textarea>

                  <div align="center">
                    <center>
                    <table border="0" cellpadding="4" style="border-collapse: collapse" bordercolor="#111111" width="30%" cellspacing="4">
                      <tr>
                        <td width="50%">
                        <p align="center">&nbsp; <input name="submit" type="submit" value="Send" style="width: 50; height: 24; font-size: 15px"></td>
                        <td width="50%">
                        <p align="center">&nbsp;<input name="reset" type="reset" value="Reset" style="width: 50; height: 24; font-size: 15px"></td>
</FORM>
                      </tr>
                    </table>
                    </center>
                  </div>
                 
                  
                  </center>
CONTACTUS
	}
	elsif($page eq "forgotpassword"){
	 print <<FORGOTPASSWORD;
<form method=post action="forgotpassword.cgi">
                  <p align="center">
                  <font style="font-size: 16pt; font-weight: 700" color="#FFFFFF">
                  Forgot your password?</font></p>


                  <div align="center">
                    <center>
                    <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="75%">
                      <tr>
                        <td width="100%">
                        <blockquote>
                          <p align="left"><font size="4">To reset your password, 
                          please fill out the following form and then click <b>
                          Continue</b>.</font></p>
                        </blockquote>
                        <div align="center">
                          <center>
                          <table border="0" cellpadding="2" style="border-collapse: collapse" bordercolor="#111111" width="85%">
                            <tr>
                              <td width="43%" align="right">
                              <font style="font-size: 13pt">Your username:</font></td>
                              <td width="57%">&nbsp;&nbsp;<input type=text name="username" size="20"></td>
                            </tr>
                            <tr>
                              <td width="43%" align="right">
                              <font style="font-size: 13pt">Your email address:</font></td>
                              <td width="57%">&nbsp;&nbsp;<input type=text name="emailaddress" size="20"></td>
                            </tr>
                          </table>
                          
                          </center>
                        </div>
<br>
                        <center>

                        <input type=submit value="Continue" name=submit style="width: 80; height: 24; font-size: 15px">
                        </center>
</FORM>
                        </td>
                      </tr>
                    </table>
                    </center>
                </div>

FORGOTPASSWORD
	}
	elsif($page eq "forgotusername"){
	 print <<FORGOTUSERNAME;
                <p align="center">
                <font style="FONT-WEIGHT: 700; FONT-SIZE: 16pt" color="#ffffff">
                Forgot your username?</font></p>
                <div align="center">
                  <center>
                  <table style="BORDER-COLLAPSE: collapse" borderColor="#111111" cellSpacing="0" cellPadding="0" width="75%" border="0">
                    <tr>
                <form action="forgotusername.cgi" method="post" name="forgotusername">
                      <td width="100%">
                      <blockquote>
                        <p align="left"><font size="4">To find your username, 
                        please fill out the following form and then click <b>
                        Continue</b>.</font></p>
                      </blockquote>
                      <div align="center">
                        <center>
                        <table style="BORDER-COLLAPSE: collapse" borderColor="#111111" cellPadding="2" width="85%" border="0">
                          <tr>
                            <td align="right" width="43%">
                            <font style="FONT-SIZE: 13pt">Your email address:</font></td>
                            <td width="57%">&nbsp;&nbsp;<input type=text name="emailaddress" size="20"></td>
                          </tr>
                          <tr>
                            <td align="right" width="43%">
                            <font style="FONT-SIZE: 13pt">Your password:</font></td>
                            <td width="57%">&nbsp;&nbsp;<input type=password name="password" size="20"></td>
                          </tr>
                        </table>
                        </center>
                      </div>
                      <center>
                      <p>
                      <input style="FONT-SIZE: 15px; WIDTH: 80px; HEIGHT: 24px" type="submit" value="Continue" name="submit">
                      </p>
                      </center>
                      </td>
</FORM>
                    </tr>
                  </table>
                  </center>
                </div>
FORGOTUSERNAME
	}
    
  }
print "$line";
}

close MAINPAGE;
exit(0);
