#!/usr/bin/perl
#=========================================================================
#Filename: hintgenerator.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a chapter number, exercise number, question number, and question
#  as CGI parameters.  The script first parses the question and looks for
#  word components.  Next the script records all word components in an array
#  to help in processing the data.  Then the script opens the glossary file
#  and searches each line of the glossary to find the definitions of the
#  components.  The script stores the definitions in a separate array and 
#  uses the word components and definitions in these arrays to construct
#  hints about the question.  Finally, the script prints out the chapter
#  number, exercise number, question number, question, and the hints in a
#  new window.  The script prints each hint in a small, new window so that
#  the student can see the exercise and the hint at the same time.  
#=========================================================================
use strict;
use CGI;
my $line;
my $q=new CGI;
my $chapter = $q->param('chapter');
my $exercise = $q->param('exercise');
my $questionnum=$q->param('questionnum');
my $question=$q->param('question');
my $answer1=$q->param('answer1');
my $answer2=$q->param('answer2');
my $answer3=$q->param('answer3');
my $answer4=$q->param('answer4');
my $counter=1;
my $numexercises;
my $concatenatedstring = $question . $answer1 . $answer2 . $answer3 . $answer4;
my @wordcomponent;
my @componentmeanings;
my $numwordcomponents=0;
my $numberfound=0;
my $componentmeaning="";
my $choppedletter="";

print "Content-type:text/html\n\n";

while ($concatenatedstring =~ /<wc>(.*?)<\/wc>/) { 
  my $temp=1;
  my $wordfound="false";
  while($temp <= $numwordcomponents){
    if( $1 eq $wordcomponent[$temp]){
      $wordfound="true";
    }
      $temp++;
  }  
  if($wordfound eq "false"){
  $wordcomponent[$counter] = $1; 
  $numwordcomponents++;
  $counter++;
  }
  $concatenatedstring =~ s/<wc>//;
  $concatenatedstring =~ s/<\/wc>//;
} 

$question =~ s/<wc>//g;
$question =~ s/<\/wc>//g;
$answer1 =~ s/<wc>//g;
$answer1 =~ s/<\/wc>//g;
$answer2 =~ s/<wc>//g;
$answer2 =~ s/<\/wc>//g;
$answer3 =~ s/<wc>//g;
$answer3 =~ s/<\/wc>//g;
$answer4 =~ s/<wc>//g;
$answer4 =~ s/<\/wc>//g;

open(GLOSSARY, "glossary/glossary.txt");
while(($line=<GLOSSARY>)&&($numberfound<$numwordcomponents)){
  $componentmeaning="";
  $choppedletter="";
  $choppedletter=chop($line);
  while(($choppedletter ne ";") && ($line)){
    $choppedletter=chop($line);
    if ($choppedletter ne ";"){
      $componentmeaning=$choppedletter . $componentmeaning;
    } #end if
  } #end chopped letter
  for(my $i=1; $i<=$numwordcomponents; $i++){
    if($line eq $wordcomponent[$i]){
      if(!$componentmeanings[$i]) {
        $numberfound++;
      }
     $componentmeaning=substr($componentmeaning, 1);
           $componentmeanings[$i] = $componentmeaning;
    }
  } #end for 
} #end line=glossary

print<<TOP;
<html>
<head>
<title>MostWise.com Hint for Question $questionnum</title>
</head>
<body bgcolor="#EFEBEF" onLoad="resizeTo(screen.availWidth*.37, screen.availHeight*.35); moveTo(screen.availWidth*.6, screen.availHeight*.05)">
<p align="center">
<img border="0" src="../images/mostwise5.jpg" width="292" height="42"></p>
<p align="center"><font face="Arial" size="4">MostWise.com Exercise Hints</font>
<br><b>Chapter $chapter, Exercise $exercise, Question $questionnum</b></p>
<blockquote>
  <b> $questionnum. </b>$question<p>
TOP

if($numwordcomponents>=1){
  print <<HINTPART;
  <b>Hint</font></b>
  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="90%">
  <tr>
      <td width="25%"><p align="left">Remember that:</td>
HINTPART
  


  for(my $j=1; $j<=$numwordcomponents; $j++){
      if ($j eq "1") {
        print "<td width=\"75%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>";
      }
      else{
        print "<tr><td width=\"25%\">&nbsp;&nbsp;</td><td width=\"75%\"><p align=\"left\"><i>$wordcomponent[$j]</i> means \"$componentmeanings[$j]\"</td></tr>"; 
      }
  }
  print "</table>";
}
else{
  print "<b>No hint could be generated.</b>";
}
print <<BOTTOM;
</blockquote>
</body>
</html>
BOTTOM
exit(0);
