#!/usr/bin/perl
#=========================================================================
#Filename: deleteexercise.cgi
#Written By: Trevor Barnett
#File Description:
#  An interface for deleting exercise files.  The script first displays a
#  table of chapters in the teacher webpage template.  The teacher clicks
#  on a chapter and JavaScript on the page submits a form targeted at this
#  script.  The form contains the chapter number selected by the user and
#  passes this number as a parameter of CGI.  When the script receives this
#  new information it does not display the table of chapters again because
#  the chapter number is not null.  Instead, it searches through the chapter
#  folder and finds all the exercises that exist in that chapter.  The script
#  displays the names of these exercises in a table.  When the teacher clicks
#  on an exercises name, the script prints a Confirm Delete screen.  This
#  screen warns the teacher that they are about to permanently delete an
#  exercise.  The teacher must then click the Delete Exercise button to
#  delete the exercise.  When the teacher presses this button, the script
#  uses the Perl unlink() function to remove the file from the system.  After
#  the script deletes the file it prints an Exercise Deleted screen and exits.
#=========================================================================
use strict;
use CGI;
my $line;
my $q=new CGI;
my $chapter = $q->param('chapter');
my $exercise= $q->param('exercise');
my $confirmed= $q->param('confirmed');
my $exercisenum=1;
my $numexercise=0;
my $exercisecounter=1;

print "Content-type:text/html\n\n";

open(MAINPAGE, "teacher.html");
while($line=<MAINPAGE>){
  if($line eq "<!--MAIN--!>\n"){
if(!$chapter){
print <<DELETEEXERCISES;
<form method=post action="deleteexercise.cgi" name="chapter1">
<input type=hidden name="chapter" value="1">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter2">
<input type=hidden name="chapter" value="2">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter3">
<input type=hidden name="chapter" value="3">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter4">
<input type=hidden name="chapter" value="4">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter5">
<input type=hidden name="chapter" value="5">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter6">
<input type=hidden name="chapter" value="6">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter7">
<input type=hidden name="chapter" value="7">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter8">
<input type=hidden name="chapter" value="8">
</FORM>
<form method=post action="deleteexercise.cgi" name="chapter9">
<input type=hidden name="chapter" value="9">
</FORM>

<div align="center"><b><font size="5" color="#FFFFFF">Delete Exercise </font>
  </b>
  <p><b><font size="4" color="#000080">Select a chapter</font></b></p>
  <center>
  <table border="0" cellspacing="3" style="border-collapse: collapse" bordercolor="#111111" width="75%" cellpadding="3">
    <tr>

      <td width="50%" align="center"><b><a href="Javascript:document.chapter1.submit()">
      <font size="4" color="#000080">Chapter 1</font></a></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter6.submit()">
      <font color="#000080">Chapter 6</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter2.submit()">
      <font color="#000080">Chapter 2</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter7.submit()">
      <font color="#000080">Chapter 7</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter3.submit()">
      <font color="#000080">Chapter 3</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter8.submit()">
      <font color="#000080">Chapter 8</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter4.submit()">
      <font color="#000080">Chapter 4</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter9.submit()">
      <font color="#000080">Chapter 9</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter5.submit()">
      <font color="#000080">Chapter 5</font></a></font></b></td>
      <td width="50%" align="center">&nbsp;</td>
    </tr>
  </table>
  </center>
DELETEEXERCISES
}
elsif(!$exercise){
#there is a chapter, we need to get the exercises for that chapter
   while((!(-e "chapter$chapter/exercise$exercisenum.txt")) && ($exercisenum<100)){
    $exercisenum++;
   }
  while(-e "chapter$chapter/exercise$exercisenum.txt"){
    print "<form method=post action=\"deleteexercise.cgi\" name=\"exercise$exercisenum\">";
    print "<input type=hidden name=\"chapter\" value=\"$chapter\">";
    print "<input type=hidden name=\"exercise\" value=\"$exercisenum\">";
    print "</FORM>";
    $numexercise++;
    $exercisenum++;
    while((!(-e "chapter$chapter/exercise$exercisenum.txt")) && ($exercisenum<100)){
      $exercisenum++;
    }
  }
  print <<TOPPART;
  <div align="center"><b><font size="5" color="#FFFFFF">Delete Exercise </font>
  </b>
  <p><font size="4" color="#000080"><b>Exercises in Chapter $chapter</b></font></p>
  <center>
TOPPART
if($numexercise eq "0"){
  print "<p><font size=\"4\" color=\"#000080\"><b>No exercises available for this chapter.</b></font></p>";
}
else{
  print "<table border=\"0\" cellspacing=\"3\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"68%\" cellpadding=\"3\">";
  while((!(-e "chapter$chapter/exercise$exercisecounter.txt")) && ($exercisecounter<100)){
    $exercisecounter++;
  }
  while(-e "chapter$chapter/exercise$exercisecounter.txt"){
    print "<tr><td width=\"50%\" align=\"center\"><b><a href=\"Javascript:document.exercise$exercisecounter.submit()\">";
    print "<font size=\"4\" color=\"#000080\">Delete Exercise $exercisecounter</font></a></b></td>";
    $exercisecounter++;
    while((!(-e "chapter$chapter/exercise$exercisecounter.txt")) && ($exercisecounter<100)){
      $exercisecounter++;
    }
    if (-e "chapter$chapter/exercise$exercisecounter.txt"){
      print "<td width=\"50%\" align=\"center\"><b><a href=\"Javascript:document.exercise$exercisecounter.submit()\">";
      print "<font size=\"4\" color=\"#000080\">Delete Exercise $exercisecounter</font></a></b></td></tr>";
      $exercisecounter++;
      while((!(-e "chapter$chapter/exercise$exercisecounter.txt")) && ($exercisecounter<100)){
        $exercisecounter++;
      }
    } #end if
    else{
      print "<td width=\"50%\" align=\"center\"></td></tr>";      
    } #end else
} # end while
 print "</table></center>";
} #end else  
}# end elsif
elsif(!$confirmed){
#they have picked a chapter and an exercise and need to confirm the delete
print <<CONFIRMDELETE;
<p align="center">
<b><font size="5" color="#FFFFFF">Delete Exercise </font></b>               
<div align="center">
  <center>
  <table border="0" cellspacing="6" style="border-collapse: collapse" bordercolor="#111111" width="80%" cellpadding="6">
    <tr>
      <td width="100%">
<font size="4">You are about to <u>permanently</u> delete <b>Exercise $exercise</b>.</font>
      <p>
<font size="4">Please confirm that you wish to delete this exercise by clicking the
<b>DELETE EXERCISE $exercise</b> button.</font></td>
    </tr>
  </table>
  <form method=post action="deleteexercise.cgi" name="permanentlydelete">
  <input type=submit name=submit value="DELETE EXERCISE $exercise">
  <input type=hidden name=chapter value="$chapter">
  <input type=hidden name=exercise value="$exercise">
  <input type=hidden name=confirmed value="confirmed">
  </form>
  </center>
CONFIRMDELETE
}
else{
#delete that exercise and send them back to the chapter page
  unlink("chapter$chapter/exercise$exercise.txt");

    while((!(-e "chapter$chapter/exercise$exercisenum.txt")) && ($exercisenum<100)){
      $exercisenum++;
    }
    while(-e "chapter$chapter/exercise$exercisenum.txt"){
    print "<form method=post action=\"deleteexercise.cgi\" name=\"exercise$exercisenum\">";
    print "<input type=hidden name=\"chapter\" value=\"$chapter\">";
    print "<input type=hidden name=\"exercise\" value=\"$exercisenum\">";
    print "</FORM>";
    $numexercise++;
    $exercisenum++;
    while((!(-e "chapter$chapter/exercise$exercisenum.txt")) && ($exercisenum<100)){
      $exercisenum++;
    }
  }
  print <<TOPPART;
  <div align="center"><b><font size="5" color="#FFFFFF">Exercise Deleted</font>
  </b>
  <p><font size="4" color="#000080"><b>Remaining Exercises in Chapter $chapter</b></font></p>
  <center>
TOPPART
if($numexercise eq "0"){
  print "<p><font size=\"4\" color=\"#000080\"><b>No exercises available for this chapter.</b></font></p>";
}
else{
  print "<table border=\"0\" cellspacing=\"3\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"68%\" cellpadding=\"3\">";
  while((!(-e "chapter$chapter/exercise$exercisecounter.txt")) && ($exercisecounter<100)){
    $exercisecounter++;
  }
  while(-e "chapter$chapter/exercise$exercisecounter.txt"){
    print "<tr><td width=\"50%\" align=\"center\"><b><a href=\"Javascript:document.exercise$exercisecounter.submit()\">";
    print "<font size=\"4\" color=\"#000080\">Delete Exercise $exercisecounter</font></a></b></td>";
    $exercisecounter++;
    while((!(-e "chapter$chapter/exercise$exercisecounter.txt")) && ($exercisecounter<100)){
      $exercisecounter++;
    }
    if (-e "chapter$chapter/exercise$exercisecounter.txt"){
      print "<td width=\"50%\" align=\"center\"><b><a href=\"Javascript:document.exercise$exercisecounter.submit()\">";
      print "<font size=\"4\" color=\"#000080\">Delete Exercise $exercisecounter</font></a></b></td></tr>";
      $exercisecounter++;
      while((!(-e "chapter$chapter/exercise$exercisecounter.txt")) && ($exercisecounter<100)){
        $exercisecounter++;
      }
    } #end if
    else{
      print "<td width=\"50%\" align=\"center\"></td></tr>";      
    } #end else
} # end while
 print "</table></center>";
} #end else  
}
  } # end of if line eq <!--main--!>
  print "$line";
} # end of while loop

close MAINPAGE;
exit(0);
