#!/usr/bin/perl
#=========================================================================
#Filename: createexercise.cgi
#Written By: Trevor Barnett
#File Description:
#  Generates and displays different pages to be used to create an exercise.
#  When first accessed, no chapter is given to the script as a CGI parameter.
#  If the chapter variable is null, the script opens the teacher webpage 
#  template and prints a table of chapter links in the main area.  When the
#  teacher clicks one of these links, JavaScript on the page submits a form
#  that is targeted to this script.  This form contains hidden information
#  about the chapter number that the teacher selects.  When the teacher
#  accesses the script this time, the chapter variable is not null, so the
#  script does not print out the table of chapters again.  Instead, the script
#  opens the teacher template and prints a choice of methods for creating an
#  exercise.  The teacher has the choice of creating the exercise by using
#  an online form or by uploading a text file that is written in the
#  predefined standard for exercise files.  If the teacher chooses to
#  upload the file, the script accepts the file as a CGI parameter, creates
#  a new exercise file under the chosen chapter, and prints out a success
#  page.  However, if the teacher chooses to create the exercise by using an
#  online form, then JavaScript again submits an online form with the chapter
#  information and the teachers choice as hidden parameters.  When the script
#  receives both the chapter and the choice as CGI parameters, it prints out
#  the online form for creating an exercise.  The script does this by opening
#  createexercisepage.html and printing its contents.  While the script is
#  printing the contents it also inserts some hidden fields before the </form>
#  tag.  These fields contain information like the chapter number and the users
#  choice that need to be remembered so that an old page is not displayed when
#  the form is submitted.   After the script prints the file content, the teacher
#  must fill out the form and press Submit Exercise to create the exercise.
#  The script stores the form information from CGI in arrays for easier processing.
#  It then formats the form information to comply with the predefined standard for
#  exercise files, and outputs it into a file.  The script names the file
#  exerciseX.txt, where X is the next available number (after 0) that is not taken.
#  After the script creates the new file, it prints a success page in the teacher
#  webpage template and exits.  
#=========================================================================
use strict; 
use CGI;
my $line;
my $q=new CGI;
my $chapter=$q->param('chapter');
my $choice=$q->param('choice');
my $counter=0;
my $onlineformsubmission=$q->param('onlineformsubmission');
my $file=$q->param('exercisefile');
my $tmpFilename = $q->tmpFileName($file);
my $line;
my $exercisename = "chapter$chapter/exercise";
my $exercisenum=1;
my $numberofquestions = $q->param('numberofquestions');
my $question1=$q->param('question1');
my $question2=$q->param('question2');
my $question3=$q->param('question3');
my $question4=$q->param('question4');
my $question5=$q->param('question5');
my $question6=$q->param('question6');
my $question7=$q->param('question7');
my $question8=$q->param('question8');
my $question9=$q->param('question9');
my $question10=$q->param('question10');
my $question11=$q->param('question11');
my $question12=$q->param('question12');
my $question13=$q->param('question13');
my $question14=$q->param('question14');
my $question15=$q->param('question15');
my $question16=$q->param('question16');
my $question17=$q->param('question17');
my $question18=$q->param('question18');
my $question19=$q->param('question19');
my $question20=$q->param('question20');
my $question21=$q->param('question21');
my $question22=$q->param('question22');
my $question23=$q->param('question23');
my $question24=$q->param('question24');
my $question25=$q->param('question25');

my $answer1=$q->param('answer1');
my $answer2=$q->param('answer2');
my $answer3=$q->param('answer3');
my $answer4=$q->param('answer4');
my $answer5=$q->param('answer5');
my $answer6=$q->param('answer6');
my $answer7=$q->param('answer7');
my $answer8=$q->param('answer8');
my $answer9=$q->param('answer9');
my $answer10=$q->param('answer10');
my $answer11=$q->param('answer11');
my $answer12=$q->param('answer12');
my $answer13=$q->param('answer13');
my $answer14=$q->param('answer14');
my $answer15=$q->param('answer15');
my $answer16=$q->param('answer16');
my $answer17=$q->param('answer17');
my $answer18=$q->param('answer18');
my $answer19=$q->param('answer19');
my $answer20=$q->param('answer20');
my $answer21=$q->param('answer21');
my $answer22=$q->param('answer22');
my $answer23=$q->param('answer23');
my $answer24=$q->param('answer24');
my $answer25=$q->param('answer25');

my $questiontype1=$q->param('questiontype1');
my $questiontype2=$q->param('questiontype2');
my $questiontype3=$q->param('questiontype3');
my $questiontype4=$q->param('questiontype4');
my $questiontype5=$q->param('questiontype5');
my $questiontype6=$q->param('questiontype6');
my $questiontype7=$q->param('questiontype7');
my $questiontype8=$q->param('questiontype8');
my $questiontype9=$q->param('questiontype9');
my $questiontype10=$q->param('questiontype10');
my $questiontype11=$q->param('questiontype11');
my $questiontype12=$q->param('questiontype12');
my $questiontype13=$q->param('questiontype13');
my $questiontype14=$q->param('questiontype14');
my $questiontype15=$q->param('questiontype15');
my $questiontype16=$q->param('questiontype16');
my $questiontype17=$q->param('questiontype17');
my $questiontype18=$q->param('questiontype18');
my $questiontype19=$q->param('questiontype19');
my $questiontype20=$q->param('questiontype20');
my $questiontype21=$q->param('questiontype21');
my $questiontype22=$q->param('questiontype22');
my $questiontype23=$q->param('questiontype23');
my $questiontype24=$q->param('questiontype24');
my $questiontype25=$q->param('questiontype25');

my $question1answer1 = $q->param('question1answer1');
my $question1answer2 = $q->param('question1answer2');
my $question1answer3 = $q->param('question1answer3');
my $question1answer4 = $q->param('question1answer4');

my $question2answer1 = $q->param('question2answer1');
my $question2answer2 = $q->param('question2answer2');
my $question2answer3 = $q->param('question2answer3');
my $question2answer4 = $q->param('question2answer4');

my $question3answer1 = $q->param('question3answer1');
my $question3answer2 = $q->param('question3answer2');
my $question3answer3 = $q->param('question3answer3');
my $question3answer4 = $q->param('question3answer4');

my $question4answer1 = $q->param('question4answer1');
my $question4answer2 = $q->param('question4answer2');
my $question4answer3 = $q->param('question4answer3');
my $question4answer4 = $q->param('question4answer4');

my $question5answer1 = $q->param('question5answer1');
my $question5answer2 = $q->param('question5answer2');
my $question5answer3 = $q->param('question5answer3');
my $question5answer4 = $q->param('question5answer4');

my $question6answer1 = $q->param('question6answer1');
my $question6answer2 = $q->param('question6answer2');
my $question6answer3 = $q->param('question6answer3');
my $question6answer4 = $q->param('question6answer4');

my $question7answer1 = $q->param('question7answer1');
my $question7answer2 = $q->param('question7answer2');
my $question7answer3 = $q->param('question7answer3');
my $question7answer4 = $q->param('question7answer4');

my $question8answer1 = $q->param('question8answer1');
my $question8answer2 = $q->param('question8answer2');
my $question8answer3 = $q->param('question8answer3');
my $question8answer4 = $q->param('question8answer4');

my $question9answer1 = $q->param('question9answer1');
my $question9answer2 = $q->param('question9answer2');
my $question9answer3 = $q->param('question9answer3');
my $question9answer4 = $q->param('question9answer4');

my $question10answer1 = $q->param('question10answer1');
my $question10answer2 = $q->param('question10answer2');
my $question10answer3 = $q->param('question10answer3');
my $question10answer4 = $q->param('question10answer4');

my $question11answer1 = $q->param('question11answer1');
my $question11answer2 = $q->param('question11answer2');
my $question11answer3 = $q->param('question11answer3');
my $question11answer4 = $q->param('question11answer4');

my $question12answer1 = $q->param('question12answer1');
my $question12answer2 = $q->param('question12answer2');
my $question12answer3 = $q->param('question12answer3');
my $question12answer4 = $q->param('question12answer4');

my $question13answer1 = $q->param('question13answer1');
my $question13answer2 = $q->param('question13answer2');
my $question13answer3 = $q->param('question13answer3');
my $question13answer4 = $q->param('question13answer4');

my $question14answer1 = $q->param('question14answer1');
my $question14answer2 = $q->param('question14answer2');
my $question14answer3 = $q->param('question14answer3');
my $question14answer4 = $q->param('question14answer4');

my $question15answer1 = $q->param('question15answer1');
my $question15answer2 = $q->param('question15answer2');
my $question15answer3 = $q->param('question15answer3');
my $question15answer4 = $q->param('question15answer4');

my $question16answer1 = $q->param('question16answer1');
my $question16answer2 = $q->param('question16answer2');
my $question16answer3 = $q->param('question16answer3');
my $question16answer4 = $q->param('question16answer4');

my $question17answer1 = $q->param('question17answer1');
my $question17answer2 = $q->param('question17answer2');
my $question17answer3 = $q->param('question17answer3');
my $question17answer4 = $q->param('question17answer4');

my $question18answer1 = $q->param('question18answer1');
my $question18answer2 = $q->param('question18answer2');
my $question18answer3 = $q->param('question18answer3');
my $question18answer4 = $q->param('question18answer4');

my $question19answer1 = $q->param('question19answer1');
my $question19answer2 = $q->param('question19answer2');
my $question19answer3 = $q->param('question19answer3');
my $question19answer4 = $q->param('question19answer4');

my $question20answer1 = $q->param('question20answer1');
my $question20answer2 = $q->param('question20answer2');
my $question20answer3 = $q->param('question20answer3');
my $question20answer4 = $q->param('question20answer4');

my $question21answer1 = $q->param('question21answer1');
my $question21answer2 = $q->param('question21answer2');
my $question21answer3 = $q->param('question21answer3');
my $question21answer4 = $q->param('question21answer4');

my $question22answer1 = $q->param('question22answer1');
my $question22answer2 = $q->param('question22answer2');
my $question22answer3 = $q->param('question22answer3');
my $question22answer4 = $q->param('question22answer4');

my $question23answer1 = $q->param('question23answer1');
my $question23answer2 = $q->param('question23answer2');
my $question23answer3 = $q->param('question23answer3');
my $question23answer4 = $q->param('question23answer4');

my $question24answer1 = $q->param('question24answer1');
my $question24answer2 = $q->param('question24answer2');
my $question24answer3 = $q->param('question24answer3');
my $question24answer4 = $q->param('question24answer4');

my $question25answer1 = $q->param('question25answer1');
my $question25answer2 = $q->param('question25answer2');
my $question25answer3 = $q->param('question25answer3');
my $question25answer4 = $q->param('question25answer4');

my @question=($question1, $question2,$question3,$question4,$question5,$question6,$question7,$question8,$question9,
                      $question10, $question11, $question12, $question13, $question14, $question15, $question16, $question17,
                      $question18, $question19, $question20, $question21,$question22,$question23,$question24,$question25);
my @answer1=($question1answer1, $question2answer1, $question3answer1, $question4answer1, $question5answer1, $question6answer1,
		 $question7answer1, $question8answer1, $question9answer1, $question10answer1, $question11answer1, $question12answer1,
		 $question13answer1, $question14answer1, $question15answer1, $question16answer1, $question17answer1, $question18answer1,
		 $question19answer1, $question20answer1, $question21answer1, $question22answer1, $question23answer1, $question24answer1,
		 $question25answer1);
my @answer2=($question1answer2, $question2answer2, $question3answer2, $question4answer2, $question5answer2, $question6answer2,
		 $question7answer2, $question8answer2, $question9answer2, $question10answer2, $question11answer2, $question12answer2,
		 $question13answer2, $question14answer2, $question15answer2, $question16answer2, $question17answer2, $question18answer2,
		 $question19answer2, $question20answer2, $question21answer2, $question22answer2, $question23answer2, $question24answer2,
		 $question25answer2);
my @answer3=($question1answer3, $question2answer3, $question3answer3, $question4answer3, $question5answer3, $question6answer3,
		 $question7answer3, $question8answer3, $question9answer3, $question10answer3, $question11answer3, $question12answer3,
		 $question13answer3, $question14answer3, $question15answer3, $question16answer3, $question17answer3, $question18answer3,
		 $question19answer3, $question20answer3, $question21answer3, $question22answer3, $question23answer3, $question24answer3,
		 $question25answer3);
my @answer4=($question1answer4, $question2answer4, $question3answer4, $question4answer4, $question5answer4, $question6answer4,
		 $question7answer4, $question8answer4, $question9answer4, $question10answer4, $question11answer4, $question12answer4,
		 $question13answer4, $question14answer4, $question15answer4, $question16answer4, $question17answer4, $question18answer4,
		 $question19answer4, $question20answer4, $question21answer4, $question22answer4, $question23answer4, $question24answer4,
		 $question25answer4);
my @questiontype=( $questiontype1,  $questiontype2, $questiontype3, $questiontype4, $questiontype5, $questiontype6, $questiontype7,
			 $questiontype8, $questiontype9, $questiontype10, $questiontype11, $questiontype12, $questiontype13, $questiontype14,
			 $questiontype15, $questiontype16, $questiontype17, $questiontype18, $questiontype19, $questiontype20, $questiontype21,
			 $questiontype22, $questiontype23, $questiontype24, $questiontype25);
my @answer=($answer1, $answer2, $answer3, $answer4, $answer5, $answer6, $answer7, $answer8, $answer9, $answer10, $answer11,
            $answer12, $answer13, $answer14, $answer15, $answer16, $answer17, $answer18, $answer19, $answer20, $answer21,
            $answer22, $answer23, $answer24, $answer25);

print "Content-type:text/html\n\n";

if(($choice eq "onlineform")&&(!$onlineformsubmission)&&($chapter)){
  while(-e "chapter$chapter/exercise$exercisenum.txt"){
     $exercisenum++;
  }
open(CREATEEXERCISE, "createexercisepage.html");
while($line = <CREATEEXERCISE>){
  if($line eq "<!--CHAPTERBANNER--!>\n"){
    print "Chapter $chapter Exercise $exercisenum";
  }
  if($line eq "</FORM>\n"){
    print "<input type=hidden name=chapter value=$chapter>";
  }
  print "$line";
}#end while
}#end if createexercise using online form
elsif($onlineformsubmission){ 
     while(-e "chapter$chapter/exercise$exercisenum.txt"){
       $exercisenum++;
     }
     $exercisename = $exercisename . $exercisenum . ".txt";
     open(OUTFILE, ">$exercisename");
     print OUTFILE "$numberofquestions\n";
     while($counter<$numberofquestions+1){
       if($question[$counter]){
          if($questiontype[$counter] eq "truefalse"){
            print OUTFILE "<TF>\n";
            print OUTFILE "$question[$counter]\n";
            print OUTFILE "$answer[$counter]\n";
          }
          elsif($questiontype[$counter] eq "multiplechoice"){
            print OUTFILE "<MC>\n";
            print OUTFILE "$question[$counter]\n";
            print OUTFILE "$answer1[$counter]\n";
            print OUTFILE "$answer2[$counter]\n";
            print OUTFILE "$answer3[$counter]\n";
            print OUTFILE "$answer4[$counter]\n";
            print OUTFILE "$answer[$counter]\n";
          }
          elsif($questiontype[$counter] eq "fillintheblank"){
            print OUTFILE "<FIB>\n";
            print OUTFILE "$question[$counter]\n";
            print OUTFILE "$answer[$counter]\n";
          }
       }
       $counter++;
     }
     close(OUTFILE);
     chmod 0744, $exercisename or die "failed doing chmod on $exercisename";
     open(MAINMENU, "teachermainmenu.html");
     while($line = <MAINMENU>){
       print "$line";
     }
     close(MAINMENU);

} #end elsif
else{
open(MAINPAGE, "teacher.html");
while($line=<MAINPAGE>){
if($line eq "<!--MAIN--!>\n"){
if(!$chapter){
  print <<CHAPTERSELECTION;
<form method=post action="createexercise.cgi" name="chapter1">
<input type=hidden name="chapter" value="1">
</FORM>
<form method=post action="createexercise.cgi" name="chapter2">
<input type=hidden name="chapter" value="2">
</FORM>
<form method=post action="createexercise.cgi" name="chapter3">
<input type=hidden name="chapter" value="3">
</FORM>
<form method=post action="createexercise.cgi" name="chapter4">
<input type=hidden name="chapter" value="4">
</FORM>
<form method=post action="createexercise.cgi" name="chapter5">
<input type=hidden name="chapter" value="5">
</FORM>
<form method=post action="createexercise.cgi" name="chapter6">
<input type=hidden name="chapter" value="6">
</FORM>
<form method=post action="createexercise.cgi" name="chapter7">
<input type=hidden name="chapter" value="7">
</FORM>
<form method=post action="createexercise.cgi" name="chapter8">
<input type=hidden name="chapter" value="8">
</FORM>
<form method=post action="createexercise.cgi" name="chapter9">
<input type=hidden name="chapter" value="9">
</FORM>

<div align="center"><b><font size="5" color="#FFFFFF">Create an Exercise </font>
  </b>
  <p><b><font size="4" color="#000080">Select a chapter</font></b></p>
  <center>
  <table border="0" cellspacing="3" style="border-collapse: collapse" bordercolor="#111111" width="75%" cellpadding="3">
    <tr>

      <td width="50%" align="center"><b><a href="Javascript:document.chapter1.submit()">
      <font size="4" color="#000080">Chapter 1</font></a></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter6.submit()">
      <font color="#000080">Chapter 6</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter2.submit()">
      <font color="#000080">Chapter 2</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter7.submit()">
      <font color="#000080">Chapter 7</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter3.submit()">
      <font color="#000080">Chapter 3</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter8.submit()">
      <font color="#000080">Chapter 8</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter4.submit()">
      <font color="#000080">Chapter 4</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter9.submit()">
      <font color="#000080">Chapter 9</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter5.submit()">
      <font color="#000080">Chapter 5</font></a></font></b></td>
      <td width="50%" align="center">&nbsp;</td>
    </tr>
  </table>
  </center>
CHAPTERSELECTION
}
elsif(!$choice){
print <<CREATEOPTION;
<b><font size="5" color="#FFFFFF"><div align="center"> Exercises</font></b><br>
  <center>
  <table border="0" cellspacing="4" style="border-collapse: collapse" bordercolor="#111111" width="63%" cellpadding="4">
    <tr>
      <td width="100%">  
<font size="4" color="#000080"> 
<form method=post action="createexercise.cgi" name="onlineform" target="_top">
<input type=hidden name=chapter value="$chapter">
<input type=hidden name=choice value="onlineform">
</form>              
</font>
<font size="4">            
<b>Create an exercise for <u>Chapter $chapter</u> using one of the below methods</b></font><p align="left"><font size="4">1. <a href="Javascript:document.onlineform.submit()">
<font color="#000080">Create an exercise using an online form</font></a></font></p>
      <p align="center"><b><font size="4">OR</font></b></p>
      <p align="left"><font size="4">2. Create an exercise by uploading a file</font></p>
<form method=post action="createexercise.cgi" ENCTYPE="multipart/form-data">
<table border=3 align="center">
<tr>
<td>Exercise file:<input name="exercisefile" type="file" size="20"></td>
</tr>
</table>
<center><br>
<input type="submit" name="sendfile" value="Send the File"> </center>
<input type=hidden name=chapter value="$chapter">
<input type=hidden name=choice value="uploadfile">
</FORM>
      </td>
    </tr>
  </table>
  </center>
</div>
CREATEOPTION
} #end create option else
elsif($choice eq "uploadfile"){
  if((substr($file, -3, 3) eq "txt") || (substr($file, -3, 3) eq "TXT")){
     while(-e "chapter$chapter/exercise$exercisenum.txt"){
       $exercisenum++;
     }
     $exercisename = $exercisename . $exercisenum . ".txt";
    open(READFILE, "$tmpFilename");
    open(OUTFILE, ">$exercisename");
    while (<READFILE>){
      print OUTFILE $_;
    }
    close(READFILE);
    close(OUTFILE);
    chmod 0744, $exercisename or die "failed doing chmod on $exercisename";
      print <<SUCCESS;
       <p align="center"><font size="5" color="#FFFFFF">Exercise Created</font>
       <p align="center"><font size="4"> Exercise $exercisenum was successfully posted.</font>
SUCCESS

  } #end of checking to see it ends with .txt
  elsif(!$file){
       print <<ERROR;
          <b><font size="5" color="#FF0000">   <p align="center"> Error!</p></font></b>
          <font size="4"><p align="center">You did not submit a file.</p></font>
ERROR
  }
  else{
print <<ERROR;
  <b><font size="5" color="#FF0000">   <p align="center"> Error!</p></font></b>
  <font size="4"><p align="center">You have submitted the wrong type of file.<br> You must submit a .txt file.</p></font>
ERROR
  } #end of wrong file type
} # end of file submission through uploading
}#end main
print "$line";
}#end while

close (MAINPAGE);
}
exit(0);
