#!/usr/bin/perl
#=========================================================================
#Filename: contactus.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a name, email address, and message as CGI inputs.  This script 
#  then uses sendmail to send the message from the email address to all 
#  MostWise administrators in the database.  
#
#=========================================================================
require 'cookielib/cookie.lib'; #require cookie library
use CGI; #use Common Gateway Interface module
my $q=new CGI; #CGI variable
my $youremail=$q->param('youremail'); #email address accepted as CGI input
my $yourname=$q->param('yourname'); #name accepted as CGI input
my $message=$q->param('message'); #message accepted as CGI input
my $line; #contains a line of input from a webpage template
my $name; #name stored in cookie
my $type; #type stored in cookie
my $id; #id stored in cookie

#get the information out of the cookie
if((&GetCookies('name'))&&(&GetCookies('userid'))&&(&GetCookies('usertype'))){
  $name=$Cookies{'name'};
  $type=$Cookies{'usertype'};
  $id=$Cookies{'userid'};
} 

#send that email
if(($youremail)&&($yourname)) {
open(MAIL, "| /usr/sbin/sendmail -oi -n -t");
print MAIL <<MAIL_MESSAGE;
To:mostwise\@mostwise.com
From:$youremail
Subject:$yourname has contacted MostWise.com

$message
MAIL_MESSAGE
close MAIL;

#print post-email page
print "Content-type:text/html\n\n";
#check the type of the user
if(!$type){
  open(SUCCESS, "home.html");
}
elsif($type eq "administrator"){
  open(SUCCESS, "administrator.html");
}
elsif($type eq "teacher"){
  open(SUCCESS, "teacher.html");
}
elsif($type eq "student"){
  open(SUCCESS, "student.html");
}

while($line=<SUCCESS>){
  print "$line";
  if($line eq "<!--MAIN--!>\n"){
    print<<SUCCESS;
                <p align="center"><font color="#FFFFFF">
                <span style="font-weight: 700; font-size: 16pt">Message 
                successfully sent</span></font></p>
                <div align="center">
                  <center>
                  <table border="0" cellpadding="4" style="border-collapse: collapse" bordercolor="#111111" width="60%" cellspacing="4">
                    <tr>
                      <td width="100%"><font size="4">Thank you for contacting 
                      MostWise.com.</font></td>
                    </tr>
                    <tr>
                      <td width="100%"><font size="4">We will try to respond as 
                      soon as possible.</font></td>
                    </tr>
                  </table>
                  </center>
SUCCESS
  }
}
}

else{
print "Content-type:text/html\n\n";
#check the type of the user
if(!$type){
  open(ERROR, "home.html");
}
elsif($type eq "administrator"){
  open(ERROR, "administrator.html");
}
elsif($type eq "teacher"){
  open(ERROR, "teacher.html");
}
elsif($type eq "student"){
  open(ERROR, "student.html");
}
while($line=<ERROR>){
  print "$line";
  if($line eq "<!--MAIN--!>\n"){
    print<<ERROR;
                <p align="center"><font color="#FFFFFF">
                <span style="font-size: 16pt; font-weight: 700">Error!</span></font></p>
                <div align="center">
                  <center>
                  <table border="0" cellpadding="3" style="border-collapse: collapse" bordercolor="#111111" width="80%" cellspacing="3">
                    <tr>
                      <td width="100%"><font size="4">Sorry you did not complete all the required fields.</font></td>
                    </tr>
                    <tr>
                      <td width="100%"><font size="4">Please use the <b><a href="javascript: history.go(-1)" >
                      <font color="#FFFFFF">Back</font></a></b> button on your browser and try again.
              
                </div>
                      </font></td>
                    </tr>
                  </table>
ERROR
  }
}
}
