#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: administrator.cgi
#Written By: Trevor Barnett
#File Description:
#  A simple script that accepts a page name as its only input from CGI.  
#  The script first checks the browsers cookie to make sure that the user 
#  is an administrator and has authorization to display the input page.  
#  If the user is legitimate, the script opens the administrator webpage 
#  template and prints the contents of this file until it finds the invisible 
#  comment used to mark the starting point of the main webpage area.  When 
#  this comment is reached, the script will print the HTML that should be 
#  displayed in the main area, based on the page name the script received 
#  from the form submission.  After the main area HTML has been printed, the 
#  script will then finish printing the remaining content of the webpage 
#  template HTML file.  Finally, the script will close the administrator.html 
#  file and exit.  This form is simple but critical to the operation of 
#  MostWise.  It is responsible for printing the HTML that transports the 
#  user around the website.
#=========================================================================
use strict;  #used to eliminate undeclared variables
use CGI;     #common gateway interface
my $line;    #contains a line of text from the administrator webapge template
my $q=new CGI; #CGI variable
my $page = $q->param('page'); #only input from CGI, it is the page user wishes to display

#content will be printed in HTML
print "Content-type:text/html\n\n";

#open the administrator page
open(ADMINPAGE, "administrator.html");
#print out all of administrator page
while($line=<ADMINPAGE>){
  #if page is logout page we must add the timer
  #timer will countdown 3 seconds before logging user out
  if($page eq "logout"){
    $line =~ s/BODY/Body onLoad="begintimer()"/;
  }
  #if we read in the special line of administrator page, then print appropriate page
  if($line eq "<!--MAIN--!>\n"){
      if($page eq "addtoglossary"){
       #print the "add to glossary" page
       print <<ADDTOGLOSSARY;
         <center><b><font color="#FFFFFF" size="4">Add To Glossary</font></b></center>
         <div align="center">
         <center>
         <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="75%">
         <tr>
         <form method=post action="addtoglossary.cgi" name="addtoglossary">
         <td width="50%" align="center"><b>Word Component</b></td>
         <td width="50%" align="center"><b>Component Meaning</b></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component1" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning1" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component2" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning2" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component3" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning3" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component4" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning4" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component5" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning5" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component6" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning6" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component7" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning7" size="35"></td>
         </tr>
         <tr>
         <td width="50%" align="center"><input type=text name="component8" size="15"></td>
         <td width="50%" align="center"><input type=text name="meaning8" size="35"></td>
         </tr>
         </table>
         </center>
         </div>
         <table height="5">
         <tr><td></td></tr></table>
         <center><input type="submit" name="submit" value="Add To Glossary">
         </FORM></center>
ADDTOGLOSSARY
      }
      elsif($page eq "changestudentpw"){
      #print the "change student password" html
      print <<CHANGESTUDENTPW;
         <p align="center">
         <b><font color="#FFFFFF" style="font-size: 16pt">Change Student Verification Password
         </font></b> </p>
         <div align="center">
         <center>
         <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
         <tr>
         <td width="100%"><font size="4">This utility will change the password 
         needed to create a student account.</font></td>
         </tr>
         </table>
         </center>
         </div>
         <div align="center">
         <center><br>
         <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%" height="134">
         <tr>
         <form method=post action="changestudentpassword.cgi">
         <td width="50%" align="right" height="23">Old Password:&nbsp;</td>
         <td width="50%" height="23">&nbsp;<input type=password name="oldpassword" size="20"></td>
         </tr>
         <tr>
         <td width="50%" align="right" height="23">New Password:&nbsp;</td>
         <td width="50%" height="23">&nbsp;<input type=password name="newpassword" size="20"></td>
         </tr>
         <tr>
         <td width="50%" align="right" height="23">Retype New Password:&nbsp;</td>
         <td width="50%" height="23">&nbsp;<input type=password name="retypepassword" size="20"></td>
         </tr>
         <tr>
         <td width="50%" height="53">
         <p align="center"><input type=reset name="reset" value="Clear Fields" style="width: 120; height: 22; font-size: 15px"></td>
         <td width="50%" height="53">
         <p align="center"><input type=submit name="submit" value="Change Password" style="width: 120; height: 22; font-size: 15px"></td>
         </FORM>
         </tr>
         </table>
         </center>
         </div>
CHANGESTUDENTPW
      }
      elsif($page eq "changeadminpw"){
       #print the change admin password html
       print <<CHANGEADMINPW;
         <p align="center">
         <b><font color="#FFFFFF" style="font-size: 16pt">Change Admin Verification Password
         </font></b> </p>
         <div align="center">
         <center>
         <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
         <tr>
         <td width="100%"><font size="4">This utility will change the password needed to create an 
         administrator account.</font></td>
         </tr>
         </table>
         </center>
         </div>
         <div align="center">
         <center><br>
         <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%" height="134">
         <tr>
         <form method=post action="changeadminpassword.cgi">
         <td width="50%" align="right" height="23">Old Password:&nbsp;</td>
         <td width="50%" height="23">&nbsp;<input type=password name="oldpassword" size="20"></td>
         </tr>
         <tr>
         <td width="50%" align="right" height="23">New Password:&nbsp;</td>
         <td width="50%" height="23">&nbsp;<input type=password name="newpassword" size="20"></td>
         </tr>
         <tr>
         <td width="50%" align="right" height="23">Retype New Password:&nbsp;</td>
         <td width="50%" height="23">&nbsp;<input type=password name="retypepassword" size="20"></td>
         </tr>
         <tr>
         <td width="50%" height="53">
         <p align="center"><input type=reset name="reset" value="Clear Fields" style="width: 120; height: 22; font-size: 15px"></td>
         <td width="50%" height="53">
         <p align="center"><input type=submit name="submit" value="Change Password" style="width: 120; height: 22; font-size: 15px"></td>
         </FORM>
         </tr>
         </table>
         </center>
         </div>
CHANGEADMINPW
      }
      elsif($page eq "changeteacherpw"){
       #print the "change teacher password" html
       print <<CHANGETEACHERPW;
        <p align="center">
        <b><font color="#FFFFFF" style="font-size: 16pt">Change Teacher Verification Password
        </font></b> </p>
        <div align="center">
        <center>
        <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
        <tr>
        <td width="100%"><font size="4">This utility will change the password 
        needed to create a teacher account.</font></td>
        </tr>
        </table>
        </center>
        </div>
        <div align="center">
        <center><br>
        <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%" height="134">
        <tr>
        <form method=post action="changeteacherpassword.cgi">
        <td width="50%" align="right" height="23">Old Password:&nbsp;</td>
        <td width="50%" height="23">&nbsp;<input type=password name="oldpassword" size="20"></td>
        </tr>
        <tr>
        <td width="50%" align="right" height="23">New Password:&nbsp;</td>
        <td width="50%" height="23">&nbsp;<input type=password name="newpassword" size="20"></td>
        </tr>
        <tr>
        <td width="50%" align="right" height="23">Retype New Password:&nbsp;</td>
        <td width="50%" height="23">&nbsp;<input type=password name="retypepassword" size="20"></td>
        </tr>
        <tr>
        <td width="50%" height="53">
        <p align="center"><input type=reset name="reset" value="Clear Fields" style="width: 120; height: 22; font-size: 15px"></td>
        <td width="50%" height="53">
        <p align="center"><input type=submit name="submit" value="Change Password" style="width: 120; height: 22; font-size: 15px"></td>
        </FORM>
        </tr>
        </table>
        </center>
        </div>
CHANGETEACHERPW
      }
      elsif($page eq "emailallusers"){
       #print the "Email all users" form
       print <<EMAILALLUSERS;
         <center>
         <p><font color="#FFFFFF">
         <span style="font-weight: 700; font-size: 16pt">Email All Users</span></font></p>
         <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%" height="38">
         <tr>
         <td width="100%" height="35"><font size="4">This form will 
         send an email to all registered users of MostWise.com.
         </font></td>
         </tr>
         </table>
         </center>
         <div align="center">
         <center>
         <table border="0" cellpadding="0" style="border-collapse: collapse" bordercolor="#111111" width="60%" cellspacing="0" height="40">
         <tr>
         <form method=post action="emailallusers.cgi">
         <td width="100%" align="right" height="10" colspan="2"></td>
         </tr>
         <tr>
         <td width="46%" align="right" height="23">Your name:</td>
         <td width="54%" height="23">&nbsp;<input type=text name="yourname" size="20"></td>
         </tr>
         <tr>
         <td width="46%" align="right" height="23">Your email 
         address:</td>
         <td width="54%" height="23">&nbsp;<input type=text name="youremail" size="20"></td>
         </tr>
         <tr>
         <td width="46%" align="right" height="5"></td>
         <td width="54%" height="5"></td>
         </tr>
         </table>
         <textarea name="message" cols=35 rows=6></textarea>
         <div align="center">
         <center>
         <table border="0" cellpadding="4" style="border-collapse: collapse" bordercolor="#111111" width="30%" cellspacing="4">
         <tr>
         <td width="50%">
         <p align="center">&nbsp; <input name="submit" type="submit" value="Send" style="width: 50; height: 24; font-size: 15px"></td>
         <td width="50%">
         <p align="center">&nbsp;<input name="reset" type="reset" value="Reset" style="width: 50; height: 24; font-size: 15px"></td>
         </FORM>
         </tr>
         </table>
         </center>
         </div>
         </center>
EMAILALLUSERS
      }
	elsif($page eq "logout"){
        #print the logout page
        print <<LOGOUT;
         <center>
         &nbsp;<p><font size="4">Attempting to log you out </font>
         <img border="0" src="../images/19anidot1c.gif">
         <img border="0" src="../images/19anidot1c.gif">
         <img border="0" src="../images/19anidot1c.gif">
         <img border="0" src="../images/19anidot1c.gif"></p>
         <p>&nbsp;</p></center>
         <script>
         var limit="0:3"
         if (document.images){
           var parselimit=limit.split(":")
           parselimit=parselimit[0]*60+parselimit[1]*1
         }
         function begintimer(){
         if (!document.images)
         return
         if (parselimit==1) {
         window.open("http://$URL/logout.html", target="_top")
         }
         else{ 
         parselimit-=1
         curmin=Math.floor(parselimit/60)
         cursec=parselimit%60
         if (curmin!=0)
         curtime=curmin+" minutes and "+cursec+" seconds left"
         else
         curtime=cursec+" seconds left"
         window.status=curtime
         setTimeout("begintimer()",1000)
         }
         }
         </script>
LOGOUT
	}
      elsif($page eq "changepassword"){
        #print the "Change Password" HTML
        print <<CHANGEPASSWORD;
          <form method=post action="changepassword.cgi">
          <p align="center"><b><font style="font-size: 16pt" color="#FFFFFF">Change 
          Password</font></b></p>
          <div align="center">
          <center>
          <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="70%">
          <tr>
          <td width="50%" align="right">Old Password:</td>
          <td width="50%">&nbsp;<input type=password name="oldpassword" size="20"></td>
          </tr>
          <tr>
          <td width="50%" align="right">New Password:</td>
          <td width="50%">&nbsp;<input type=password name="newpassword" size="20"></td>
          </tr>
          <tr>
          <td width="50%" align="right">Retype New Password:</td>
          <td width="50%">&nbsp;<input type=password name="retypepassword" size="20"></td>
          </tr>
          </table>
          <p>
          <input type=submit name=submit value="Change Password">
          </FORM>
          </center>
          </div>
          <p align="center">
          <br></p>
CHANGEPASSWORD
}
  } # end of if line eq <!--main--!>
print "$line";  #line contains text from administrator.html
} # end of while loop
close ADMINPAGE;  #close administrator page
exit(0); #exit the program 
