/*
SplashScreen.java
Initial screen in application.  Gives the user the choice to create a new logic grid or open an existing
logic grid.
 */

import javax.swing.*;
import java.io.*;
import java.util.Scanner;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.applet.*;

public class SplashScreen extends  javax.swing.JFrame {

    /** Creates new form SplashScreen */
    public SplashScreen() {

          BufferedImage image = null;
          
                try {
                       for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                           if ("Nimbus".equals(info.getName())) {
                               UIManager.setLookAndFeel(info.getClassName());
                              break;
                         }
                       }
                   } catch (Exception e) {
                      // If Nimbus is not available, set the GUI to another look and feel.
                  }
        
        
    
        try 
        
        {

            image = ImageIO.read(this.getClass().getResource("question-mark-red.jpg"));
        } catch (IOException e) {
            e.printStackTrace();
        }
     this.setIconImage(image);
    this.setTitle("Logic Puzzle Solver");

        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jFrame1 = new javax.swing.JFrame();
        jFrame2 = new javax.swing.JFrame();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        openexistinggridbut = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        createnewgridbutton = new javax.swing.JButton();

        javax.swing.GroupLayout jFrame1Layout = new javax.swing.GroupLayout(jFrame1.getContentPane());
        jFrame1.getContentPane().setLayout(jFrame1Layout);
        jFrame1Layout.setHorizontalGroup(
            jFrame1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jFrame1Layout.setVerticalGroup(
            jFrame1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jFrame2Layout = new javax.swing.GroupLayout(jFrame2.getContentPane());
        jFrame2.getContentPane().setLayout(jFrame2Layout);
        jFrame2Layout.setHorizontalGroup(
            jFrame2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jFrame2Layout.setVerticalGroup(
            jFrame2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jPanel1.setBackground(new java.awt.Color(255, 255, 204));
        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N

        jLabel1.setBackground(new java.awt.Color(204, 204, 204));
        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("Logic Puzzle Solver");

        openexistinggridbut.setText("Open Existing Grid");
        openexistinggridbut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openexistinggridbutActionPerformed(evt);
            }
        });

        jButton3.setText("Quit");
        jButton3.setMaximumSize(new java.awt.Dimension(123, 23));
        jButton3.setMinimumSize(new java.awt.Dimension(123, 23));
        jButton3.setPreferredSize(new java.awt.Dimension(123, 23));
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        createnewgridbutton.setText("Create New Grid");
        createnewgridbutton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createnewgridbuttonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(61, 61, 61)
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 235, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(98, 98, 98)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jButton3, javax.swing.GroupLayout.DEFAULT_SIZE, 151, Short.MAX_VALUE)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addComponent(openexistinggridbut, javax.swing.GroupLayout.DEFAULT_SIZE, 151, Short.MAX_VALUE)
                                .addComponent(createnewgridbutton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))))
                .addContainerGap(63, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(7, 7, 7)
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 62, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(28, 28, 28)
                .addComponent(createnewgridbutton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(openexistinggridbut)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(121, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void openexistinggridbutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openexistinggridbutActionPerformed
        //open file chooser
        jfc = new JFileChooser();
        jfc.setCurrentDirectory(new File("."));
        int result = jfc.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            loadfile(jfc.getSelectedFile());
        }
    }//GEN-LAST:event_openexistinggridbutActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
         System.exit(0);        // TODO add your handling code here:
    }//GEN-LAST:event_jButton3ActionPerformed

    private void createnewgridbuttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createnewgridbuttonActionPerformed
              //Create new gridscreen for logic grid configuration
        GridScreen gridscreen = new GridScreen(this);
        gridscreen.setExtendedState(MAXIMIZED_BOTH);
        gridscreen.setVisible(true);
        //hide homescreen
        this.setVisible(false);
    }//GEN-LAST:event_createnewgridbuttonActionPerformed

    /**
    * @param args the command line arguments
    */

     public void loadfile(File file) {
        int numofcat = 0;
        int numofopt = 0;
        int rowcount;

        try {
            Scanner scanner = new Scanner(file);
            if (scanner.hasNext()) {        

                //Read in number of categories
                numofcat = scanner.nextInt();
                //Read in number of options
                numofopt = scanner.nextInt();

                String[][] options = new String[numofcat][numofopt];
                String[] categorys = new String[numofcat];
                gridblock[][] gridregions = new gridblock[numofcat][];
                rowcount = numofcat - 1;

                //Go to next line
                scanner.nextLine();
                for (int i = 0; i < numofcat; ++i) {
                    //Read in category names
                    categorys[i] = scanner.nextLine();
                    gridregions[i] = new gridblock[rowcount];
                    --rowcount;
                }



                //Read in option names
                for (int i = 0; i < numofcat; ++i)
                {
                    for (int j = 0; j < numofopt; ++j)
                    {
                        options[i][j] = scanner.nextLine();
                            
                    }
                }

                int catindx = numofcat;
                //Create a new jagged array of gridblock objects and set each block within according
                //to the status read in from the file
                for (int i = 0; i < numofcat - 1; ++i) {
                    for (int j = 0; j < gridregions[i].length; ++j) {
                        gridregions[i][j] = new gridblock(numofopt, i, j, i, numofcat);

                        //Read in Block statuses for each block in gridregion(i,j)
                        for (int k = 0; k < numofopt; ++k){
                            for (int l = 0; l < numofopt; ++l)
                            {
                                //int status =999;
                               // JOptionPane.showMessageDialog(this, "K:  "+k+"L:  "+l+ "Status:  "+status);
                                int status = scanner.nextInt();
                                gridregions[i][j].myblocks[k][l].setblock(status);
                            }
                    }
                        --catindx;
                    }
                    catindx = numofcat;
                }

                //Create User control panel
                usercontrols = new UserControls(categorys, options);
                //Read in number of clues
                int cluebankcount = scanner.nextInt();
                scanner.nextLine();

                //Read in clue strings and add them to usercontrol panel cluebank
                for (int i = 0; i < cluebankcount; ++i)
                {
                    usercontrols.cluebank.add(scanner.nextLine());
                }


                //Read in number of clues in clue vector
                int cluescount = scanner.nextInt();

                //Instantiate a new maingrid object based on the data read from .lps file
                Maingrid maingrid = new Maingrid(numofcat, numofopt, gridregions, categorys, usercontrols, this);

                //Begin reading in clue list object

                java.util.List cluelist = null;
                FileInputStream instream_file = null;
                ObjectInputStream instream_obj = null;

                try {
                    //Open object file
                    instream_file = new FileInputStream(file.getName() + "_cluedata");
                    instream_obj = new ObjectInputStream(instream_file);

                    //Read in clue list file and store
                    cluelist = (java.util.ArrayList) instream_obj.readObject();
                    instream_obj.close();
                    //Set clue vector in main grid
                    maingrid.setclues(cluelist);
                    instream_file.close();

                } catch (IOException ex) {
                    ex.printStackTrace();
                } catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                } //end try/catch for .lps_cluedata object file opening

                maingrid.generategrid(options);
                maingrid.setExtendedState(Frame.MAXIMIZED_BOTH);
                maingrid.setVisible(true);
            }//if configuration text file (.lps file) is not empty

        } catch (IOException e) {
            JOptionPane.showMessageDialog(this, "File does not Exist");

        } //end try/catch for .lps text file opening

    }// end loadfile

    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SplashScreen().setVisible(true);
            }
        });
    }


    JFileChooser jfc = new JFileChooser();
    public UserControls usercontrols;
    public SplashScreen myhomescreen = this;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton createnewgridbutton;
    private javax.swing.JButton jButton3;
    private javax.swing.JFrame jFrame1;
    private javax.swing.JFrame jFrame2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton openexistinggridbut;
    // End of variables declaration//GEN-END:variables

}
