/*

Homescreen.java

Initial screen in application.  Gives the user the choice to create a new logic grid or open an existing

logic grid.

 */



import javax.swing.*;

import java.io.*;

import java.util.Scanner;

import java.awt.*;

import javax.imageio.ImageIO;

import java.awt.image.BufferedImage;



public class HomeScreen extends javax.swing.JFrame {



    /** Creates new form HomeScreen */

    public HomeScreen() {

         BufferedImage image = null;

        try {



            image = ImageIO.read(this.getClass().getResource("question-mark-red.jpg"));

        } catch (IOException e) {

            e.printStackTrace();

        }

       this.setIconImage(image);

       this.setTitle("Logic Puzzle Solver");



        initComponents();

    }



    @SuppressWarnings("unchecked")

    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents

    private void initComponents() {



        createNewGridbut = new javax.swing.JButton();

        openexistinggridbut = new javax.swing.JButton();

        button1 = new java.awt.Button();

        jLabel1 = new javax.swing.JLabel();



        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);



		//Create New Grid button and add action listeners

        createNewGridbut.setText("Create New Grid");

        createNewGridbut.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

                createNewGridbutActionPerformed(evt);

            }

        });



		//Create Open Existing Grid button and add action listeners

        openexistinggridbut.setText("Open Existing Grid");

        openexistinggridbut.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

                openexistinggridbutActionPerformed(evt);

            }

        });

		

		//Create QUIT button and add action listeners

        button1.setLabel("QUIT");

        button1.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

                button1ActionPerformed(evt);

            }

        });



        jLabel1.setFont(new java.awt.Font("Thorndale for VST", 1, 18)); // NOI18N

        jLabel1.setText("Logic Puzzle Solver");



        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());

        getContentPane().setLayout(layout);

        layout.setHorizontalGroup(

            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(layout.createSequentialGroup()

                .addGap(147, 147, 147)

                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)

                    .addComponent(createNewGridbut, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)

                    .addComponent(openexistinggridbut, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))

                .addContainerGap(132, Short.MAX_VALUE))

            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()

                .addContainerGap(182, Short.MAX_VALUE)

                .addComponent(button1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addGap(176, 176, 176))

            .addGroup(layout.createSequentialGroup()

                .addContainerGap()

                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 164, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(228, Short.MAX_VALUE))

        );

        layout.setVerticalGroup(

            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(layout.createSequentialGroup()

                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 52, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addGap(48, 48, 48)

                .addComponent(createNewGridbut)

                .addGap(18, 18, 18)

                .addComponent(openexistinggridbut)

                .addGap(31, 31, 31)

                .addComponent(button1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(81, Short.MAX_VALUE))

        );



        pack();

    }// </editor-fold>//GEN-END:initComponents



    private void createNewGridbutActionPerformed(java.awt.event.ActionEvent evt) {



        //Create new gridscreen for logic grid configuration

        GridScreen gridscreen = new GridScreen(this);

        gridscreen.setExtendedState(MAXIMIZED_BOTH);

        gridscreen.setVisible(true);

        //hide homescreen

        this.setVisible(false);



    }//end event_createNewGridbutActionPerformed



    private void openexistinggridbutActionPerformed(java.awt.event.ActionEvent evt) {



        //open file chooser

        jfc = new JFileChooser();

        int result = jfc.showOpenDialog(null);

        if (result == JFileChooser.APPROVE_OPTION) {

            loadfile(jfc.getSelectedFile());

        }



    }//end event_openexistinggridbutActionPerformed



    private void button1ActionPerformed(java.awt.event.ActionEvent evt) {

        //Exit Application

        System.exit(0);

    }//endevent_button1ActionPerformed



    public void loadfile(File file) {

        int numofcat = 0;

        int numofopt = 0;

        int rowcount;



        try {

            Scanner scanner = new Scanner(file);

            if (scanner.hasNext()) {



                //Read in number of categories

                numofcat = scanner.nextInt();

                //Read in number of options

                numofopt = scanner.nextInt();



                String[][] options = new String[numofopt][numofopt];

                String[] categorys = new String[numofcat];

                gridblock[][] gridregions = new gridblock[numofcat][];

                rowcount = numofcat - 1;



                //Go to next line

                scanner.nextLine();

                for (int i = 0; i < numofcat; ++i) {

                    //Read in category names

                    categorys[i] = scanner.nextLine();

                   

                    gridregions[i] = new gridblock[rowcount];

                    --rowcount;

                }

                

      

             

                //Read in option names

                for (int i = 0; i < numofopt; ++i) 

                    for (int j = 0; j < numofopt; ++j)

                    {

                        options[i][j] = scanner.nextLine();

                       

                        }

           

                int catindx = numofcat;

                //Create a new jagged array of gridblock objects and set each block within according

                //to the status read in from the file

                for (int i = 0; i < numofcat - 1; ++i) {

                    for (int j = 0; j < gridregions[i].length; ++j) {

                        gridregions[i][j] = new gridblock(numofopt, i, j, i, numofcat);



                        //Read in Block statuses for each block in gridregion(i,j)

                        for (int k = 0; k < numofopt; ++k) 

                            for (int l = 0; l < numofopt; ++l) 

                                gridregions[i][j].myblocks[k][l].setblock(scanner.nextInt());

                                               

                        --catindx;

                    }

                    catindx = numofcat;

                }



                //Create User control panel

                usercontrols = new UserControls(categorys, options);

                //Read in number of clues

                int cluebankcount = scanner.nextInt();

                scanner.nextLine();



                //Read in clue strings and add them to usercontrol panel cluebank

                for (int i = 0; i < cluebankcount; ++i) 

                    usercontrols.cluebank.add(scanner.nextLine());

                



                //Read in number of clues in clue vector

                int cluescount = scanner.nextInt();



                //Instantiate a new maingrid object based on the data read from .lps file

                Maingrid maingrid = new Maingrid(numofcat, numofopt, gridregions, categorys, usercontrols, this);



                //Begin reading in clue list object



                java.util.List cluelist = null;

                FileInputStream instream_file = null;

                ObjectInputStream instream_obj = null;



                try {

                    //Open object file

                    instream_file = new FileInputStream(file.getName() + "_cluedata");

                    instream_obj = new ObjectInputStream(instream_file);



                    //Read in clue list file and store

                    cluelist = (java.util.ArrayList) instream_obj.readObject();

                    instream_obj.close();

                    //Set clue vector in main grid

                    maingrid.setclues(cluelist);

                    instream_file.close();



                } catch (IOException ex) {

                    ex.printStackTrace();

                } catch (ClassNotFoundException ex) {

                    ex.printStackTrace();

                } //end try/catch for .lps_cluedata object file opening



                maingrid.generategrid(options);

                maingrid.setExtendedState(Frame.MAXIMIZED_BOTH);

                maingrid.setVisible(true);

            }//if configuration text file (.lps file) is not empty



        } catch (IOException e) {

            JOptionPane.showMessageDialog(this, "File does not Exist");



        } //end try/catch for .lps text file opening



    }// end loadfile



    //Main entry of application

    public static void main(String args[]) {

        java.awt.EventQueue.invokeLater(new Runnable() {



            //Run Homescreen

            public void run() {

                new HomeScreen().setVisible(true);

            }

        });

    }



    JFileChooser jfc = new JFileChooser();

    public UserControls usercontrols;

    private java.awt.Button button1;

    private javax.swing.JButton createNewGridbut;

    private javax.swing.JLabel jLabel1;

    private javax.swing.JButton openexistinggridbut;

}



