/*Block.java
 *
 * This object represents an individual block in the logic grid.  Each block can have a status
 of true (2), false (1) or null (3).

 * Darra Ricks
 */
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.*;

public class Block extends JButton {

    int iconswitch = 0;
    int status;
    boolean comp_or_user = true;  ///flag to determine whether block status was user defined or computer generated from autocomplete
    boolean setcomp_or_user;
    ButtonHandler handler = new ButtonHandler();
    globals Globals = new globals();
    Font buttonfont;
    int index1;  //location in grid region x index
    int index2;  //location in grid region y index
    int regionidx1; //grid region location x index
    int regionidx2; //grid region location y index
    String cat1optname; //Category 1 Option Name
    String cat2optname; //Category 2 Option Name

    public Block(int idx1, int idx2, int ridx1, int ridx2) {

        //Set location indexes upon initialization
        this.setBackground(Color.GRAY);
        this.setSize(Globals.offset, Globals.offset);
        Dimension d = new Dimension(Globals.offset, Globals.offset);
        this.setPreferredSize(d);
        buttonfont = new Font("monospaced", Font.BOLD, 2);
        this.setFont(buttonfont);
        index1 = idx1;
        index2 = idx2;
        regionidx1 = ridx1;
        regionidx2 = ridx2;
        status = 3;         //intialize block to 3 gray blank status, 1 is green(true), 2 is red (true

    }

    public Block() {
    }
	//Sets the Options names of the block
    public void setoptionnames(String opt1,String opt2)
    {  cat1optname = opt1;
       cat2optname = opt2;
    }
	//Returns block row index in gridblock region
    public int getidx1() {
        return index1;
    }
	//Returns block col index in gridblock region
    public int getidx2() {
        return index2;
    }
	//Method to set the true, false or null status of block
    public void setblock(int index) {
        status = index;
        setcomp_or_user = true;
        switch (index) {

            case 1:
                this.setBackground(Color.red);
                iconswitch = status + 1;

                break;
            case 2:
                iconswitch = status + 1;
                this.setBackground(Color.green);
                break;

            case 3:
                iconswitch = 1;
                this.setBackground(Color.gray);

                break;
        }
        this.repaint();
    }

    //Returns the true false or null status of block
    public int getblocknum() {
        return status;
    }

    //Changes the status of the block upon click
    public void block_click() {

        switch (iconswitch) {
            case 0:
                status = 1;
                iconswitch = 2;
                comp_or_user = false;
                this.setBackground(Color.red);
                break;

            case 1:
                status = iconswitch;
                ++iconswitch;
                comp_or_user = false;
                this.setBackground(Color.red);
                break;

            case 2:
                status = iconswitch;
                comp_or_user = false;
                ++iconswitch;
                this.setBackground(Color.green);
                break;

            case 3:
                this.setBackground(Color.gray);
                comp_or_user = true;
                status = 3;
                iconswitch = 1;
                break;
        }//end switch case iconswitch
    }//end buttonclick

	//Action Listener for this object
    private class ButtonHandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            block_click();
        }
    }//end ButtonHandler ActionListener
}//end class Block
