/*

 * GridScreen.java

 *

 * Created on Feb 16, 2010, 4:15:49 PM

 */



/**

 *

 * Owner:  Darra Ricks

 *	The Gridscreen object is used to display the logic grid configuration panels which allow the user to 

 *	enter the number of categories and options and also input the names of the categories and options.

 */

import javax.swing.*;

import java.awt.event.*;

import java.awt.*;

import javax.imageio.ImageIO;

import java.awt.image.BufferedImage;

import java.io.*;





public class GridScreen extends JFrame {



	//Constructor for gridscreen which links to its parent homescreen

    GridScreen(HomeScreen homescreen) {

        myhomescreen = homescreen;

        BufferedImage image = null;

        try {



            image = ImageIO.read(this.getClass().getResource("question-mark-red.jpg"));

        } catch (IOException e) {

            e.printStackTrace();

        }

       this.setIconImage(image);

       this.setTitle("Logic Puzzle Solver");

        initComponents();

        

        backbut1 = new JButton("<< Back");

   

        backbut1.setBounds(0,0, 80,25);



        backbut1.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

               backbut1ActionPerformed(evt);

            }

        });



        backbut2 = new JButton("<< Back");

        backbut2.setBounds(0,0, 80,25);

        backbut2.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

               backbut2ActionPerformed(evt);

            }

        });



        backbut3 = new JButton("<< Back");

        backbut3.setBounds(0,0, 80,25);

        backbut3.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

               backbut3ActionPerformed(evt);

            }

        });

        submitBUT.setBounds(85,0, 80,25);

        submitBUT.repaint();



        navbutpanel.add(backbut1);





    }





    private void backbut1ActionPerformed(ActionEvent evt) {



        this.dispose();

        myhomescreen.setVisible(true);







    }



    //Action Listener for back navigation button on Category Name entry Panel, when pressed this button will navigate back

    //to the Configure Grid Size panel

    private void backbut2ActionPerformed(ActionEvent evt)

    {

        

         for (int i = 0; i < numofcat; ++i) {

            quesPanel.remove(catTFs[i]);

        }

         quesPanel.repaint();

         

        quesPanel.add(CatquesLbl);

        quesPanel.add(Optqueslbl);

        quesPanel.add(optnumTF);

        quesPanel.add(catnumTF);

        quespanelLBL.setText("Configure Grid Size");



        navbutpanel.remove(backbut2);

        navbutpanel.remove(nextbut2);

    

    

        navbutpanel.add(backbut1);

        navbutpanel.add(submitBUT);

        navbutpanel.repaint();

         

         

    }



     private void backbut3ActionPerformed(ActionEvent evt)

     {



          for (int i = 0; i < numofcat; ++i)

          {    quesPanel.remove(catLabels[i]);



             for (int j = 0; j < numofopt; ++j)

                   quesPanel.remove(optionsTF[i][j]);

          }



          quesPanel.repaint();

          quespanelLBL.setText("Category Names");

          navbutpanel.remove(nextbut3);

          navbutpanel.remove(backbut3);

          xpos =0;

          ypos=Globals.offset;

          for (int i = 0; i < numofcat; ++i) {



            catTFs[i].setSize(Globals.textbx_width, Globals.offset);

            catTFs[i].setLocation(xpos, ypos);



            ypos += Globals.offset;

            quesPanel.add(catTFs[i]);

        }





          navbutpanel.add(backbut2);

          navbutpanel.add(nextbut2);



     }



    @SuppressWarnings("unchecked")

    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents

    private void initComponents() {



        mainPanel = new javax.swing.JPanel();

        quesPanel = new javax.swing.JPanel();

        catnumTF = new javax.swing.JTextField();

        optnumTF = new javax.swing.JTextField();

        CatquesLbl = new javax.swing.JLabel();

        Optqueslbl = new javax.swing.JLabel();

        quespanelLBL = new javax.swing.JLabel();

        navbutpanel = new javax.swing.JPanel();

        submitBUT = new javax.swing.JButton();



        mainPanel.setBackground(new java.awt.Color(255, 255, 204));



        quesPanel.setBackground(new java.awt.Color(255, 255, 204));

        quesPanel.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        quesPanel.setMaximumSize(new java.awt.Dimension(900, 400));

        quesPanel.setMinimumSize(new java.awt.Dimension(900, 400));

        quesPanel.setPreferredSize(new java.awt.Dimension(900, 400));



        catnumTF.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

                catnumTFActionPerformed(evt);

            }

        });



        optnumTF.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

                optnumTFActionPerformed(evt);

            }

        });



        CatquesLbl.setText(" Number of Categories");



        Optqueslbl.setText("Number of Options");



        quespanelLBL.setFont(new java.awt.Font("Tahoma", 1, 11));

        quespanelLBL.setText("Configure Grid Size");



        navbutpanel.setBackground(new java.awt.Color(255, 255, 204));

        navbutpanel.setMaximumSize(new java.awt.Dimension(200, 50));

        navbutpanel.setMinimumSize(new java.awt.Dimension(200, 50));



        submitBUT.setText("Next >>");

        submitBUT.setMaximumSize(new java.awt.Dimension(80, 25));

        submitBUT.setMinimumSize(new java.awt.Dimension(80, 25));

        submitBUT.setPreferredSize(new java.awt.Dimension(80, 25));

        submitBUT.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {

                submitBUTActionPerformed(evt);

            }

        });



        javax.swing.GroupLayout navbutpanelLayout = new javax.swing.GroupLayout(navbutpanel);

        navbutpanel.setLayout(navbutpanelLayout);

        navbutpanelLayout.setHorizontalGroup(

            navbutpanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(navbutpanelLayout.createSequentialGroup()

                .addGap(81, 81, 81)

                .addComponent(submitBUT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(472, Short.MAX_VALUE))

        );

        navbutpanelLayout.setVerticalGroup(

            navbutpanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(navbutpanelLayout.createSequentialGroup()

                .addComponent(submitBUT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(110, Short.MAX_VALUE))

        );



        javax.swing.GroupLayout quesPanelLayout = new javax.swing.GroupLayout(quesPanel);

        quesPanel.setLayout(quesPanelLayout);

        quesPanelLayout.setHorizontalGroup(

            quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(quesPanelLayout.createSequentialGroup()

                .addGroup(quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

                    .addGroup(quesPanelLayout.createSequentialGroup()

                        .addGap(10, 10, 10)

                        .addComponent(quespanelLBL, javax.swing.GroupLayout.PREFERRED_SIZE, 155, javax.swing.GroupLayout.PREFERRED_SIZE))

                    .addGroup(quesPanelLayout.createSequentialGroup()

                        .addContainerGap()

                        .addComponent(navbutpanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))

                    .addGroup(quesPanelLayout.createSequentialGroup()

                        .addGap(10, 10, 10)

                        .addGroup(quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

                            .addComponent(CatquesLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE)

                            .addComponent(Optqueslbl))

                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)

                        .addGroup(quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

                            .addComponent(optnumTF, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)

                            .addComponent(catnumTF, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE))))

                .addContainerGap(360, Short.MAX_VALUE))

        );

        quesPanelLayout.setVerticalGroup(

            quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(quesPanelLayout.createSequentialGroup()

                .addComponent(quespanelLBL, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addGap(26, 26, 26)

                .addGroup(quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)

                    .addComponent(CatquesLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)

                    .addComponent(catnumTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))

                .addGap(15, 15, 15)

                .addGroup(quesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)

                    .addComponent(Optqueslbl, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)

                    .addComponent(optnumTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))

                .addGap(194, 194, 194)

                .addComponent(navbutpanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(30, Short.MAX_VALUE))

        );



        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);

        mainPanel.setLayout(mainPanelLayout);

        mainPanelLayout.setHorizontalGroup(

            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(mainPanelLayout.createSequentialGroup()

                .addContainerGap()

                .addComponent(quesPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 1009, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(1251, Short.MAX_VALUE))

        );

        mainPanelLayout.setVerticalGroup(

            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(mainPanelLayout.createSequentialGroup()

                .addGap(38, 38, 38)

                .addComponent(quesPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 485, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(664, Short.MAX_VALUE))

        );



        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());

        getContentPane().setLayout(layout);

        layout.setHorizontalGroup(

            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(layout.createSequentialGroup()

                .addContainerGap()

                .addComponent(mainPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(1021, Short.MAX_VALUE))

        );

        layout.setVerticalGroup(

            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)

            .addGroup(layout.createSequentialGroup()

                .addContainerGap()

                .addComponent(mainPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)

                .addContainerGap(303, Short.MAX_VALUE))

        );

    }// </editor-fold>//GEN-END:initComponents



    private void optnumTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optnumTFActionPerformed

    }//GEN-LAST:event_optnumTFActionPerformed



	

	//Action Listener for next button on first configuration panel for Number of Categories and Number of Options

	//when pressed this button enables the application to navigate to the Category name entry configuration panel

    private void submitBUTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitBUTActionPerformed



       boolean errorflag = false;  //flag which signals invalid user input

       try

       {

        numofcat = Integer.parseInt(catnumTF.getText());

        numofopt = Integer.parseInt(optnumTF.getText());

		//Number of categories and options must be between 2 and 6

        if((numofcat>6)||(numofcat<2)||(numofopt>6)||(numofopt<2))

        {

            JOptionPane.showMessageDialog(this, "Number of Categories and Options must be between 2-6");

            errorflag = true;

        }



       }

       catch(NumberFormatException e)

       {

           JOptionPane.showMessageDialog(this, "Please enter only numeric values between 2-6 ");

           errorflag = true;



       }

  



        //If valid input from user display textboxes for entry of category names

        if(!errorflag) 

        {

        maingrid = new Maingrid(numofcat, numofopt, this);



        //Remove category number and option number questions from Panel to refresh with new Category title entry textboxes

        quesPanel.remove(CatquesLbl);

        quesPanel.remove(Optqueslbl);

        quesPanel.remove(optnumTF);

        quesPanel.remove(catnumTF);

        navbutpanel.remove(submitBUT);

        navbutpanel.remove(backbut1);

        quesPanel.repaint();



        quespanelLBL.setText("Category Names");



        catTFs = new JTextField[numofcat];



        xpos = 0;

        ypos = Globals.offset;



        for (int i = 0; i < numofcat; ++i) {

            catTFs[i] = new JTextField();

            catTFs[i].setSize(Globals.textbx_width, Globals.offset);

            catTFs[i].setLocation(xpos, ypos);

            



            ypos += Globals.offset;

            quesPanel.add(catTFs[i]);

        }



        //create next button for current view of panel

        nextbut2 = new JButton("Next >>");

        nextbut2.setSize(Globals.buttonwidth, Globals.buttonhieght);

        nextbut2.setLocation(85,0);

        nextbut2.addActionListener(new ActionListener() {



            //add action listener for next button on  current view of panel

            public void actionPerformed(ActionEvent evt) {

                nextbut2ActionPerformed(evt);

            }

        });

        

        navbutpanel.add(backbut2);

        navbutpanel.add(nextbut2);



        }

    }//GEN-LAST:event_submitBUTActionPerformed



    public void showmessage(String msg)

    {

        JOptionPane.showMessageDialog(this, msg);

    }

 

	//Action Listener for Next button on the last configuration panel which displays a grid of textboxes for option name entry

	//when pressed this button navigates to the main grid screen where the customized logic grid displays

    private void nextbut3ActionPerformed(ActionEvent evt) {



        mainPanel.remove(quesPanel);

        mainPanel.repaint();



		//Configure main grid for display

		

        String[][] optionnames = new String[numofcat][numofopt];

        String[] categories = new String[numofcat];

		//Store options names from textboxes on quespanel

        for (int i = 0; i < numofcat; ++i) {

            categories[i] = catTFs[i].getText();

            for (int j = 0; j < numofopt; ++j) {

                optionnames[i][j] = new String();

                optionnames[i][j] = optionsTF[i][j].getText();

            }

        }

        usercontrols = new UserControls(categories, optionnames);

		maingrid.setUsercontrols(usercontrols);

		maingrid.initializeComponents();

        maingrid.generategrid(optionnames);

        maingrid.setcategories(categories);

        maingrid.setLocation(0, offset * Globals.sizefactor);

        maingrid.setExtendedState(Frame.MAXIMIZED_BOTH);

        maingrid.repaint();

		

	//After configuration dispay main grid

        maingrid.setVisible(true);



    }//end nextbutton3ActionPerformed



	//Action Listener for next button on Category Name configuration panel, when pressed it enables

	//the application to diplay the Option Name Configuration panel

    private void nextbut2ActionPerformed(ActionEvent evt) {



        //When next button 2 is clicked generate category textboxes and generate option category textboxes



        for (int i = 0; i < numofcat; ++i) {



            //setting the category names of main grid

            maingrid.categorynames[i] = catTFs[i].getText();

            quesPanel.remove(catTFs[i]);

        }



        navbutpanel.remove(nextbut2);

        navbutpanel.remove(backbut2);

        quespanelLBL.setText("Configure Category Options");



        optionsTF = new JTextField[numofcat][numofopt];

        xpos = Globals.offset;

        ypos = Globals.offset * Globals.sizefactor;

        catLabels = new JLabel[numofcat];



		//Configure the multi-dimensional array of option names for display

        for (int i = 0; i < numofcat; ++i) {



            catLabels[i] = new JLabel(maingrid.categorynames[i]);

            catLabels[i].setSize(Globals.textbx_width, Globals.offset);

            catLabels[i].setLocation(xpos, ypos - Globals.offset);

            quesPanel.add(catLabels[i]);



            for (int j = 0; j < numofopt; ++j) {



                optionsTF[i][j] = new JTextField();

                optionsTF[i][j].setSize(Globals.textbx_width, Globals.offset);

                optionsTF[i][j].setLocation(xpos, ypos);

                quesPanel.add(optionsTF[i][j]);



                ypos += Globals.offset;

            }



            ypos = Globals.offset * Globals.sizefactor;

            xpos += Globals.textbx_width;

        }

        nextbut3 = new JButton("Next >>");

        nextbut3.setSize(Globals.buttonwidth, Globals.buttonhieght);

        nextbut3.setLocation(85,0);

        nextbut3.addActionListener(new ActionListener() {



            public void actionPerformed(ActionEvent evt) {

                nextbut3ActionPerformed(evt);

            }

        });

       navbutpanel.add(nextbut3);

       navbutpanel.add(backbut3);

        quesPanel.repaint();



    }//end nextbutton2ActionPerformed

	

    private void catnumTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_catnumTFActionPerformed

    }//GEN-LAST:event_catnumTFActionPerformed

    int numofcat, xpos, ypos;

    int numofopt;

    globals Globals = new globals();

    JTextField[][] optionsTF;

    JLabel[] catLabels;

    int offset = Globals.offset;

    int nextbutswitch = 1;

    private JButton nextbut2;

    private JButton nextbut3;

    Maingrid maingrid;

    JTextField[] catTFs;

    JFileChooser jfc;

    HomeScreen myhomescreen;

    UserControls usercontrols;

    JButton backbut1;

    JButton backbut2;

    JButton backbut3;



    // Variables declaration - do not modify//GEN-BEGIN:variables

    private javax.swing.JLabel CatquesLbl;

    private javax.swing.JLabel Optqueslbl;

    private javax.swing.JTextField catnumTF;

    private javax.swing.JPanel mainPanel;

    private javax.swing.JPanel navbutpanel;

    private javax.swing.JTextField optnumTF;

    private javax.swing.JPanel quesPanel;

    private javax.swing.JLabel quespanelLBL;

    private javax.swing.JButton submitBUT;

    // End of variables declaration//GEN-END:variables

}



