/**
*    Name:    EleInNameTable.java
*    Author:  Lei Shen
*    Modified by: Suresh Thesayi
*    Modification date: Feb. 20, 2000
*    Date:    Feb. 16, 1999
*/

import java.util.*;

/**
 *    Every identifier except keyword has an entry in the name table.
 *    There are two types of those identifiers:
 *       ATOM and NODE.
 */
class EleInNameTable{


   //the unique name for atom or node
   private String    strKey;

   //the type supported now are: ATOM and NODE
   private String    strType;

   //all the original rules from file 
   private Vector    vecRules;

   //respective flags for vecRules; if the rule is matched than the flag is set
   //to true
   private Vector    matchFlags;


   public EleInNameTable(String key, String type) {
      strKey  = key;
      strType = type;
   }

   public String getStrKey() {
      return strKey;
   }

   public Vector getVecRules() {
      return vecRules;
   }

   public Vector getMatchFlags() {
      return matchFlags;
   }

   public void setMatchFlagAt(int index) {
      matchFlags.setElementAt(Boolean.TRUE, index);
   }

   public void setMatchFlags(Vector f) {
      matchFlags = f;
   }

   public void setVecRules(Vector v) {
      vecRules = v;
   }

   public boolean isNode() {
      return ( strType.equals("NODE") );
   }

   public boolean isAtom() {
      return ( strType.equals("ATOM") );
   }
  
   public String toString() {
       return strKey + " (" + strType + ")\n " + vecRules;
   } 
}
