#ifndef  __CONF_H__
#define __CONF_H__

#include <sys/types.h>
#include <gtk/gtk.h>

#define IC_CFG 0
#define IV_CFG 1
#define OC_CFG 2
#define OV_CFG 3
#define PRESSURE_CFG 4
#define SPEED_CFG 5
#define CFG_CNT 6

#define FNAMELEN 100
typedef struct
{
 GdkPixmap *pixmap;	// Pixmap used for drawing
 ushort *val;		// Buffer for holding signal data that can be displayed
 uint size;		// Size of the buffer
 uint cnt;		// Number of useful readings in the buffer
 uint fsize;		// File size
 char track;		// Whether the signal is being tracked
 uint disppos;		// The offset with-in the file, of the left most point
			// in the graph
 char fname[FNAMELEN];	// File name
 float rawmax;		// The signal value corresponding to ADC value 0xFFFF
 float expmax;		// The maximux value of the signal we expect to read
 int color;		// Graph color
 int drawgrid;		// Draw the grid?
 float gridstep;	// Difference in value between horizontal grid lines
 int gridbgcolor;	// Grid background color
 int gridlinecolor;	// Grid line color
 char format[100];	// Format string for displaying the reading
} SIGNALCFG;

extern SIGNALCFG sigcfg[CFG_CNT];

#endif
