/**
 * Author: Saravana Krishnan Kannan
 * Date: Sometime around 24-April-2004!
 * Description: This file contains the call back functions for the events that
 * occur in the GUI. There is also a function - refresh() - which is not a
 * callback function, but it is used by many other callback functions.
 **/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "conf.h"
#include "plot.h"
#include "filecheck.h"

#define DEFPAGE 1

extern GtkWidget *w_main;

int curr_page=DEFPAGE;
int alldone = FALSE;

/* Refresh (or repaint) the drawing area. */
void refresh(GtkWidget *drawarea)
{
 GdkRectangle update_rect;
 
 update_rect.x=0;
 update_rect.y=0;
 update_rect.width=drawarea->allocation.width;
 update_rect.height=drawarea->allocation.height;
  
 gtk_widget_draw(drawarea, &update_rect);
}


/* Configure event occurs when the Drawing Area changes in size - typically
 * when the window is resized. */
gboolean
on_draw_ic_configure_event             (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
 if (sigcfg[IC_CFG].pixmap) gdk_pixmap_unref(sigcfg[IC_CFG].pixmap);

 sigcfg[IC_CFG].pixmap = gdk_pixmap_new(widget->window,
 			 widget->allocation.width,
 			 widget->allocation.height,-1);
 
 if (sigcfg[IC_CFG].val) free(sigcfg[IC_CFG].val);
 sigcfg[IC_CFG].size=widget->allocation.width;
 sigcfg[IC_CFG].val=(ushort *) calloc(sigcfg[IC_CFG].size , sizeof(ushort));

 /* Clear the window */
 gdk_draw_rectangle(sigcfg[IC_CFG].pixmap, widget->style->white_gc,
 		    TRUE, 0, 0, widget->allocation.width,
 		    widget->allocation.height);
 
 chk_file();
 return TRUE;
}

/* Expose event occurs when a  part of the Drawing area is exposed to the user.
 * Typically this occurs when the Drawing Area is covered by a window (or some
 * other object) and then the object is move or sent behind the Drawing Area -
 * allowing the user to see the previously "unviewable" part of the Drawing
 * Area. */
gboolean
on_draw_ic_expose_event                (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 gdk_draw_pixmap(widget->window,
 		 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
 		 sigcfg[IC_CFG].pixmap, event->area.x, event->area.y,
 		 event->area.x, event->area.y,
 		 event->area.width, event->area.height);
 return TRUE;
}


gboolean
on_draw_iv_configure_event             (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
 if (sigcfg[IV_CFG].pixmap) gdk_pixmap_unref(sigcfg[IV_CFG].pixmap);

 sigcfg[IV_CFG].pixmap = gdk_pixmap_new(widget->window,
 			 widget->allocation.width,
 			 widget->allocation.height,-1);
 
 if (sigcfg[IV_CFG].val) free(sigcfg[IV_CFG].val);
 sigcfg[IV_CFG].size=widget->allocation.width;
 sigcfg[IV_CFG].val=(ushort *) calloc(sigcfg[IV_CFG].size , sizeof(ushort));

 /* Clear the window */
 gdk_draw_rectangle(sigcfg[IV_CFG].pixmap, widget->style->white_gc,
 		    TRUE, 0, 0, widget->allocation.width,
 		    widget->allocation.height);
 
 chk_file();
 return TRUE;
}


gboolean
on_draw_iv_expose_event                (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 gdk_draw_pixmap(widget->window,
 		 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
 		 sigcfg[IV_CFG].pixmap, event->area.x, event->area.y,
 		 event->area.x, event->area.y,
 		 event->area.width, event->area.height);
 return TRUE;
}


gboolean
on_draw_oc_configure_event             (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
 if (sigcfg[OC_CFG].pixmap) gdk_pixmap_unref(sigcfg[OC_CFG].pixmap);

 sigcfg[OC_CFG].pixmap = gdk_pixmap_new(widget->window,
 			 widget->allocation.width,
 			 widget->allocation.height,-1);
 
 if (sigcfg[OC_CFG].val) free(sigcfg[OC_CFG].val);
 sigcfg[OC_CFG].size=widget->allocation.width;
 sigcfg[OC_CFG].val=(ushort *) calloc(sigcfg[OC_CFG].size , sizeof(ushort));

 /* Clear the window */
 gdk_draw_rectangle(sigcfg[OC_CFG].pixmap, widget->style->white_gc,
 		    TRUE, 0, 0, widget->allocation.width,
 		    widget->allocation.height);
 
 chk_file();
 return TRUE;
}


gboolean
on_draw_oc_expose_event                (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 gdk_draw_pixmap(widget->window,
 		 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
 		 sigcfg[OC_CFG].pixmap, event->area.x, event->area.y,
 		 event->area.x, event->area.y,
 		 event->area.width, event->area.height);
 return TRUE;
}


gboolean
on_draw_ov_configure_event             (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
 if (sigcfg[OV_CFG].pixmap) gdk_pixmap_unref(sigcfg[OV_CFG].pixmap);

 sigcfg[OV_CFG].pixmap = gdk_pixmap_new(widget->window,
 			 widget->allocation.width,
 			 widget->allocation.height,-1);
 
 if (sigcfg[OV_CFG].val) free(sigcfg[OV_CFG].val);
 sigcfg[OV_CFG].size=widget->allocation.width;
 sigcfg[OV_CFG].val=(ushort *) calloc(sigcfg[OV_CFG].size , sizeof(ushort));

 /* Clear the window */
 gdk_draw_rectangle(sigcfg[OV_CFG].pixmap, widget->style->white_gc,
 		    TRUE, 0, 0, widget->allocation.width,
 		    widget->allocation.height);
 
 chk_file();
 return TRUE;
}


gboolean
on_draw_ov_expose_event                (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 gdk_draw_pixmap(widget->window,
 		 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
 		 sigcfg[OV_CFG].pixmap, event->area.x, event->area.y,
 		 event->area.x, event->area.y,
 		 event->area.width, event->area.height);
 return TRUE;
}


gboolean
on_draw_pressure_configure_event       (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
 if (sigcfg[PRESSURE_CFG].pixmap) gdk_pixmap_unref(sigcfg[PRESSURE_CFG].pixmap);

 sigcfg[PRESSURE_CFG].pixmap = gdk_pixmap_new(widget->window,
 			 widget->allocation.width,
 			 widget->allocation.height,-1);
 
 if (sigcfg[PRESSURE_CFG].val) free(sigcfg[PRESSURE_CFG].val);
 sigcfg[PRESSURE_CFG].size=widget->allocation.width;
 sigcfg[PRESSURE_CFG].val=(ushort *) calloc(sigcfg[PRESSURE_CFG].size , sizeof(ushort));

 /* Clear the window */
 gdk_draw_rectangle(sigcfg[PRESSURE_CFG].pixmap, widget->style->white_gc,
 		    TRUE, 0, 0, widget->allocation.width,
 		    widget->allocation.height);
 
 chk_file();
 return TRUE;
}


gboolean
on_draw_pressure_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 gdk_draw_pixmap(widget->window,
 		 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
 		 sigcfg[PRESSURE_CFG].pixmap, event->area.x, event->area.y,
 		 event->area.x, event->area.y,
 		 event->area.width, event->area.height);
 return TRUE;
}


gboolean
on_draw_speed_configure_event          (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
 if (sigcfg[SPEED_CFG].pixmap) gdk_pixmap_unref(sigcfg[SPEED_CFG].pixmap);

 sigcfg[SPEED_CFG].pixmap = gdk_pixmap_new(widget->window,
 			 widget->allocation.width,
 			 widget->allocation.height,-1);
 
 if (sigcfg[SPEED_CFG].val) free(sigcfg[SPEED_CFG].val);
 sigcfg[SPEED_CFG].size=widget->allocation.width;
 sigcfg[SPEED_CFG].val=(ushort *) calloc(sigcfg[SPEED_CFG].size , sizeof(ushort));

 /* Clear the window */
 gdk_draw_rectangle(sigcfg[SPEED_CFG].pixmap, widget->style->white_gc,
 		    TRUE, 0, 0, widget->allocation.width,
 		    widget->allocation.height);
 
 chk_file();
 return TRUE;
}


gboolean
on_draw_speed_expose_event             (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 gdk_draw_pixmap(widget->window,
 		 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
 		 sigcfg[SPEED_CFG].pixmap, event->area.x, event->area.y,
 		 event->area.x, event->area.y,
 		 event->area.width, event->area.height);
 return TRUE;
}


void
on_b_exit_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit();
}

gboolean
on_w_main_delete_event                 (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_main_quit();
  return FALSE;
}


void
on_w_main_show                         (GtkWidget       *widget,
                                        gpointer         user_data)
{
 GtkWidget *notebook1 = lookup_widget(GTK_WIDGET(w_main), "notebook1");
 int pagenum,maxpages;
 
 chk_init();

 maxpages=gtk_notebook_get_n_pages(GTK_NOTEBOOK(notebook1));
 /* This loop makes sure that all the Drawing Areas have been allocated a
  * pixmap before we try to draw anything. */
 for(pagenum=0;pagenum<maxpages;pagenum++)
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook1),pagenum);
 gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook1),DEFPAGE);
 alldone = TRUE;
}


void
on_notebook1_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        guint            page_num,
                                        gpointer         user_data)
{
 curr_page=page_num;
 if(alldone) chk_file();
}


/* This event occurs when the user slides the scroll bar - in GTK terms it is
 * called a Horizontal Scale, and hence the name hscale_ic. */
void
on_hscale_ic_value_changed             (GtkRange        *range,
                                        gpointer         user_data)
{
 sigcfg[IC_CFG].track = FALSE;
 sigcfg[IC_CFG].disppos = gtk_range_get_value(range);
 chk_file();
}


void
on_hscale_iv_value_changed             (GtkRange        *range,
                                        gpointer         user_data)
{
 sigcfg[IV_CFG].track = FALSE;
 sigcfg[IV_CFG].disppos = gtk_range_get_value(range);
 chk_file();
}


void
on_hscale_oc_value_changed             (GtkRange        *range,
                                        gpointer         user_data)
{
 sigcfg[OC_CFG].track = FALSE;
 sigcfg[OC_CFG].disppos = gtk_range_get_value(range);
 chk_file();
}


void
on_hscale_ov_value_changed             (GtkRange        *range,
                                        gpointer         user_data)
{
 sigcfg[OV_CFG].track = FALSE;
 sigcfg[OV_CFG].disppos = gtk_range_get_value(range);
 chk_file();
}


void
on_hscale_pressure_value_changed       (GtkRange        *range,
                                        gpointer         user_data)
{
 sigcfg[PRESSURE_CFG].track = FALSE;
 sigcfg[PRESSURE_CFG].disppos = gtk_range_get_value(range);
 chk_file();
}


void
on_hscale_speed_value_changed          (GtkRange        *range,
                                        gpointer         user_data)
{
 sigcfg[SPEED_CFG].track = FALSE;
 sigcfg[SPEED_CFG].disppos = gtk_range_get_value(range);
 chk_file();
}


void
on_b_track_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
 int i;
 if(curr_page==0)
 {
  for(i=0; i < CFG_CNT; i++)
   sigcfg[i].track = TRUE;
  chk_file();
 }
 else
 {
  sigcfg[curr_page-1].track = TRUE;
  chk_file();
 }
}
