//-----------------------------------------------------------------------------
// serial.c
//-----------------------------------------------------------------------------
// Copyright 2004 UK SolarCar Team.
//
// AUTH: Saravana Kannan
// DATE: 14 May 04
//
// The code takes care of all the serial I/O to the Radio and the LCD
//
// Target: C8051F31x
//
// Tool chain: KEIL C51 6.03 / KEIL EVAL C51
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include <c8051f310.h>		// SFR declarations
#include <stdio.h>
#include "serial.h"
#include "adc.h"

//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F31x
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Global VARIABLES
//-----------------------------------------------------------------------------
unsigned int r_ivolt = 0;
unsigned int r_icurr = 0;
unsigned int r_ovolt = 0;
unsigned int r_ocurr = 0;
unsigned int r_speed = 0;

extern unsigned int disppulse;

//-----------------------------------------------------------------------------
// initLCD()
//-----------------------------------------------------------------------------
//
// This routine initialises the LCD
// 
void initLCD ()
{
    //Clear the LCD screen
    printf ("\014");
    // Turn on Back light
    printf ("\016");
}

//-----------------------------------------------------------------------------
// dispLCD()
//-----------------------------------------------------------------------------
//
// This routine formats and displays the data in the LCD
// 
void dispLCD ()
{

    // Turn on Back light
    printf ("\016");
    //Send the cursor home (0,0)
    printf ("\001");
    printf ("IC:%2.1f  \n", icurr);
    printf ("IV:%3.1f  \n", ivolt);
    printf ("OC:%2.1f  \n", ocurr);
    printf ("OV:%3.1f  \n", ovolt);
    // Send the cursor home (0,0) and move the cursor two tabs to the right.
    printf ("\001\011\011  ");
    printf ("S: %0.2f   \n", speed);
    // Move the cursor two tabs to the right.
    printf ("\011\011  ");
    printf ("D: %0.0f\n", (PCA0CPH0 * 100.0) / 0xFF);
    printf ("\003");
}

//-----------------------------------------------------------------------------
// initRADIO()
//-----------------------------------------------------------------------------
//
// This routine initialises the RADIO
// 
void initRADIO ()
{
    // Goto Command mode
    // ECHO OFF   - Do not display(send to microcontroller) received characters
    // FLOW OFF   - Sending data doesn't pause receiving data
    // CR OFF             - Do not append CR to end of every line
    // MY <CALLSIGN> - Set my call sign
    // TX <in 10 millisec> - Time between PTT ON and start of pkt Tx
    // PACLEN <n> - Max Length of the data portion of a packet
    // DW <n>             - Time to wait between no carrier and Tx
    // SL <n>             - Random slot time for the Protocol
    // K                  - Go to Converse mode
    printf ("\003E OFF\rF OFF\rCR OFF\rMY %s\rTX 30\rP 80\rDW 0\rSL 10\rK\r",
	    MYCALLSIGN);
}

//-----------------------------------------------------------------------------
// sendbyRADIO()
//-----------------------------------------------------------------------------
//
// This routine formats and sends the data through the Radio
// 
void sendbyRADIO ()
{
    printf ("%04X%04X%04X%04X%04X%04X\r", r_ivolt, r_icurr, r_ovolt, r_ocurr,
	    r_speed, PCA0CPH0);
}
