//-----------------------------------------------------------------------------
// pwm.h
//-----------------------------------------------------------------------------
// Copyright 2004 UK Solar Car Team.
//
// AUTH: Saravana Kannan
// DATE: 14 May 04
//
// Header for the PPPT and speed-o-meter code
//
// Target: C8051F31x
//
// Tool chain: KEIL Eval 'c'
//

#ifndef __PWM_H_
#define __PWM_H_

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F30x
//-----------------------------------------------------------------------------
sfr16 PCA0CP1 = 0xEA;		// PCA CCM Module 1 register

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------
#define PULSE_PER_ROTATION	9.0
#define WRADIUS		9.5	// in Inches
#define PI 3.1415926
#define WCIRC		((WRADIUS * 2.0 * PI)/63360)

//-----------------------------------------------------------------------------
// Function PROTOTYPES and exported variables
//-----------------------------------------------------------------------------

float getspeed ();

#endif
