//-----------------------------------------------------------------------------
// pwm.c
//-----------------------------------------------------------------------------
// Copyright 2004 UK SolarCar Team.
//
// AUTH: Saravana Kannan
// DATE: 14 May 04
//
// This file contains the code that deals with the PPPT and the speed-o-meter.
//
// Target: C8051F31x
// Tool chain: KEIL C51 6.03 / KEIL EVAL C51
//

/
//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include <c8051f310.h>		// SFR declarations
#include <stdio.h>
#include "pwm.h"
#include "init.h"
#include "serial.h"
//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F30x
//-----------------------------------------------------------------------------
    sbit LED = P3 ^ 3;		// LED='1' means ON

float dist = 0.0;
float calcspeed = 0.0;
unsigned int pulsecnt;
unsigned int tmr2cnt = 0;
unsigned int speedticks = 0;
unsigned int disppulse = 0;
extern unsigned int pcnt;
extern unsigned int paniccnt;

void powermgmt ();

float getspeed ()
{
    return (dist * 3600 / 10);
}

//-----------------------------------------------------------------------------
// Interrupt Service Routines
//-----------------------------------------------------------------------------
// PCA Interrupt Subroutine needed for the speed-o-meter
void PCA_ISR (void) interrupt 11
{
    if (CCF1 == 1)
    {
	CCF1 = 0;
	pulsecnt++;
    }
}

//-----------------------------------------------------------------------------
// Interrupt Service Routines
//-----------------------------------------------------------------------------
// Timer2 Interrupt Subroutine needed for the speed-o-meter and PPPT
void Timer2_ISR (void) interrupt 5
{
    tmr2cnt++;
    speedticks++;
    pcnt++;
    if (paniccnt > 0)
	paniccnt--;
    if (tmr2cnt >= 15)
    {
	tmr2cnt = 0;
	LED = ~LED;
	powermgmt ();
    }
    if (speedticks >= 31)
    {
	dist = (pulsecnt / PULSE_PER_ROTATION) * WCIRC;
	disppulse = pulsecnt;
	speedticks = 0;
	pulsecnt = 0;
    }
    TF2H = 0;
}
