//-----------------------------------------------------------------------------
// init.h
//-----------------------------------------------------------------------------
// Copyright 2004 UK Solar Car Team.
//
// AUTH: Saravana Kannan
// DATE: 14 May 04
//
// Header for the Initialisation code
//
// Target: C8051F31x
//
// Tool chain: KEIL Eval 'c'
//

#ifndef __INIT_H_
#define __INIT_H_


//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F31x
//-----------------------------------------------------------------------------
sfr16 TMR2RL = 0xca;		// Timer2 reload value
sfr16 TMR2 = 0xcc;		// Timer2 counter

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------
#define SYSCLK      24500000	// SYSCLK frequency in Hz
#define BAUDRATE     9600	// Baud rate of UART in bps

//-----------------------------------------------------------------------------
// Function PROTOTYPES and exported variables
//-----------------------------------------------------------------------------
void SYSCLK_Init (void);
void PORT_Init (void);
void Timer0_Init ();
void Timer2_Init ();
void PCA_Init (int count);
void UART0_Init (void);
void ADC0_Init (void);

#endif
