//-----------------------------------------------------------------------------
// adc.h
//-----------------------------------------------------------------------------
// Copyright 2004 UK Solar Car Team.
//
// AUTH: Saravana Kannan
// DATE: 14 May 04
//
// Header for the ADC code
//
// Target: C8051F31x
//
// Tool chain: KEIL Eval 'c'
//

#ifndef __ADC_H_
#define __ADC_H_


//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F31x
//-----------------------------------------------------------------------------
sfr16 ADC0 = 0xbd;		// ADC Data Word Register

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------
#define VREF 3.312
#define PIN_IC 0x0D		// P2.5
#define PIN_IV 0x0C		// P2.4
#define PIN_OC 0x0B		// P2.3
#define PIN_OV 0x0A		// P2.2


//-----------------------------------------------------------------------------
// Function PROTOTYPES and exported variables
//-----------------------------------------------------------------------------
extern float ivolt;
extern float icurr;
extern float ovolt;
extern float ocurr;
extern float speed;

float norm_measure (void);
float get_out_volt (void);
float get_out_curr (void);
float get_in_volt (void);
float get_in_curr (void);

#endif
