//-----------------------------------------------------------------------------
// adc.c
//-----------------------------------------------------------------------------
// Copyright 2004 UK SolarCar Team.
//
// AUTH: Saravana Kannan
// DATE: 14 May 04
//
// This program is used to measure the input and output current/voltage of the
// DC-DC convertor.
//
// Target: C8051F31x
// Tool chain: KEIL C51 6.03 / KEIL EVAL C51
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include <c8051f310.h>		// SFR declarations
#include <stdio.h>
#include "adc.h"

//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F31x
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Global VARIABLES
//-----------------------------------------------------------------------------
float ivolt = 0;
float icurr = 0;
float ovolt = 0;
float ocurr = 0;
float speed = 0;

//-----------------------------------------------------------------------------
// Support Subroutines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// measure
//-----------------------------------------------------------------------------
//
// This routine averages 16383 ADC samples and returns a 16-bit unsigned 
// result.
// 
unsigned int measure (void)
{
    unsigned i;			// Sample counter
    unsigned long accumulator = 0L;	// Here's where we integrate the
    // ADC samples
    unsigned int currval;

    AD0INT = 0;
    AD0BUSY = 1;

    // read the ADC value and add to running total
    i = 0;
    do
    {
	REF0CN = 0x0A;		// enable temp sensor, VREF = VDD, bias
	while (!AD0INT);	// Wait for conversion to complete
	AD0INT = 0;		// Clear end-of-conversion indicator

	currval = ADC0;		// Store latest ADC conversion
	AD0BUSY = 1;		// Initiate conversion
	accumulator += currval;	// Accumulate
	i++;			// Update counter
    } while (i < 0x400);
    return (unsigned int) (accumulator >> 4);
    // shift to obtain a 16-bit result ((10 + 10 = 20) - 4 = 16) bits
}

float norm_measure (void)
{
    unsigned int ADC_code;
    float result;

    ADC_code = measure ();
    result = ((ADC_code >> 6) * VREF) / 0x3FF;

    return result;
}

float get_out_volt (void)
{
    float result;

    AMX0P = PIN_OV;
    result = norm_measure () * (119.45 / VREF);

    return result;
}

float get_out_curr (void)
{
    float result;

    AMX0P = PIN_OC;
    result = (norm_measure () - 1) / 0.194982644;
    if (result < 0)
	return 0.0;

    return result;
}

float get_in_volt (void)
{
    float result;

    AMX0P = PIN_IV;
    result = norm_measure () * (170.722 / VREF);

    return result;
}

float get_in_curr (void)
{
    float result;

    AMX0P = PIN_IC;
    result = (norm_measure () - 1) / 0.194982644;
    if (result < 0)
	return 0.0;

    return result;
}
