package org.bouncycastle.util.encoders;

/**
 * Converters for going from hex to binary and back.
 * <p>
 * Note: this class assumes ASCII processing.
 */
public class Hex
{
    private static HexTranslator   encoder = new HexTranslator();

    private static byte[]   hexTable = 
        { 
            (byte)'0', (byte)'1', (byte)'2', (byte)'3', (byte)'4', (byte)'5', (byte)'6', (byte)'7',
            (byte)'8', (byte)'9', (byte)'a', (byte)'b', (byte)'c', (byte)'d', (byte)'e', (byte)'f'
        };

    public static byte[] encode(
        byte[]  array)
    {
        return encode(array, 0, array.length);
    }

    public static byte[] encode(
        byte[]  array,
        int     off,
        int     length)
    {
        byte[]      enc = new byte[length * 2];

        encoder.encode(array, off, length, enc, 0);

        return enc;
    }

    public static byte[] decode(
        String  string)
    {
        byte[]          bytes = new byte[string.length() / 2];
        StringBuffer    sBuf = new StringBuffer(string.toLowerCase());

        for (int i = 0; i != bytes.length; i++)
        {
            if (sBuf.charAt(2 * i) < 'a')
            {
                bytes[i] = (byte)((sBuf.charAt(2 * i) - '0') << 4);
            }
            else
            {
                bytes[i] = (byte)((sBuf.charAt(2 * i) - 'a' + 10) << 4);
            }
            if (sBuf.charAt(2 * i + 1) < 'a')
            {
                bytes[i] += (byte)(sBuf.charAt(2 * i + 1) - '0');
            }
            else
            {
                bytes[i] += (byte)(sBuf.charAt(2 * i + 1) - 'a' + 10);
            }
        }

        return bytes;
    }

    public static byte[] decode(
        byte[]  array)
    {
        byte[]          bytes = new byte[array.length / 2];

        encoder.decode(array, 0, array.length, bytes, 0);

        return bytes;
    }
}
