package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.*;

/**
 * an object for the elements in the X.509 V3 extension block.
 */
public class X509Extension
{
    boolean             critical;
    DEROctetString      value;

    public X509Extension(
        DERBoolean              critical,
        DEROctetString          value)
    {
        this.critical = critical.isTrue();
        this.value = value;
    }

    public X509Extension(
        boolean                 critical,
        DEROctetString          value)
    {
        this.critical = critical;
        this.value = value;
    }

    public boolean isCritical()
    {
        return critical;
    }

    public DEROctetString getValue()
    {
        return value;
    }

    public int hashCode()
    {
        if (this.isCritical())
        {
            return this.getValue().hashCode();
        }

        
        return ~this.getValue().hashCode();
    }

    public boolean equals(
        Object  o)
    {
        if (o == null || !(o instanceof X509Extension))
        {
            return false;
        }

        X509Extension   other = (X509Extension)o;

        return other.getValue().equals(this.getValue())
            && (other.isCritical() == this.isCritical());
    }
}
