package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.*;
import org.bouncycastle.asn1.pkcs.*;

/**
 * an X509Certificate structure.
 * <pre>
 *  Certificate ::= SEQUENCE {
 *      tbsCertificate          TBSCertificate,
 *      signatureAlgorithm      AlgorithmIdentifier,
 *      signature               BIT STRING
 *  }
 * </pre>
 */
public class X509CertificateStructure
    implements DEREncodable, X509ObjectIdentifiers, PKCSObjectIdentifiers
{
    DERConstructedSequence  seq;
    TBSCertificateStructure tbsCert;
    AlgorithmIdentifier     sigAlgId;
    DERBitString            sig;

    public X509CertificateStructure(
        DERConstructedSequence  seq)
    {
        this.seq = seq;

        //
        // correct x509 certficate
        //
        if (seq.getSize() == 3)
        {
            tbsCert = TBSCertificateStructure.getInstance(seq.getObjectAt(0));
            sigAlgId = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));

            sig = (DERBitString)seq.getObjectAt(2);
        }
    }

    public TBSCertificateStructure getTBSCertificate()
    {
        return tbsCert;
    }

    public int getVersion()
    {
        return tbsCert.getVersion();
    }

    public DERInteger getSerialNumber()
    {
        return tbsCert.getSerialNumber();
    }

    public X509Name getIssuer()
    {
        return tbsCert.getIssuer();
    }

    public DERUTCTime getStartDate()
    {
        return tbsCert.getStartDate();
    }

    public DERUTCTime getEndDate()
    {
        return tbsCert.getEndDate();
    }

    public X509Name getSubject()
    {
        return tbsCert.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo()
    {
        return tbsCert.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm()
    {
        return sigAlgId;
    }

    public DERBitString getSignature()
    {
        return sig;
    }

    public DERObject getDERObject()
    {
        return seq;
    }
}
