package org.bouncycastle.asn1.x509;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.asn1.*;

/**
 * <pre>
 * SubjectKeyIdentifier::= OCTET STRING
 * </pre>
 */
public class SubjectKeyIdentifier
    implements DEREncodable
{
	private byte[] keyidentifier;

    public SubjectKeyIdentifier(
        byte[] keyid)
    {
        this.keyidentifier=keyid;
    }

    public SubjectKeyIdentifier(
        DEROctetString  keyid)
    {
		this.keyidentifier=keyid.getOctets();

    }

	/**
	 *
	 * Calulates the keyidentifier using a SHA1 hash over the BIT STRING
	 * from SubjectPublicKeyInfo as defined in RFC2459.
	 *
	 **/
	public SubjectKeyIdentifier(
		SubjectPublicKeyInfo    spki)
	{
		Digest  digest = new SHA1Digest();
		byte[]  resBuf = new byte[digest.getDigestSize()];

		byte[] bytes = spki.getPublicKeyData().getBytes();
		digest.update(bytes, 0, bytes.length);
		digest.doFinal(resBuf, 0);
		this.keyidentifier=resBuf;
	}

    public byte[] getKeyIdentifier()
    {
        return keyidentifier;
    }

     /**
     * <pre>
     * SubjectKeyIdentifier := OCTET STRING
     * </pre>
     */
    public DERObject getDERObject()
    {
        DEROctetString oct = new DEROctetString(keyidentifier);
        return oct;
    }
}
