package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.*;

public class ReasonFlags
    extends DERBitString
{
    public static final int KEY_COMPROMISE          = 1;
    public static final int CA_COMPROMISE           = (1 << 2);
    public static final int AFFILIATION_CHANGED     = (1 << 3);
    public static final int SUPERSEDED              = (1 << 4);
    public static final int CESSATION_OF_OPERATION  = (1 << 5);
    public static final int CERTIFICATE_HOLD        = (1 << 6);

    /**
     * <pre>
     * ReasonFlags ::= BIT STRING {
     *    unused(0),
     *    keyCompromise(1),
     *    cACompromise(2),
     *    affiliationChanged(3),
     *    superseded(4),
     *    cessationOfOperation(5),
     *    certficateHold(6)
     * }
     * </pre>
     */
    public ReasonFlags(
        int reasons)
    {
        super((byte)reasons, 1);
    }
}
