package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.math.BigInteger;

import org.bouncycastle.asn1.*;

public class RSAPublicKeyStructure
    implements DEREncodable
{
    private BigInteger  modulus;
    private BigInteger  publicExponent;

    public RSAPublicKeyStructure(
        BigInteger  modulus,
        BigInteger  publicExponent)
    {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
    }

    public RSAPublicKeyStructure(
        DERConstructedSequence  seq)
    {
        Enumeration e = seq.getObjects();

        modulus = ((DERInteger)e.nextElement()).getValue();
        publicExponent = ((DERInteger)e.nextElement()).getValue();
    }

    public BigInteger getModulus()
    {
        return modulus;
    }

    public BigInteger getPublicExponent()
    {
        return publicExponent;
    }

    /**
     * This outputs the key in PKCS1v2 format.
     * <pre>
     *      RSAPublicKey ::= SEQUENCE {
     *                          modulus INTEGER, -- n
     *                          publicExponent INTEGER, -- e
     *                      }
     * </pre>
     * <p>
     */
    public DERObject getDERObject()
    {
        DERConstructedSequence  seq = new DERConstructedSequence();

        seq.addObject(new DERInteger(getModulus()));
        seq.addObject(new DERInteger(getPublicExponent()));

        return seq;
    }
}
