package org.bouncycastle.asn1.x509;

import java.io.*;
import java.util.*;

import org.bouncycastle.asn1.*;

/**
 *  extendedKeyUsage
 *  <pre>
 *      extendedKeyUsage ::= SEQUENCE SIZE (1..MAX) OF KeyPurposeId
 *  </pre>
 */
public class ExtendedKeyUsage
    implements DEREncodable
{
    Hashtable               usageTable;
    DERConstructedSequence  seq;

    public ExtendedKeyUsage(
        DERConstructedSequence  seq)
    {
        this.seq = seq;

        Enumeration e = seq.getObjects();

        while (e.hasMoreElements())
        {
            Object  o = e.nextElement();

            this.usageTable.put(o, o);
        }
    }

    public ExtendedKeyUsage(
        Vector  usages)
    {
        this.seq = new DERConstructedSequence();

        Enumeration e = usages.elements();

        while (e.hasMoreElements())
        {
            DERObject  o = (DERObject)e.nextElement();

            seq.addObject(o);
            this.usageTable.put(o, o);
        }
    }

    public boolean hasKeyPurposeId(
        KeyPurposeId keyPurposeId)
    {
        return (usageTable.get(keyPurposeId) != null);
    }

    public DERObject getDERObject()
    {
        return seq;
    }
}
