package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.*;

public class DistributionPoint
    implements DEREncodable
{
    DERConstructedSequence  seq = null;

    public DistributionPoint(
        DistributionPointName   distributionPoint,
        ReasonFlags             reasons,
        GeneralNames            cRLIssuer)
    {
        seq = new DERConstructedSequence();

        if (distributionPoint != null)
        {
            seq.addObject(new DERTaggedObject(0, distributionPoint));
        }

        if (reasons != null)
        {
            seq.addObject(new DERTaggedObject(1, reasons));
        }

        if (cRLIssuer != null)
        {
            seq.addObject(new DERTaggedObject(2, cRLIssuer));
        }
    }

    /**
     * <pre>
     * DistributionPoint ::= SEQUENCE {
     *      distributionPoint [0] DistributionPointName OPTIONAL,
     *      reasons           [1] ReasonFlags OPTIONAL,
     *      cRLIssuer         [2] GeneralNames OPTIONAL
     * }
     * </pre>
     */
    public DERObject getDERObject()
    {
        return seq;
    }
}
