package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.*;

public class CRLDistPoint
    implements DEREncodable
{
    DERConstructedSequence  seq = null;

    public CRLDistPoint(
        DistributionPoint[] points)
    {
        seq = new DERConstructedSequence();

        for (int i = 0; i != points.length; i++)
        {
            seq.addObject(points[i]);
        }
    }

    /**
     * <pre>
     * CRLDistPoint ::= SEQUENCE SIZE {1..MAX} OF DistributionPoint
     * </pre>
     */
    public DERObject getDERObject()
    {
        return seq;
    }
}
