package org.bouncycastle.asn1.test;

import java.io.*;

import org.bouncycastle.util.encoders.*;
import org.bouncycastle.util.test.*;

import org.bouncycastle.asn1.*;
import org.bouncycastle.asn1.pkcs.*;

public class PKCS10Test
	implements Test
{
	byte[]	req = Base64.decode(
				"MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNF"
			+   "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3Gux"
			+   "Z7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EA"
			+   "NDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDU"
			+   "KCjOuBL38Q==");

	public String getName()
	{
		return "PKCS10";
	}
	
	public TestResult perform()
	{
		try
		{
			ByteArrayInputStream	bIn = new ByteArrayInputStream(req);
			DERInputStream			dIn = new DERInputStream(bIn);

			CertificationRequest	r = new CertificationRequest((DERConstructedSequence)dIn.readObject());

			ByteArrayOutputStream	bOut = new ByteArrayOutputStream();
			DEROutputStream			dOut = new DEROutputStream(bOut);

			dOut.writeObject(r.getDERObject());

			byte[]					bytes = bOut.toByteArray();

			if (bytes.length != req.length)
			{
        		return new SimpleTestResult(false, getName() + ": failed length test");
			}

			for (int i = 0; i != req.length; i++)
			{
				if (bytes[i] != req[i])
				{
					return new SimpleTestResult(false, getName() + ": failed comparison test");
				}
			}
		}
		catch (Exception e)
		{
        	return new SimpleTestResult(false, getName() + ": Exception - " + e.toString());
		}

        return new SimpleTestResult(true, getName() + ": Okay");
    }

    public static void main(
        String[]    args)
    {
        Test    test = new PKCS10Test();

        TestResult  result = test.perform();

        System.out.println(result);
    }
}
