package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * UserKeyingMaterial ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class UserKeyingMaterial implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString material;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public UserKeyingMaterial(byte[] _material) {
		setMaterial(_material);
	}
	
	public UserKeyingMaterial(DEROctetString _material) {
		material = _material;
	}

	public UserKeyingMaterial(UserKeyingMaterial _orig) {
		material = _orig.material;
	}

	public static UserKeyingMaterial getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof UserKeyingMaterial) {
			return (UserKeyingMaterial)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new UserKeyingMaterial((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid UserKeyingMaterial");
	} 

	public static UserKeyingMaterial newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof UserKeyingMaterial) {
			return new UserKeyingMaterial((UserKeyingMaterial)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new UserKeyingMaterial((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid UserKeyingMaterial");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getMaterial() {
		return material.getOctets();
	}

	private void setMaterial(byte[] _material) {
		material = new DEROctetString(_material);
	}



	public DERObject getDERObject() {
		return material;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
