package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * UnauthAttributes ::= SET SIZE (1..MAX) OF Attribute
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class UnauthAttributes implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */
	
	private DERConstructedSet attributes;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public UnauthAttributes(Vector _attributes) {
		setAttributes(_attributes);
	}

	public UnauthAttributes(DERConstructedSet _attributes) {
		attributes = _attributes;
	}

	public UnauthAttributes(UnauthAttributes _orig) {
		attributes = _orig.attributes;
	}

	public static UnauthAttributes getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof UnauthAttributes) {
			return (UnauthAttributes)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new UnauthAttributes((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid UnauthAttributes");
	}

	public static UnauthAttributes newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof UnauthAttributes) {
			return new UnauthAttributes((UnauthAttributes)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new UnauthAttributes((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid UnauthAttributes");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getAttributes() {
		int    _len = attributes.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(Attribute.getInstance(attributes.getObjectAt(i)));
		}
		return _res;
	}

	private void setAttributes(Vector _attributes) {
		int _len   = _attributes.size();
		attributes = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			attributes.addObject(Attribute.getInstance(_attributes.elementAt(i)));
		}
	}
	
	public DERObject getDERObject() {
		return attributes;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
