package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERUTCTime;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * Time ::= CHOICE {
 * 	utcTime UTCTime,
 * 	generalTime GeneralizedTime 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class Time implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERObject time;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public Time(DERUTCTime _time) {
		time = _time;
	}

	public Time(DERGeneralizedTime _time) {
		time = _time;
	}

	public Time(Time _orig) {
		time = _orig.time;
	}

	public static Time getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Time) {
			return (Time)_obj;
		}
		
		if(_obj instanceof DERUTCTime) {
			return new Time((DERUTCTime)_obj);
		}

		if(_obj instanceof DERGeneralizedTime) {
			return new Time((DERGeneralizedTime)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Time");
	} 

	public static Time newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Time) {
			return new Time((Time)_obj);
		}
		
		if(_obj instanceof DERUTCTime) {
			return new Time((DERUTCTime)_obj);
		}

		if(_obj instanceof DERGeneralizedTime) {
			return new Time((DERGeneralizedTime)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Time");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DERObject getTime() {
		return time;
	}
	
	private void setTime(DERUTCTime _time) {
		time = _time;
	}

	private void setTime(DERGeneralizedTime _time) {
		time = _time;
	}

	public DERObject getDERObject() {
		return time;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
