package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SubjectKeyIdentifier ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SubjectKeyIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString id;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SubjectKeyIdentifier(byte[] _id) {
		setId(_id);
	}
	
	public SubjectKeyIdentifier(DEROctetString _id) {
		id = _id;
	}

	public SubjectKeyIdentifier(SubjectKeyIdentifier _orig) {
		id = _orig.id;
	}

	public static SubjectKeyIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SubjectKeyIdentifier) {
			return (SubjectKeyIdentifier)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new SubjectKeyIdentifier((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SubjectKeyIdentifier");
	}

	public static SubjectKeyIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SubjectKeyIdentifier) {
			return new SubjectKeyIdentifier((SubjectKeyIdentifier)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new SubjectKeyIdentifier((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SubjectKeyIdentifier");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getId() {
		return id.getOctets();
	}
	
	private void setId(byte[] _id) {
		id = new DEROctetString(_id);
	}
	
	public DERObject getDERObject() {
		return id;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
